---
layout: post
title: ESLint v5.3.0 released
teaser: "We just pushed ESLint v5.3.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - not-an-aardvark
categories:
  - Release Notes
---

## Highlights

Four new rules have been added:

* [`no-misleading-character-class`](/docs/rules/no-misleading-character-class) reports multi-code-point characters in regular expression character classes. Using these characters in character classes often results in surprising behavior.
* [`require-atomic-updates`](/docs/rules/require-atomic-updates) reports potential race conditions that result from updating values in async or generator functions.
* [`no-async-promise-executor`](/docs/rules/no-async-promise-executor) reports uses of the `Promise` constructor that have an `async` function as the argument. Using an `async` function in this scenario is not necessary and a potential source of bugs.
* [`require-unicode-regexp`](/docs/rules/require-unicode-regexp) requires all regular expressions to have the `u` flag. Regular expressions with the `u` flag have stricter parsing rules and handle unicode text more sensibly, which is useful to avoid unexpected behavior when writing regular expressions.

## Features


* [6eb972c](https://github.com/eslint/eslint/commit/6eb972c) New: [require-unicode-regexp](/docs/rules/require-unicode-regexp) rule (fixes [#9961](https://github.com/eslint/eslint/issues/9961)) ([#10698](https://github.com/eslint/eslint/issues/10698)) (Toru Nagashima)
* [2cc3240](https://github.com/eslint/eslint/commit/2cc3240) New: add [no-misleading-character-class](/docs/rules/no-misleading-character-class) (fixes [#10049](https://github.com/eslint/eslint/issues/10049)) ([#10511](https://github.com/eslint/eslint/issues/10511)) (Toru Nagashima)
* [9e93d46](https://github.com/eslint/eslint/commit/9e93d46) New: add [no-async-promise-executor](/docs/rules/no-async-promise-executor) rule (fixes [#10217](https://github.com/eslint/eslint/issues/10217)) ([#10661](https://github.com/eslint/eslint/issues/10661)) (Teddy Katz)
* [5a2538c](https://github.com/eslint/eslint/commit/5a2538c) New: [require-atomic-updates](/docs/rules/require-atomic-updates) rule (fixes [#10405](https://github.com/eslint/eslint/issues/10405)) ([#10655](https://github.com/eslint/eslint/issues/10655)) (Teddy Katz)




## Enhancements


* [e37a593](https://github.com/eslint/eslint/commit/e37a593) Update: Fix incorrect default value for position ([#10670](https://github.com/eslint/eslint/issues/10670)) (Iulian Onofrei)
* [f026fe1](https://github.com/eslint/eslint/commit/f026fe1) Update: Fix 'function' in [padding-line-between-statements](/docs/rules/padding-line-between-statements) (fixes [#10487](https://github.com/eslint/eslint/issues/10487)) ([#10676](https://github.com/eslint/eslint/issues/10676)) (Kevin Partington)
* [9e76be7](https://github.com/eslint/eslint/commit/9e76be7) Update: [indent](/docs/rules/indent) comments w/ nearby code if no blank lines (fixes [#9733](https://github.com/eslint/eslint/issues/9733)) ([#10640](https://github.com/eslint/eslint/issues/10640)) (Kevin Partington)




## Bug Fixes


* [5c5d64d](https://github.com/eslint/eslint/commit/5c5d64d) Fix: ignored-paths for Windows path (fixes [#10687](https://github.com/eslint/eslint/issues/10687)) ([#10691](https://github.com/eslint/eslint/issues/10691)) (Toru Nagashima)
* [d56c39d](https://github.com/eslint/eslint/commit/d56c39d) Fix: ESLint cache no longer stops autofix (fixes [#10679](https://github.com/eslint/eslint/issues/10679)) ([#10694](https://github.com/eslint/eslint/issues/10694)) (Kevin Partington)
* [877f4b8](https://github.com/eslint/eslint/commit/877f4b8) Fix: The "../.." folder is always ignored (fixes [#10675](https://github.com/eslint/eslint/issues/10675)) ([#10682](https://github.com/eslint/eslint/issues/10682)) (Sridhar)
* [8b83d2b](https://github.com/eslint/eslint/commit/8b83d2b) Fix: always resolve default ignore patterns from CWD (fixes [#9227](https://github.com/eslint/eslint/issues/9227)) ([#10638](https://github.com/eslint/eslint/issues/10638)) (Teddy Katz)
* [acb6658](https://github.com/eslint/eslint/commit/acb6658) Fix: ESLint crash with [prefer-object-spread](/docs/rules/prefer-object-spread) (fixes [#10646](https://github.com/eslint/eslint/issues/10646)) ([#10649](https://github.com/eslint/eslint/issues/10649)) (薛定谔的猫)




## Documentation


* [dd6cb19](https://github.com/eslint/eslint/commit/dd6cb19) Docs: Updated [no-return-await](/docs/rules/no-return-await) Rule Documentation (fixes [#9695](https://github.com/eslint/eslint/issues/9695)) ([#10699](https://github.com/eslint/eslint/issues/10699)) (Marla Foreman)
* [863aa78](https://github.com/eslint/eslint/commit/863aa78) Docs: add another example for when not to use [no-await-in-loop](/docs/rules/no-await-in-loop) ([#10714](https://github.com/eslint/eslint/issues/10714)) (Valeri Karpov)
* [6e78b7d](https://github.com/eslint/eslint/commit/6e78b7d) Docs: remove links to terminated jscs.info domain ([#10706](https://github.com/eslint/eslint/issues/10706)) (Piotr Kuczynski)
* [8084bfc](https://github.com/eslint/eslint/commit/8084bfc) Docs: change when not to use object spread ([#10621](https://github.com/eslint/eslint/issues/10621)) (Benny Powers)
* [c2bb8bb](https://github.com/eslint/eslint/commit/c2bb8bb) Docs: Remove superfluous object option sample code ([#10652](https://github.com/eslint/eslint/issues/10652)) (Iulian Onofrei)
* [d34a13b](https://github.com/eslint/eslint/commit/d34a13b) Docs: add subheader in configuring/configuring-rules ([#10686](https://github.com/eslint/eslint/issues/10686)) (薛定谔的猫)
* [99fb7d3](https://github.com/eslint/eslint/commit/99fb7d3) Docs: fix misleading [no-prototype-builtins](/docs/rules/no-prototype-builtins) description ([#10666](https://github.com/eslint/eslint/issues/10666)) (薛定谔的猫)
* [005b849](https://github.com/eslint/eslint/commit/005b849) Docs: fix outdated description of `baseConfig` option ([#10657](https://github.com/eslint/eslint/issues/10657)) (Teddy Katz)
* [15a77c4](https://github.com/eslint/eslint/commit/15a77c4) Docs: fix broken links (fixes eslint/eslint-jp[#6](https://github.com/eslint/eslint/issues/6)) ([#10658](https://github.com/eslint/eslint/issues/10658)) (Toru Nagashima)
* [87cd344](https://github.com/eslint/eslint/commit/87cd344) Docs: Make marking a default option consistent with other rules ([#10650](https://github.com/eslint/eslint/issues/10650)) (Iulian Onofrei)
* [b6daf0e](https://github.com/eslint/eslint/commit/b6daf0e) Docs: Remove superfluous section from [no-unsafe-negation](/docs/rules/no-unsafe-negation) ([#10648](https://github.com/eslint/eslint/issues/10648)) (Iulian Onofrei)






## Build Related


* [5f6a765](https://github.com/eslint/eslint/commit/5f6a765) Build: ensure URL fragments remain in documentation links (fixes [#10717](https://github.com/eslint/eslint/issues/10717)) ([#10720](https://github.com/eslint/eslint/issues/10720)) (Teddy Katz)




## Chores


* [6009239](https://github.com/eslint/eslint/commit/6009239) Chore: rename utils for consistency ([#10727](https://github.com/eslint/eslint/issues/10727)) (薛定谔的猫)
* [5984820](https://github.com/eslint/eslint/commit/5984820) Chore: Move lib/file-finder.js to lib/util/ (refs [#10559](https://github.com/eslint/eslint/issues/10559)) ([#10695](https://github.com/eslint/eslint/issues/10695)) (Kevin Partington)
* [7f496e2](https://github.com/eslint/eslint/commit/7f496e2) Chore: Update require path for ast-utils ([#10693](https://github.com/eslint/eslint/issues/10693)) (Kevin Partington)
* [648a33a](https://github.com/eslint/eslint/commit/648a33a) Chore: reorganize code structure of utilities (refs [#10599](https://github.com/eslint/eslint/issues/10599)) ([#10680](https://github.com/eslint/eslint/issues/10680)) (薛定谔的猫)
* [d8aea28](https://github.com/eslint/eslint/commit/d8aea28) Chore: rm unnecessary plugin in eslint-config-eslint ([#10685](https://github.com/eslint/eslint/issues/10685)) (薛定谔的猫)
* [0cb5e3e](https://github.com/eslint/eslint/commit/0cb5e3e) Chore: Replace some function application with spread operators ([#10645](https://github.com/eslint/eslint/issues/10645)) (Kevin Partington)
* [e1a3cac](https://github.com/eslint/eslint/commit/e1a3cac) Chore: rm deprecated experimentalObjectRestSpread option in tests ([#10647](https://github.com/eslint/eslint/issues/10647)) (薛定谔的猫)
