---
layout: post
title: ESLint v5.2.0 released
teaser: "We just pushed ESLint v5.2.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - not-an-aardvark
categories:
  - Release Notes
---

## Highlights

* When using the `--cache` flag, the results for files with linting errors are now saved to the cache. This should result in improved performance when using `--cache` on a codebase with existing linting errors.


## Enhancements


* [81283d0](https://github.com/eslint/eslint/commit/81283d0) Update: Cache files that failed linting (fixes [#9948](https://github.com/eslint/eslint/issues/9948)) ([#10571](https://github.com/eslint/eslint/issues/10571)) (Kevin Partington)






## Documentation


* [9f93d5f](https://github.com/eslint/eslint/commit/9f93d5f) Docs: Updated Working with Custom Formatters (fixes [#9950](https://github.com/eslint/eslint/issues/9950)) ([#10592](https://github.com/eslint/eslint/issues/10592)) (Marla Foreman)




## Dependency Upgrades


* [13cc63e](https://github.com/eslint/eslint/commit/13cc63e) Upgrade: ignore@4.0.2 ([#10619](https://github.com/eslint/eslint/issues/10619)) (Rouven Weßling)
* [761f802](https://github.com/eslint/eslint/commit/761f802) Upgrade: eslint-plugin-node to 7.0.1 ([#10612](https://github.com/eslint/eslint/issues/10612)) (Toru Nagashima)




## Build Related


* [c517b2a](https://github.com/eslint/eslint/commit/c517b2a) Build: fix npm run perf failing(fixes [#10577](https://github.com/eslint/eslint/issues/10577)) ([#10607](https://github.com/eslint/eslint/issues/10607)) (薛定谔的猫)
* [80b296e](https://github.com/eslint/eslint/commit/80b296e) Build: package.json update for eslint-config-eslint release (ESLint Jenkins)
* [64dfa21](https://github.com/eslint/eslint/commit/64dfa21) Build: Fix prerelease logic in blog post generation (fixes [#10578](https://github.com/eslint/eslint/issues/10578)) ([#10581](https://github.com/eslint/eslint/issues/10581)) (Kevin Partington)




## Chores


* [ac77a80](https://github.com/eslint/eslint/commit/ac77a80) Chore: Fixing a call to Object.assign.apply in Linter ([#10629](https://github.com/eslint/eslint/issues/10629)) (Kevin Partington)
* [e596939](https://github.com/eslint/eslint/commit/e596939) Chore: fix redundant equality check ([#10617](https://github.com/eslint/eslint/issues/10617)) (Toru Nagashima)
* [9aaf195](https://github.com/eslint/eslint/commit/9aaf195) Chore: Extract lint result cache logic (refs [#9948](https://github.com/eslint/eslint/issues/9948)) ([#10562](https://github.com/eslint/eslint/issues/10562)) (Kevin Partington)
* [e4e7ff2](https://github.com/eslint/eslint/commit/e4e7ff2) Chore: fix error message in eslint-config-eslint ([#10588](https://github.com/eslint/eslint/issues/10588)) (薛定谔的猫)
* [1e88170](https://github.com/eslint/eslint/commit/1e88170) Chore: Move lib/logging and lib/timing to lib/util/ (refs [#10559](https://github.com/eslint/eslint/issues/10559)) ([#10579](https://github.com/eslint/eslint/issues/10579)) (Kevin Partington)
* [0faf633](https://github.com/eslint/eslint/commit/0faf633) Chore: Simplify helper method in Linter tests ([#10580](https://github.com/eslint/eslint/issues/10580)) (Kevin Partington)
