---
layout: post
title: ESLint v5.0.0 released
teaser: "We just pushed ESLint v5.0.0, which is a major release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release. This release also has some breaking changes, so please read the following closely."
image: release-notes-major.png
tags:
  - release
  - minor
authors:
  - not-an-aardvark
categories:
  - Release Notes
---

## Highlights

* There are several breaking changes in 5.0.0. We've created a [migration guide](/docs/user-guide/migrating-to-5.0.0) to explain the breaking changes and describe how to upgrade.
* Three new rules have been added:
    * [`prefer-object-spread`](/docs/rules/prefer-object-spread)
    * [`max-classes-per-file`](/docs/rules/max-classes-per-file)
    * [`max-lines-per-function`](/docs/rules/max-lines-per-function)
* The [`CLIEngine.executeOnFiles`](/docs/developer-guide/nodejs-api#cliengineexecuteonfiles) API now has a `globInputPaths` option.
* The [`one-var`](/docs/rules/one-var) rule is now autofixable.
* The [`array-element-newline`](/docs/rules/array-element-newline) rule now has a `consistent` option.
* The [`camelcase`](/docs/rules/camelcase) rule now has an `ignoreDestructuring` option.
* The [`valid-jsdoc`](/docs/rules/valid-jsdoc) rule now has a `requireParamType` option.
* The [`func-name-matching`](/docs/rules/func-name-matching) rule now has a `considerPropertyDescriptor` option.

---

Changes since v5.0.0-rc.0:


## Features


* [0feedfd](https://github.com/eslint/eslint/commit/0feedfd) New: Added [max-lines-per-function](/docs/rules/max-lines-per-function) rule (fixes [#9842](https://github.com/eslint/eslint/issues/9842)) ([#10188](https://github.com/eslint/eslint/issues/10188)) (peteward44)




## Enhancements


* [7a7580b](https://github.com/eslint/eslint/commit/7a7580b) Update: Add considerPropertyDescriptor option to [func-name-matching](/docs/rules/func-name-matching) ([#9078](https://github.com/eslint/eslint/issues/9078)) (Dieter Luypaert)




## Bug Fixes


* [f93d6ff](https://github.com/eslint/eslint/commit/f93d6ff) Fix: do not fail on unknown operators from custom parsers (fixes [#10475](https://github.com/eslint/eslint/issues/10475)) ([#10476](https://github.com/eslint/eslint/issues/10476)) (Rubén Norte)
* [05343fd](https://github.com/eslint/eslint/commit/05343fd) Fix: add parens for yield statement (fixes [#10432](https://github.com/eslint/eslint/issues/10432)) ([#10468](https://github.com/eslint/eslint/issues/10468)) (Pig Fang)
* [d477c5e](https://github.com/eslint/eslint/commit/d477c5e) Fix: check destructuring for "[no-shadow-restricted-names](/docs/rules/no-shadow-restricted-names)" (fixes [#10467](https://github.com/eslint/eslint/issues/10467)) ([#10470](https://github.com/eslint/eslint/issues/10470)) (Pig Fang)
* [e0a0418](https://github.com/eslint/eslint/commit/e0a0418) Fix: crash on optional catch binding ([#10429](https://github.com/eslint/eslint/issues/10429)) (Toru Nagashima)




## Documentation


* [077358b](https://github.com/eslint/eslint/commit/077358b) Docs: [no-process-exit](/docs/rules/no-process-exit): recommend process.exitCode ([#10478](https://github.com/eslint/eslint/issues/10478)) (Andres Kalle)
* [de4dba9](https://github.com/eslint/eslint/commit/de4dba9) Docs: styling team members ([#10460](https://github.com/eslint/eslint/issues/10460)) (薛定谔的猫)
* [5e453a3](https://github.com/eslint/eslint/commit/5e453a3) Docs: display team members in tables. ([#10433](https://github.com/eslint/eslint/issues/10433)) (薛定谔的猫)
* [b1895eb](https://github.com/eslint/eslint/commit/b1895eb) Docs: Restore intentional spelling mistake ([#10459](https://github.com/eslint/eslint/issues/10459)) (Wilfred Hughes)




## Dependency Upgrades


* [daefbdb](https://github.com/eslint/eslint/commit/daefbdb) Upgrade: eslint-scope and espree to 4.0.0 (refs [#10458](https://github.com/eslint/eslint/issues/10458)) ([#10500](https://github.com/eslint/eslint/issues/10500)) (Brandon Mills)
