---
layout: post
title: ESLint v5.0.0-rc.0 released
teaser: "We just pushed ESLint v5.0.0-rc.0, which is a major release candidate of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes-beta.png
tags:
  - release
  - minor
authors:
  - platinumazure
categories:
  - Release Notes
---

Note: This version of ESLint is not ready for production use and is provided to gather feedback from the community before releasing the final version. Please let us know if you having any problems or feedback by creating issues on our [GitHub repo](https://github.com/eslint/eslint) or joining our [Gitter channel](https://gitter.im/eslint/eslint).

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Installing

Since this is a pre-release version, you will not automatically be upgraded by npm. You must specify the `next` tag when installing:

```
npm i eslint@next --save-dev
```

You can also specify the version directly:

```
npm i eslint@5.0.0-rc.0 --save-dev
```

### Migration Guide

As there are a lot of changes, we've created a [migration guide](/docs/5.0.0/user-guide/migrating-to-5.0.0) describing the changes in great detail along with the steps you should take to address them. We expect that most users should be able to upgrade without any build changes, but the migration guide should be a useful resource if you encounter problems.

## Enhancements


* [abf400d](https://github.com/eslint/eslint/commit/abf400d) Update: Add ignoreDestructing option to [camelcase](/docs/rules/camelcase) rule (fixes [#9807](https://github.com/eslint/eslint/issues/9807)) ([#10373](https://github.com/eslint/eslint/issues/10373)) (Andrew Lunny)
* [640bf07](https://github.com/eslint/eslint/commit/640bf07) Update: Fixes multiline [no-warning-comments](/docs/rules/no-warning-comments) rule. (fixes [#9884](https://github.com/eslint/eslint/issues/9884)) ([#10381](https://github.com/eslint/eslint/issues/10381)) (Scott Stern)
* [dc4075e](https://github.com/eslint/eslint/commit/dc4075e) Update: fix false negative in [no-use-before-define](/docs/rules/no-use-before-define) (fixes [#10227](https://github.com/eslint/eslint/issues/10227)) ([#10396](https://github.com/eslint/eslint/issues/10396)) (Toru Nagashima)
* [917108d](https://github.com/eslint/eslint/commit/917108d) Update: Add requireParamType option to [valid-jsdoc](/docs/rules/valid-jsdoc) (fixes [#6753](https://github.com/eslint/eslint/issues/6753)) ([#10220](https://github.com/eslint/eslint/issues/10220)) (Tomasz Sterna)




## Bug Fixes


* [fe8bec3](https://github.com/eslint/eslint/commit/fe8bec3) Fix: fix writing config file when `source` is `prompt` ([#10422](https://github.com/eslint/eslint/issues/10422)) (Pig Fang)
* [3e9f33a](https://github.com/eslint/eslint/commit/3e9f33a) Fix: prevent crashing from JSON parsing error (fixes [#10364](https://github.com/eslint/eslint/issues/10364)) ([#10376](https://github.com/eslint/eslint/issues/10376)) (Pig Fang)
* [636457d](https://github.com/eslint/eslint/commit/636457d) Fix: parse later ES files in `eslint --init` (fixes [#10003](https://github.com/eslint/eslint/issues/10003)) ([#10378](https://github.com/eslint/eslint/issues/10378)) (Pig Fang)




## Documentation


* [3721841](https://github.com/eslint/eslint/commit/3721841) Docs: Add new experimental syntax policy to README (fixes [#9804](https://github.com/eslint/eslint/issues/9804)) ([#10408](https://github.com/eslint/eslint/issues/10408)) (Kevin Partington)
* [d0aae3c](https://github.com/eslint/eslint/commit/d0aae3c) Docs: Create docs landing page ([#10453](https://github.com/eslint/eslint/issues/10453)) (Kevin Partington)
* [1984c21](https://github.com/eslint/eslint/commit/1984c21) Docs: move custom parsers docs into a page (fixes [#9919](https://github.com/eslint/eslint/issues/9919)) ([#10431](https://github.com/eslint/eslint/issues/10431)) (Pig Fang)
* [400d4b5](https://github.com/eslint/eslint/commit/400d4b5) Docs: Add rest and spread operator changes to migration guide ([#10416](https://github.com/eslint/eslint/issues/10416)) (Yannick Croissant)




## Dependency Upgrades


* [e2b394d](https://github.com/eslint/eslint/commit/e2b394d) Upgrade: espree and eslint-scope to rc versions ([#10457](https://github.com/eslint/eslint/issues/10457)) (Kevin Partington)
* [e7bdd02](https://github.com/eslint/eslint/commit/e7bdd02) Upgrade: Consume espree@4.0.0-alpha.1 ([#10410](https://github.com/eslint/eslint/issues/10410)) (Kevin Partington)




## Build Related


* [831c39a](https://github.com/eslint/eslint/commit/831c39a) Build: Adding rc release script to package.json ([#10456](https://github.com/eslint/eslint/issues/10456)) (Kevin Partington)




## Chores


* [a370da2](https://github.com/eslint/eslint/commit/a370da2) Chore: small opt to improve readability ([#10241](https://github.com/eslint/eslint/issues/10241)) (薛定谔的猫)
