---
layout: post
title: ESLint v5.0.0-alpha.4 released
teaser: "We just pushed ESLint v5.0.0-alpha.4, which is a major release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes-beta.png
tags:
  - release
  - minor
authors:
  - btmills
categories:
  - Release Notes
---

Note: This version of ESLint is not ready for production use and is provided to gather feedback from the community before releasing the final version. Please let us know if you having any problems or feedback by creating issues on our [GitHub repo](https://github.com/eslint/eslint) or joining our [Gitter channel](https://gitter.im/eslint/eslint).

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Installing

Since this is a pre-release version, you will not automatically be upgraded by npm. You must specify the `next` tag when installing:

```
npm i eslint@next --save-dev
```

You can also specify the version directly:

```
npm i eslint@5.0.0-alpha.4 --save-dev
```

### Migration Guide

As there are a lot of changes, we've created a [migration guide](/docs/5.0.0/user-guide/migrating-to-5.0.0) describing the changes in great detail along with the steps you should take to address them. We expect that most users should be able to upgrade without any build changes, but the migration guide should be a useful resource if you encounter problems.






## Features


* [465e615](https://github.com/eslint/eslint/commit/465e615) New: prompt users before installing dependencies ([#10353](https://github.com/eslint/eslint/issues/10353)) (Pig Fang)




## Enhancements


* [93c9a52](https://github.com/eslint/eslint/commit/93c9a52) Update: config-validator should validate overrides ([#10357](https://github.com/eslint/eslint/issues/10357)) (Toru Nagashima)
* [c2e0398](https://github.com/eslint/eslint/commit/c2e0398) Update: Improves the [prefer-object-spread](/docs/rules/prefer-object-spread) rule by removing extraneous visitors ([#10351](https://github.com/eslint/eslint/issues/10351)) (Sharmila Jesupaul)
* [d848949](https://github.com/eslint/eslint/commit/d848949) Update: Support JSXFragment node (fixes [#9662](https://github.com/eslint/eslint/issues/9662)) ([#9664](https://github.com/eslint/eslint/issues/9664)) (Clement Hoang)
* [9c922ce](https://github.com/eslint/eslint/commit/9c922ce) Update: Add "consistent" option to [array-element-newline](/docs/rules/array-element-newline) (fixes [#9457](https://github.com/eslint/eslint/issues/9457)) ([#10355](https://github.com/eslint/eslint/issues/10355)) (Pig Fang)




## Bug Fixes


* [240c1a4](https://github.com/eslint/eslint/commit/240c1a4) Fix: [prefer-const](/docs/rules/prefer-const) object destructuring false positive (fixes [#9108](https://github.com/eslint/eslint/issues/9108)) ([#10368](https://github.com/eslint/eslint/issues/10368)) (Pig Fang)
* [65bce3a](https://github.com/eslint/eslint/commit/65bce3a) Fix: ensure --stdin flag works when stdin is piped asynchronously ([#10393](https://github.com/eslint/eslint/issues/10393)) (Teddy Katz)
* [8b7a70c](https://github.com/eslint/eslint/commit/8b7a70c) Fix: handle [one-var](/docs/rules/one-var) with no semicolon (fixes [#10330](https://github.com/eslint/eslint/issues/10330)) ([#10371](https://github.com/eslint/eslint/issues/10371)) (Malcolm Groves)
* [fb148aa](https://github.com/eslint/eslint/commit/fb148aa) Fix: allow no tokens after `return` keyword (fixes [#10372](https://github.com/eslint/eslint/issues/10372)) ([#10379](https://github.com/eslint/eslint/issues/10379)) (Pig Fang)
* [a812845](https://github.com/eslint/eslint/commit/a812845) Fix: allow array spread for [prefer-object-spread](/docs/rules/prefer-object-spread) rule (fixes [#10344](https://github.com/eslint/eslint/issues/10344)) ([#10347](https://github.com/eslint/eslint/issues/10347)) (Pig Fang)




## Documentation


* [ce3e62a](https://github.com/eslint/eslint/commit/ce3e62a) Docs: remove test coverage badge ([#10407](https://github.com/eslint/eslint/issues/10407)) (薛定谔的猫)
* [074bc1c](https://github.com/eslint/eslint/commit/074bc1c) Docs: polish for [max-classes-per-file](/docs/rules/max-classes-per-file) rule ([#10377](https://github.com/eslint/eslint/issues/10377)) (Pig Fang)
* [448fc52](https://github.com/eslint/eslint/commit/448fc52) Docs: Update link to Integrations / Build tools / Start ([#10354](https://github.com/eslint/eslint/issues/10354)) (Kir Belevich)






## Build Related


* [f268128](https://github.com/eslint/eslint/commit/f268128) Build: add Node v10 to travis ([#10262](https://github.com/eslint/eslint/issues/10262)) (alberto)




## Chores


* [b9b23a9](https://github.com/eslint/eslint/commit/b9b23a9) Chore: rm unused argument ([#10400](https://github.com/eslint/eslint/issues/10400)) (薛定谔的猫)
* [e25fc22](https://github.com/eslint/eslint/commit/e25fc22) Chore: remove assert.doesNotThrow in tests ([#10199](https://github.com/eslint/eslint/issues/10199)) (Ruben Bridgewater)
* [4e5e9be](https://github.com/eslint/eslint/commit/4e5e9be) Chore: avoid unnecessary filesystem accesses during config search ([#10359](https://github.com/eslint/eslint/issues/10359)) (Teddy Katz)
* [363da01](https://github.com/eslint/eslint/commit/363da01) Chore: avoid code duplication in rule severity checking ([#10358](https://github.com/eslint/eslint/issues/10358)) (Teddy Katz)
