---
layout: post
title: ESLint v5.0.0-alpha.3 released
teaser: "We just pushed ESLint v5.0.0-alpha.3, which is a major release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release.This release also has some breaking changes, so please read the following closely."
image: release-notes-beta.png
tags:
  - release
  - major
authors:
  - not-an-aardvark
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

* Two new rules have been added: [`prefer-object-spread`](/docs/5.0.0/rules/prefer-object-spread) and [`max-classes-per-file`](/docs/5.0.0/rules/max-classes-per-file)
* The [`CLIEngine`](https://eslint.org/docs/5.0.0/developer-guide/nodejs-api#cliengine) API now supports a `globInputPaths` option to disable glob resolution when linting files.

### Installing

Since this is a pre-release version, you will not automatically be upgraded by npm. You must specify the `next` tag when installing:

```
npm i eslint@next --save-dev
```

You can also specify the version directly:

```
npm i eslint@5.0.0-alpha.3 --save-dev
```

### Migration Guide

As there are a lot of changes, we've created a [migration guide](/docs/5.0.0/user-guide/migrating-to-5.0.0) describing the changes in great detail along with the steps you should take to address them. We expect that most users should be able to upgrade without any build changes, but the migration guide should be a useful resource if you encounter problems.

## Breaking Changes


* [41f0f6e](https://github.com/eslint/eslint/commit/41f0f6e) Breaking: report multiline eslint-disable-line directives (fixes [#10334](https://github.com/eslint/eslint/issues/10334)) ([#10335](https://github.com/eslint/eslint/issues/10335)) (Teddy Katz)
* [09dde26](https://github.com/eslint/eslint/commit/09dde26) Breaking: new [object-curly-newline](/docs/rules/object-curly-newline)/[no-self-assign](/docs/rules/no-self-assign) default (fixes [#10215](https://github.com/eslint/eslint/issues/10215)) ([#10337](https://github.com/eslint/eslint/issues/10337)) (Teddy Katz)




## Features


* [1a6b399](https://github.com/eslint/eslint/commit/1a6b399) New: Adds [prefer-object-spread](/docs/5.0.0/rules/prefer-object-spread) rule (refs: [#7230](https://github.com/eslint/eslint/issues/7230)) ([#9955](https://github.com/eslint/eslint/issues/9955)) (Sharmila Jesupaul)
* [c4109b2](https://github.com/eslint/eslint/commit/c4109b2) New: add [max-classes-per-file](/docs/5.0.0/rules/max-classes-per-file) rule ([#10163](https://github.com/eslint/eslint/issues/10163)) (James Garbutt)
* [514013c](https://github.com/eslint/eslint/commit/514013c) New: Add `globInputPaths` CLIEngine option (fixes [#9972](https://github.com/eslint/eslint/issues/9972)) ([#10191](https://github.com/eslint/eslint/issues/10191)) (Pierre Vanduynslager)




## Enhancements


* [e5b33be](https://github.com/eslint/eslint/commit/e5b33be) Update: Add --fix for [one-var](/docs/rules/one-var) rule (refs [#9072](https://github.com/eslint/eslint/issues/9072)) ([#10040](https://github.com/eslint/eslint/issues/10040)) (Sebastian Malton)




## Bug Fixes


* [d65f11d](https://github.com/eslint/eslint/commit/d65f11d) Fix: correct comma fix in spare array (fixes [#10273](https://github.com/eslint/eslint/issues/10273)) ([#10329](https://github.com/eslint/eslint/issues/10329)) (Malcolm Groves)
* [c343d86](https://github.com/eslint/eslint/commit/c343d86) Fix: do not autofix octal escape sequence (fixes [#10031](https://github.com/eslint/eslint/issues/10031)) ([#10240](https://github.com/eslint/eslint/issues/10240)) (Malcolm Groves)
* [bb6090f](https://github.com/eslint/eslint/commit/bb6090f) Fix: Throw error when --ignore-path not a file (fixes [#10076](https://github.com/eslint/eslint/issues/10076)) ([#10205](https://github.com/eslint/eslint/issues/10205)) (Malcolm Groves)




## Documentation


* [82757b2](https://github.com/eslint/eslint/commit/82757b2) Docs: Adding a little guidance to rule documentation ([#10301](https://github.com/eslint/eslint/issues/10301)) (Justin)
* [2f30aa5](https://github.com/eslint/eslint/commit/2f30aa5) Docs: add a better vim linting engine ([#10292](https://github.com/eslint/eslint/issues/10292)) (Jon Smithers)
* [df2c1fb](https://github.com/eslint/eslint/commit/df2c1fb) Docs: improve formatter guide (refs [#9550](https://github.com/eslint/eslint/issues/9550)) ([#10294](https://github.com/eslint/eslint/issues/10294)) (Dominic Lee)
* [a960d69](https://github.com/eslint/eslint/commit/a960d69) Docs: remove outdated notes from migration guide ([#10279](https://github.com/eslint/eslint/issues/10279)) (Teddy Katz)






## Build Related


* [1b6b2b2](https://github.com/eslint/eslint/commit/1b6b2b2) Build: remove trailing spaces in blogpost template ([#10280](https://github.com/eslint/eslint/issues/10280)) (Teddy Katz)




## Chores


* [4ccd25a](https://github.com/eslint/eslint/commit/4ccd25a) Chore: add eslint-plugin-node to eslint-config-eslint(fixes [#10319](https://github.com/eslint/eslint/issues/10319)) ([#10320](https://github.com/eslint/eslint/issues/10320)) (薛定谔的猫)
* [02e7b28](https://github.com/eslint/eslint/commit/02e7b28) Chore: upgrade deps ([#10339](https://github.com/eslint/eslint/issues/10339)) (薛定谔的猫)
* [1397179](https://github.com/eslint/eslint/commit/1397179) Chore: unskip test for scope analysis ([#10336](https://github.com/eslint/eslint/issues/10336)) (Teddy Katz)
* [99b842d](https://github.com/eslint/eslint/commit/99b842d) Chore: upgrade mock-fs@4.5.0 ([#10325](https://github.com/eslint/eslint/issues/10325)) (Tim Schaub)
* [fe91859](https://github.com/eslint/eslint/commit/fe91859) Chore: Update issue templates with new format ([#10309](https://github.com/eslint/eslint/issues/10309)) (Ilya Volodin)
* [f7330c1](https://github.com/eslint/eslint/commit/f7330c1) Chore: Add ESLint path to plugin-missing message ([#10283](https://github.com/eslint/eslint/issues/10283)) (Kevin Partington)
