---
layout: post
title: ESLint v5.0.0-alpha.2 released
teaser: "We just pushed ESLint v5.0.0-alpha.2, which is a major release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release. This release also has some breaking changes, so please read the following closely."
image: release-notes-beta.png
tags:
  - release
  - major
authors:
  - not-an-aardvark
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Installing

Since this is a pre-release version, you will not automatically be upgraded by npm. You must specify the `next` tag when installing:

```
npm i eslint@next --save-dev
```

You can also specify the version directly:

```
npm i eslint@5.0.0-alpha.2 --save-dev
```

### Migration Guide

As there are a lot of changes, we've created a [migration guide](/docs/5.0.0/user-guide/migrating-to-5.0.0) describing the changes in great detail along with the steps you should take to address them. We expect that most users should be able to upgrade without any build changes, but the migration guide should be a useful resource if you encounter problems.

## Breaking Changes


* [02e44a5](https://github.com/eslint/eslint/commit/02e44a5) Breaking: remove TDZ scopes (fixes [#10245](https://github.com/eslint/eslint/issues/10245)) ([#10270](https://github.com/eslint/eslint/issues/10270)) (Toru Nagashima)
* [c74933b](https://github.com/eslint/eslint/commit/c74933b) Breaking: remove extra check in getScope (fixes [#10246](https://github.com/eslint/eslint/issues/10246), fixes [#10247](https://github.com/eslint/eslint/issues/10247)) ([#10252](https://github.com/eslint/eslint/issues/10252)) (Toru Nagashima)
* [8b7c6ea](https://github.com/eslint/eslint/commit/8b7c6ea) Breaking: report fatal error for linting nonexistent files (fixes [#7390](https://github.com/eslint/eslint/issues/7390)) ([#10143](https://github.com/eslint/eslint/issues/10143)) (Teddy Katz)
* [9100819](https://github.com/eslint/eslint/commit/9100819) Breaking: fix plugin resolver in extends (fixes [#9904](https://github.com/eslint/eslint/issues/9904)) ([#10236](https://github.com/eslint/eslint/issues/10236)) (Toru Nagashima)
* [c45f1d0](https://github.com/eslint/eslint/commit/c45f1d0) Breaking: add rules to recommended (fixes [#8865](https://github.com/eslint/eslint/issues/8865)) ([#10158](https://github.com/eslint/eslint/issues/10158)) (薛定谔的猫)






## Enhancements


* [a82cbea](https://github.com/eslint/eslint/commit/a82cbea) Update: re-enable experimentalObjectRestSpread (fixes [#9990](https://github.com/eslint/eslint/issues/9990)) ([#10230](https://github.com/eslint/eslint/issues/10230)) (Toru Nagashima)




## Bug Fixes


* [1d443a0](https://github.com/eslint/eslint/commit/1d443a0) Fix: [valid-jsdoc](/docs/rules/valid-jsdoc) does not know async function returns (fixes [#9881](https://github.com/eslint/eslint/issues/9881)) ([#10161](https://github.com/eslint/eslint/issues/10161)) (Rachael Sim)
* [f9c7371](https://github.com/eslint/eslint/commit/f9c7371) Fix: do not autofix [object-shorthand](/docs/rules/object-shorthand) with comments (fixes [#10038](https://github.com/eslint/eslint/issues/10038)) ([#10238](https://github.com/eslint/eslint/issues/10238)) (Malcolm Groves)




## Documentation


* [510ca8b](https://github.com/eslint/eslint/commit/510ca8b) Docs: make grammatical tweaks in migration guide ([#10278](https://github.com/eslint/eslint/issues/10278)) (Teddy Katz)
* [8799972](https://github.com/eslint/eslint/commit/8799972) Docs: make template link wording more clear ([#10219](https://github.com/eslint/eslint/issues/10219)) (David Luzar)
* [4672b56](https://github.com/eslint/eslint/commit/4672b56) Docs: Correct wording in the `smart-tabs` docs page ([#10277](https://github.com/eslint/eslint/issues/10277)) (Jed Fox)
* [85a5191](https://github.com/eslint/eslint/commit/85a5191) Docs: Update JSCS FAQ ([#10221](https://github.com/eslint/eslint/issues/10221)) (alberto)
* [8e89d5c](https://github.com/eslint/eslint/commit/8e89d5c) Docs: Fix typo ([#10223](https://github.com/eslint/eslint/issues/10223)) (alberto)
* [c0c331e](https://github.com/eslint/eslint/commit/c0c331e) Docs: Add Prettier to FAQ ([#10222](https://github.com/eslint/eslint/issues/10222)) (alberto)
* [2443627](https://github.com/eslint/eslint/commit/2443627) Docs: add backticks in [getter-return](/docs/rules/getter-return) ([#10218](https://github.com/eslint/eslint/issues/10218)) (薛定谔的猫)
* [74bb5b5](https://github.com/eslint/eslint/commit/74bb5b5) Docs: Fix misspelling in changelog ([#10216](https://github.com/eslint/eslint/issues/10216)) (Kevin Partington)








## Chores


* [7c2e83a](https://github.com/eslint/eslint/commit/7c2e83a) Chore: improve tests and checking for equality ([#10182](https://github.com/eslint/eslint/issues/10182)) (Ruben Bridgewater)
* [b32d1f4](https://github.com/eslint/eslint/commit/b32d1f4) Chore: upgrade eslump@1.6.2 ([#10258](https://github.com/eslint/eslint/issues/10258)) (薛定谔的猫)
* [7938bf1](https://github.com/eslint/eslint/commit/7938bf1) Chore: update eslint-fuzzer ecmaVersion to 2018 ([#10255](https://github.com/eslint/eslint/issues/10255)) (薛定谔的猫)
* [a2953ec](https://github.com/eslint/eslint/commit/a2953ec) Chore: small opt to improve readability ([#10225](https://github.com/eslint/eslint/issues/10225)) (薛定谔的猫)
