---
layout: post
title: ESLint v5.0.0-alpha.1 released
teaser: "We just pushed ESLint v5.0.0-alpha.1, which is a major release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release. This release also has some breaking changes, so please read the following closely."
image: release-notes-beta.png
tags:
  - release
  - major
authors:
  - btmills
categories:
  - Release Notes
---

Note: This version of ESLint is not ready for production use and is provided to gather feedback from the community before releasing the final version. Please let us know if you having any problems or feedback by creating issues on our [GitHub repo](https://github.com/eslint/eslint) or joining our [Gitter channel](https://gitter.im/eslint/eslint).

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Installing

Since this is a pre-release version, you will not automatically be upgraded by npm. You must specify the `next` tag when installing:

```
npm i eslint@next --save-dev
```

You can also specify the version directly:

```
npm i eslint@5.0.0-alpha.1 --save-dev
```

### Migration Guide

As there are a lot of changes, we've created a [migration guide](/docs/5.0.0/user-guide/migrating-to-5.0.0) describing the changes in great detail along with the steps you should take to address them. We expect that most users should be able to upgrade without any build changes, but the migration guide should be a useful resource if you encounter problems.

## Breaking Changes


* [b2a48a9](https://github.com/eslint/eslint/commit/b2a48a9) Breaking: stop using fake `context._linter` property (fixes [#10140](https://github.com/eslint/eslint/issues/10140)) ([#10209](https://github.com/eslint/eslint/issues/10209)) (Teddy Katz)
* [a039956](https://github.com/eslint/eslint/commit/a039956) Breaking: remove deprecated browser/jest/node globals (fixes [#10141](https://github.com/eslint/eslint/issues/10141)) ([#10210](https://github.com/eslint/eslint/issues/10210)) (Teddy Katz)
* [2324570](https://github.com/eslint/eslint/commit/2324570) Breaking: [no-unused-vars](/docs/rules/no-unused-vars) reports all after-used params (fixes [#9909](https://github.com/eslint/eslint/issues/9909)) ([#10119](https://github.com/eslint/eslint/issues/10119)) (Kevin Partington)
* [b77846d](https://github.com/eslint/eslint/commit/b77846d) Breaking: drop supporting Node.js 4 (fixes [#10052](https://github.com/eslint/eslint/issues/10052)) ([#10074](https://github.com/eslint/eslint/issues/10074)) (薛定谔的猫)








## Bug Fixes


* [218ee57](https://github.com/eslint/eslint/commit/218ee57) Fix: report [no-case-declarations](/docs/rules/no-case-declarations) from declarations (fixes [#10048](https://github.com/eslint/eslint/issues/10048)) ([#10167](https://github.com/eslint/eslint/issues/10167)) (Carlo Abelli)




## Documentation


* [98f1cad](https://github.com/eslint/eslint/commit/98f1cad) Docs: update migration guide with latest changes ([#10212](https://github.com/eslint/eslint/issues/10212)) (Teddy Katz)
* [71167be](https://github.com/eslint/eslint/commit/71167be) Docs: fix wrong config in [id-length](/docs/rules/id-length) ([#10196](https://github.com/eslint/eslint/issues/10196)) (薛定谔的猫)
* [731da1e](https://github.com/eslint/eslint/commit/731da1e) Docs: fix code in correct example. ([#10195](https://github.com/eslint/eslint/issues/10195)) (薛定谔的猫)
* [3780915](https://github.com/eslint/eslint/commit/3780915) Docs: fix some small errors in examples ([#10194](https://github.com/eslint/eslint/issues/10194)) (薛定谔的猫)
* [1e7252f](https://github.com/eslint/eslint/commit/1e7252f) Docs: Add more related rules for [object-curly-spacing](/docs/rules/object-curly-spacing) ([#10175](https://github.com/eslint/eslint/issues/10175)) (Saugat Acharya)
* [e5cf9cc](https://github.com/eslint/eslint/commit/e5cf9cc) Docs: Reorder README sections ([#10172](https://github.com/eslint/eslint/issues/10172)) (alberto)
* [d0dc2e3](https://github.com/eslint/eslint/commit/d0dc2e3) Docs: Add Missing Quotes ([#10162](https://github.com/eslint/eslint/issues/10162)) (Samarth Verma)




## Dependency Upgrades


* [f595fd8](https://github.com/eslint/eslint/commit/f595fd8) Upgrade: upgrade deps ([#10184](https://github.com/eslint/eslint/issues/10184)) (alberto)
* [7765fc4](https://github.com/eslint/eslint/commit/7765fc4) Upgrade: ajv@^6.0.1, still using json schema draft 04 ([#9856](https://github.com/eslint/eslint/issues/9856)) (Kevin Partington)
* [869c9f5](https://github.com/eslint/eslint/commit/869c9f5) Upgrade: babelify ([#10185](https://github.com/eslint/eslint/issues/10185)) (alberto)
* [b7ee1ed](https://github.com/eslint/eslint/commit/b7ee1ed) Upgrade: upgrade devdeps ([#10178](https://github.com/eslint/eslint/issues/10178)) (alberto)
* [f3a0291](https://github.com/eslint/eslint/commit/f3a0291) Upgrade: Update dependencies. ([#10168](https://github.com/eslint/eslint/issues/10168)) (alberto)
* [7d6e052](https://github.com/eslint/eslint/commit/7d6e052) Upgrade: esquery@^1.0.1 (fixes [#8733](https://github.com/eslint/eslint/issues/8733)) ([#10170](https://github.com/eslint/eslint/issues/10170)) (Kevin Partington)
* [7a63bfa](https://github.com/eslint/eslint/commit/7a63bfa) Upgrade: eslint-release to v0.11.1 ([#10156](https://github.com/eslint/eslint/issues/10156)) (Teddy Katz)




## Build Related


* [b7a1a7a](https://github.com/eslint/eslint/commit/b7a1a7a) Build: Gensite creates prerelease dirs if needed ([#10154](https://github.com/eslint/eslint/issues/10154)) (Brandon Mills)




## Chores


* [2e60017](https://github.com/eslint/eslint/commit/2e60017) Chore: remove concat-stream dependency ([#10173](https://github.com/eslint/eslint/issues/10173)) (Teddy Katz)
* [7f69f11](https://github.com/eslint/eslint/commit/7f69f11) Chore:  rearrange init options. ([#10131](https://github.com/eslint/eslint/issues/10131)) (薛定谔的猫)
* [81629d2](https://github.com/eslint/eslint/commit/81629d2) Chore: enable rest/spread rules on ESLint codebase ([#10211](https://github.com/eslint/eslint/issues/10211)) (Teddy Katz)
* [cd34d44](https://github.com/eslint/eslint/commit/cd34d44) Chore: avoid modifying global state when tests fail ([#10201](https://github.com/eslint/eslint/issues/10201)) (Teddy Katz)
* [db1a582](https://github.com/eslint/eslint/commit/db1a582) Chore: Add debug logging for CLI args as they came in ([#10174](https://github.com/eslint/eslint/issues/10174)) (Kevin Partington)
* [c85578f](https://github.com/eslint/eslint/commit/c85578f) Chore: Remove `esprima-fb` dependency. ([#10171](https://github.com/eslint/eslint/issues/10171)) (alberto)
