---
layout: post
title: ESLint v5.0.0-alpha.0 released
teaser: "We just pushed ESLint v5.0.0-alpha.0, which is a major release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release. This release also has some breaking changes, so please read the following closely."
image: release-notes-beta.png
tags:
  - release
  - major
authors:
  - not-an-aardvark
categories:
  - Release Notes
---

Note: This version of ESLint is not ready for production use and is provided to gather feedback from the community before releasing the final version. Please let us know if you having any problems or feedback by creating issues on our [GitHub repo](https://github.com/eslint/eslint) or joining our [Gitter channel](https://gitter.im/eslint/eslint).

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Installing

Since this is a pre-release version, you will not automatically be upgraded by npm. You must specify the `next` tag when installing:

```
npm i eslint@next --save-dev
```

You can also specify the version directly:

```
npm i eslint@5.0.0-alpha.0 --save-dev
```

### Migration Guide

As there are a lot of changes, we've created a [migration guide](/docs/5.0.0/user-guide/migrating-to-5.0.0) describing the changes in great detail along with the steps you should take to address them. We expect that most users should be able to upgrade without any build changes, but the migration guide should be a useful resource if you encounter problems.


## Breaking Changes


* [f4b3af586](https://github.com/eslint/eslint/commit/f4b3af586) Breaking: Upgrade to Espree v4 alpha (refs [#9990](https://github.com/eslint/eslint/issues/9990)) ([#10152](https://github.com/eslint/eslint/issues/10152)) (Brandon Mills)
* [d440e8496](https://github.com/eslint/eslint/commit/d440e8496) Breaking: support @scope shorthand in plugins (fixes [#9903](https://github.com/eslint/eslint/issues/9903)) ([#9905](https://github.com/eslint/eslint/issues/9905)) (Toru Nagashima)
* [a9ee9ae87](https://github.com/eslint/eslint/commit/a9ee9ae87) Breaking: require rules to provide report messages (fixes [#10011](https://github.com/eslint/eslint/issues/10011)) ([#10057](https://github.com/eslint/eslint/issues/10057)) (Teddy Katz)
* [c383bc57f](https://github.com/eslint/eslint/commit/c383bc57f) Breaking: Make require('eslint').linter non-enumerable (fixes [#9270](https://github.com/eslint/eslint/issues/9270)) ([#9692](https://github.com/eslint/eslint/issues/9692)) (Jed Fox)
* [4eaebe5ae](https://github.com/eslint/eslint/commit/4eaebe5ae) Breaking: set `parent` of AST nodes before rules run (fixes [#9122](https://github.com/eslint/eslint/issues/9122)) ([#10014](https://github.com/eslint/eslint/issues/10014)) (Teddy Katz)
* [91ece32ac](https://github.com/eslint/eslint/commit/91ece32ac) Breaking: remove special exception for linting empty files (fixes [#9534](https://github.com/eslint/eslint/issues/9534)) ([#10013](https://github.com/eslint/eslint/issues/10013)) (Teddy Katz)
* [27e3f24d8](https://github.com/eslint/eslint/commit/27e3f24d8) Breaking: remove `source` property from linting messages (fixes [#7358](https://github.com/eslint/eslint/issues/7358)) ([#10012](https://github.com/eslint/eslint/issues/10012)) (Teddy Katz)
* [e4c3b3c56](https://github.com/eslint/eslint/commit/e4c3b3c56) Breaking: use an exit code of 2 for fatal config problems (fixes [#9384](https://github.com/eslint/eslint/issues/9384)) ([#10009](https://github.com/eslint/eslint/issues/10009)) (Teddy Katz)
* [2a7ecaa2a](https://github.com/eslint/eslint/commit/2a7ecaa2a) Breaking: Use [strict](/docs/rules/strict) equality in RuleTester comparisons (fixes [#9417](https://github.com/eslint/eslint/issues/9417)) ([#10008](https://github.com/eslint/eslint/issues/10008)) (Teddy Katz)






## Enhancements


* [462b058d0](https://github.com/eslint/eslint/commit/462b058d0) Update: Include debugging information when rule throws error ([#9742](https://github.com/eslint/eslint/issues/9742)) (Patrick Hayes)
* [ea6fb17ae](https://github.com/eslint/eslint/commit/ea6fb17ae) Update: Make [no-cond-assign](/docs/rules/no-cond-assign) work for ternaries (fixes [#10091](https://github.com/eslint/eslint/issues/10091)) ([#10109](https://github.com/eslint/eslint/issues/10109)) (Aaron Harper)




## Bug Fixes


* [0bc4a3835](https://github.com/eslint/eslint/commit/0bc4a3835) Fix: Make rule-tester strictly check messageId. (ref [#9890](https://github.com/eslint/eslint/issues/9890)) ([#9908](https://github.com/eslint/eslint/issues/9908)) (Jacques Favreau)




## Documentation


* [3351129f9](https://github.com/eslint/eslint/commit/3351129f9) Docs: add v5.0.0 migration guide (fixes [#10142](https://github.com/eslint/eslint/issues/10142)) ([#10147](https://github.com/eslint/eslint/issues/10147)) (Teddy Katz)
* [65cc83498](https://github.com/eslint/eslint/commit/65cc83498) Docs: Ensure CLI doc sections match command line help order ([#10144](https://github.com/eslint/eslint/issues/10144)) (Kevin Partington)
* [9c791746b](https://github.com/eslint/eslint/commit/9c791746b) Docs: Update [capitalized-comments](/docs/rules/capitalized-comments) with missing letters (fixes [#10135](https://github.com/eslint/eslint/issues/10135)) ([#10134](https://github.com/eslint/eslint/issues/10134)) (jasonfry)
* [9e66bfbc4](https://github.com/eslint/eslint/commit/9e66bfbc4) Docs: remove eslint vs jshint from faq ([#10108](https://github.com/eslint/eslint/issues/10108)) (alberto)
* [692e3830b](https://github.com/eslint/eslint/commit/692e3830b) Docs: Add modified variable examples for [no-loop-func](/docs/rules/no-loop-func) (fixes [#9527](https://github.com/eslint/eslint/issues/9527)) ([#10098](https://github.com/eslint/eslint/issues/10098)) (Rachael Sim)






## Build Related


* [f2f98dd13](https://github.com/eslint/eslint/commit/f2f98dd13) Build: make prerelease script publish to GitHub/website ([#10151](https://github.com/eslint/eslint/issues/10151)) (Teddy Katz)




## Chores


* [9a020dc14](https://github.com/eslint/eslint/commit/9a020dc14) Chore: refactor --no-ignore flag logic ([#10146](https://github.com/eslint/eslint/issues/10146)) (Teddy Katz)
* [4f61a0ded](https://github.com/eslint/eslint/commit/4f61a0ded) Chore: add noopener/noreferrer (薛定谔的猫)
* [837edc7c0](https://github.com/eslint/eslint/commit/837edc7c0) Chore: Uncommented test for empty program for no-invalid-meta ([#10046](https://github.com/eslint/eslint/issues/10046)) (Kevin Partington)
