---
layout: post
title: ESLint v4.16.0 released
teaser: "We just pushed ESLint v4.16.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - not-an-aardvark
categories:
  - Release Notes
---

## Highlights

* The [`comma-style`](/docs/rules/comma-style) rule now supports a `NewExpression` option.
* The [`valid-jsdoc`](/docs/rules/valid-jsdoc) rule can now be autofixed in some cases, and its error locations are more precise.
* The `allowMultiplePropertiesPerLine` option in the [`object-property-newline`](/docs/rules/object-property-newline) rule has been renamed to `allowAllPropertiesOnSameLine` to more clearly convey what the option does. `allowMultiplePropertiesPerLine` still works, but has been deprecated.

## Enhancements


* [e26a25f](https://github.com/eslint/eslint/commit/e26a25f) Update: allow continue instead of if wrap in [guard-for-in](/docs/rules/guard-for-in) (fixes [#7567](https://github.com/eslint/eslint/issues/7567)) ([#9796](https://github.com/eslint/eslint/issues/9796)) (Michael Ficarra)
* [af043eb](https://github.com/eslint/eslint/commit/af043eb) Update: Add NewExpression support to [comma-style](/docs/rules/comma-style) ([#9591](https://github.com/eslint/eslint/issues/9591)) (Frazer McLean)
* [1d61930](https://github.com/eslint/eslint/commit/1d61930) Update: use doctrine range information in [valid-jsdoc](/docs/rules/valid-jsdoc) ([#9831](https://github.com/eslint/eslint/issues/9831)) (Teddy Katz)
* [133336e](https://github.com/eslint/eslint/commit/133336e) Update: fix [indent](/docs/rules/indent) behavior on template literal arguments (fixes [#9061](https://github.com/eslint/eslint/issues/9061)) ([#9820](https://github.com/eslint/eslint/issues/9820)) (Teddy Katz)
* [add1e70](https://github.com/eslint/eslint/commit/add1e70) Update: fix [indent](/docs/rules/indent) bug on comments in ternary expressions (fixes [#9729](https://github.com/eslint/eslint/issues/9729)) ([#9818](https://github.com/eslint/eslint/issues/9818)) (Teddy Katz)
* [2cf4522](https://github.com/eslint/eslint/commit/2cf4522) Update: Rename and deprecate [object-property-newline](/docs/rules/object-property-newline) option ([#9570](https://github.com/eslint/eslint/issues/9570)) (Jonathan Pool)




## Bug Fixes


* [13bcf3c](https://github.com/eslint/eslint/commit/13bcf3c) Fix: Removing [curly](/docs/rules/curly) [quotes](/docs/rules/quotes) in [no-eq-null](/docs/rules/no-eq-null) report message ([#9852](https://github.com/eslint/eslint/issues/9852)) (Kevin Partington)
* [ea1b15d](https://github.com/eslint/eslint/commit/ea1b15d) Fix: avoid crashing on malformed configuration comments (fixes [#9373](https://github.com/eslint/eslint/issues/9373)) ([#9819](https://github.com/eslint/eslint/issues/9819)) (Teddy Katz)
* [6a5cd32](https://github.com/eslint/eslint/commit/6a5cd32) Fix: [prefer-destructuring](/docs/rules/prefer-destructuring) error with computed properties (fixes [#9784](https://github.com/eslint/eslint/issues/9784)) ([#9817](https://github.com/eslint/eslint/issues/9817)) (Teddy Katz)




## Documentation


* [b96fb31](https://github.com/eslint/eslint/commit/b96fb31) Docs: configuration hierarchy for CLIEngine options (fixes [#9526](https://github.com/eslint/eslint/issues/9526)) ([#9855](https://github.com/eslint/eslint/issues/9855)) (PiIsFour)
* [8ccbdda](https://github.com/eslint/eslint/commit/8ccbdda) Docs: Clarify that -c configs merge with `.eslintrc.*` (fixes [#9535](https://github.com/eslint/eslint/issues/9535)) ([#9847](https://github.com/eslint/eslint/issues/9847)) (Kevin Partington)
* [978574f](https://github.com/eslint/eslint/commit/978574f) Docs: Fix examples for [no-useless-escape](/docs/rules/no-useless-escape) ([#9853](https://github.com/eslint/eslint/issues/9853)) (Toru Kobayashi)
* [2e87ddd](https://github.com/eslint/eslint/commit/2e87ddd) Docs: Sync messageId examples' style with other examples ([#9816](https://github.com/eslint/eslint/issues/9816)) (Kevin Partington)
* [601f851](https://github.com/eslint/eslint/commit/601f851) Docs: Minor modification to code comments for clarity ([#9821](https://github.com/eslint/eslint/issues/9821)) (rgovind92)
* [b9da067](https://github.com/eslint/eslint/commit/b9da067) Docs: fix misleading info about RuleTester column numbers ([#9830](https://github.com/eslint/eslint/issues/9830)) (Teddy Katz)
* [acde640](https://github.com/eslint/eslint/commit/acde640) Docs: Add ES 2018 to Configuring ESLint ([#9829](https://github.com/eslint/eslint/issues/9829)) (Kai Cataldo)
* [ccfce15](https://github.com/eslint/eslint/commit/ccfce15) Docs: Minor tweaks to working with rules page ([#9824](https://github.com/eslint/eslint/issues/9824)) (Kevin Partington)
* [54b329a](https://github.com/eslint/eslint/commit/54b329a) Docs: fix substitution of {{ name }} ([#9822](https://github.com/eslint/eslint/issues/9822)) (Andres Kalle)






## Build Related


* [4f898c7](https://github.com/eslint/eslint/commit/4f898c7) Build: Fix JSDoc syntax errors ([#9813](https://github.com/eslint/eslint/issues/9813)) (Matija Marohnić)




## Chores


* [cd5681d](https://github.com/eslint/eslint/commit/cd5681d) Chore: Deactivate consistent-docs-url in internal rules folder ([#9815](https://github.com/eslint/eslint/issues/9815)) (Kevin Partington)
