---
layout: post
title: ESLint v4.15.0 released
teaser: "We just pushed ESLint v4.15.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - platinumazure
categories:
  - Release Notes
---

## Highlights

### New APIs

CLIEngine now has a [`getRules()` method](https://eslint.org/docs/developer-guide/nodejs-api#clienginegetrules). This is useful for integrations that need to look at rules' metadata programmatically without knowing what rules might have been defined by plugins.

Rules now support [`messages` metadata and `messageId` report parameters](https://eslint.org/docs/developer-guide/working-with-rules#messageids), including full support in RuleTester. This lets rule developers use `messageId`s in their rule tests and avoid needing to track report message changes in both the rule implementation and the corresponding test file. In addition, this is the first step towards core support for rule message localization.

### New rule options

The [`indent`](/docs/rules/indent) rule now has an `ignoreComments` option. This allows users to opt out of indentation checks for comments if project style rules require that comments be indented in a different manner.

## Features

* [6ab04b5](https://github.com/eslint/eslint/commit/6ab04b5) New: Add context.report({ messageId }) (fixes [#6740](https://github.com/eslint/eslint/issues/6740)) ([#9165](https://github.com/eslint/eslint/issues/9165)) (Jed Fox)
* [65f0176](https://github.com/eslint/eslint/commit/65f0176) New: CLIEngine#getRules() (refs [#6582](https://github.com/eslint/eslint/issues/6582)) ([#9782](https://github.com/eslint/eslint/issues/9782)) (Patrick McElhaney)

## Enhancements

* [c64195f](https://github.com/eslint/eslint/commit/c64195f) Update: More detailed assert message for rule-tester ([#9769](https://github.com/eslint/eslint/issues/9769)) (Weijia Wang)
* [bbabf34](https://github.com/eslint/eslint/commit/bbabf34) Update: add `ignoreComments` option to [`indent`](/docs/rules/indent) rule (fixes [#9018](https://github.com/eslint/eslint/issues/9018)) ([#9752](https://github.com/eslint/eslint/issues/9752)) (Kevin Partington)

## Bug Fixes

* [9fcfabf](https://github.com/eslint/eslint/commit/9fcfabf) Fix: [no-extra-parens](/docs/rules/no-extra-parens) false positive (fixes: [#9755](https://github.com/eslint/eslint/issues/9755)) ([#9795](https://github.com/eslint/eslint/issues/9795)) (Erin)
* [4c87f42](https://github.com/eslint/eslint/commit/4c87f42) Fix: incorrect error messages of [no-unused-vars](/docs/rules/no-unused-vars) (fixes [#9774](https://github.com/eslint/eslint/issues/9774)) ([#9791](https://github.com/eslint/eslint/issues/9791)) (akouryy)

## Documentation

* [fc7f404](https://github.com/eslint/eslint/commit/fc7f404) Docs: add url to each of the rules (refs [#6582](https://github.com/eslint/eslint/issues/6582)) ([#9788](https://github.com/eslint/eslint/issues/9788)) (Patrick McElhaney)
* [fc44da9](https://github.com/eslint/eslint/commit/fc44da9) Docs: fix [sort-imports](/docs/rules/sort-imports) rule block language ([#9805](https://github.com/eslint/eslint/issues/9805)) (ferhat elmas)
* [61e5fa0](https://github.com/eslint/eslint/commit/61e5fa0) Docs: Add table of contents to Node.js API docs ([#9785](https://github.com/eslint/eslint/issues/9785)) (Patrick McElhaney)
* [db431cb](https://github.com/eslint/eslint/commit/db431cb) Docs: HTTP -> HTTPS (fixes [#9768](https://github.com/eslint/eslint/issues/9768)) ([#9768](https://github.com/eslint/eslint/issues/9768)) (Ronald Eddy Jr)
* [cbf0fb9](https://github.com/eslint/eslint/commit/cbf0fb9) Docs: describe how to feature-detect scopeManager/visitorKeys support ([#9764](https://github.com/eslint/eslint/issues/9764)) (Teddy Katz)
* [f7dcb70](https://github.com/eslint/eslint/commit/f7dcb70) Docs: Add note about "patch release pending" label to maintainer guide ([#9763](https://github.com/eslint/eslint/issues/9763)) (Teddy Katz)
