---
layout: post
title: ESLint v4.14.0 released
teaser: "We just pushed ESLint v4.14.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - ilyavolodin
categories:
  - Release Notes
---

## Highlights

Parsers can now provide custom scope analysis hooks to ESLint, which should allow for easier integration when parsing non-standard syntax. For more information see our [documentation](/docs/developer-guide/working-with-plugins#working-with-custom-parsers).


## Features


* [ae51eb2](https://github.com/eslint/eslint/commit/ae51eb2) New: Add allowImplicit option to [array-callback-return](/docs/rules/array-callback-return) (fixes [#8539](https://github.com/eslint/eslint/issues/8539)) ([#9344](https://github.com/eslint/eslint/issues/9344)) (James C. Davis)




## Enhancements


* [be2f57e](https://github.com/eslint/eslint/commit/be2f57e) Update: support separate requires in [one-var](/docs/rules/one-var). (fixes [#6175](https://github.com/eslint/eslint/issues/6175)) ([#9441](https://github.com/eslint/eslint/issues/9441)) (薛定谔的猫)
* [75c7419](https://github.com/eslint/eslint/commit/75c7419) Update: Logical-and is counted in [`complexity`](/docs/rules/complexity) rule (fixes [#8535](https://github.com/eslint/eslint/issues/8535)) ([#9754](https://github.com/eslint/eslint/issues/9754)) (Kevin Partington)
* [1c2aafd](https://github.com/eslint/eslint/commit/1c2aafd) Update: Improve parser integrations (fixes [#8392](https://github.com/eslint/eslint/issues/8392)) ([#8755](https://github.com/eslint/eslint/issues/8755)) (Toru Nagashima)




## Bug Fixes


* [43d4ba8](https://github.com/eslint/eslint/commit/43d4ba8) Fix: false positive on rule[`lines-between-class-members`](/docs/rules/lines-between-class-members) (fixes [#9665](https://github.com/eslint/eslint/issues/9665)) ([#9680](https://github.com/eslint/eslint/issues/9680)) (sakabar)




## Documentation


* [370d614](https://github.com/eslint/eslint/commit/370d614) Docs: Fix typos ([#9751](https://github.com/eslint/eslint/issues/9751)) (Jed Fox)
* [eb4b1e0](https://github.com/eslint/eslint/commit/eb4b1e0) Docs: reintroduce misspelling in [`valid-typeof`](/docs/rules/valid-typeof) example ([#9753](https://github.com/eslint/eslint/issues/9753)) (Teddy Katz)
* [e9d5dfd](https://github.com/eslint/eslint/commit/e9d5dfd) Docs: improve [no-extra-parens](/docs/rules/no-extra-parens) formatting ([#9747](https://github.com/eslint/eslint/issues/9747)) (Rich Trott)
* [f252c19](https://github.com/eslint/eslint/commit/f252c19) Docs: Make the lint message `source` property a little more subtle ([#9735](https://github.com/eslint/eslint/issues/9735)) (Jed Fox)
* [5a5c23c](https://github.com/eslint/eslint/commit/5a5c23c) Docs: fix the link to contributing page ([#9727](https://github.com/eslint/eslint/issues/9727)) (Victor Hom)
* [f44ce11](https://github.com/eslint/eslint/commit/f44ce11) Docs: change beginner to good first issue label text ([#9726](https://github.com/eslint/eslint/issues/9726)) (Victor Hom)
* [f819920](https://github.com/eslint/eslint/commit/f819920) Docs: fix typos ([#9723](https://github.com/eslint/eslint/issues/9723)) (Thomas Broadley)




## Dependency Upgrades


* [4ddc131](https://github.com/eslint/eslint/commit/4ddc131) Upgrade: debug@^3.1.0 ([#9731](https://github.com/eslint/eslint/issues/9731)) (Kevin Partington)






## Chores


* [8196c45](https://github.com/eslint/eslint/commit/8196c45) Chore: Reorganize CLI options and associated docs ([#9758](https://github.com/eslint/eslint/issues/9758)) (Kevin Partington)
* [37d066c](https://github.com/eslint/eslint/commit/37d066c) Chore: Add unit tests for overrides glob matching. ([#9744](https://github.com/eslint/eslint/issues/9744)) (Robert Jackson)
* [805a94e](https://github.com/eslint/eslint/commit/805a94e) Chore: Fix typo in CLIEngine test name ([#9741](https://github.com/eslint/eslint/issues/9741)) (@scriptdaemon)
* [14baa2e](https://github.com/eslint/eslint/commit/14baa2e) Chore: improve [arrow-body-style](/docs/rules/arrow-body-style) error message (refs [#5498](https://github.com/eslint/eslint/issues/5498)) ([#9718](https://github.com/eslint/eslint/issues/9718)) (Teddy Katz)
