---
layout: post
title: ESLint v4.12.0 released
teaser: "We just pushed ESLint v4.12.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - platinumazure
categories:
  - Release Notes
---

## Highlights

### New Rules

We've added 1 new rule with this release:

* [implicit-arrow-linebreak](/docs/rules/implicit-arrow-linebreak)

### Autofixable Rules

We've added autofix capabilities to one rule: [`sort-vars`](/docs/rules/sort-vars). At present, it will only sort variables with no initial value or a literal initial value, in order to avoid potentially changing the order of function calls.

### New Node.js APIs

We've added a new Node.js API:

* [`Linter.defineParser`](/docs/developer-guide/nodejs-api#linterdefineparser)

This API is useful when you are working with an instance of [`Linter`](/docs/developer-guide/nodejs-api#linter) and need to define a custom parser at runtime.

## Features


* [28c9c8e](https://github.com/eslint/eslint/commit/28c9c8e) New: add a Linter#defineParser function ([#9321](https://github.com/eslint/eslint/issues/9321)) (Ives van Hoorne)
* [4118f14](https://github.com/eslint/eslint/commit/4118f14) New: Adds [implicit-arrow-linebreak](/docs/rules/implicit-arrow-linebreak) rule (refs [#9510](https://github.com/eslint/eslint/issues/9510)) ([#9629](https://github.com/eslint/eslint/issues/9629)) (Sharmila Jesupaul)




## Enhancements


* [5619910](https://github.com/eslint/eslint/commit/5619910) Update: Add autofix for [`sort-vars`](/docs/rules/sort-vars) ([#9496](https://github.com/eslint/eslint/issues/9496)) (Trevin Hofmann)
* [71eedbf](https://github.com/eslint/eslint/commit/71eedbf) Update: add `beforeStatementContinuationChars` to [semi](/docs/rules/semi) (fixes [#9521](https://github.com/eslint/eslint/issues/9521)) ([#9594](https://github.com/eslint/eslint/issues/9594)) (Toru Nagashima)
* [0cf081e](https://github.com/eslint/eslint/commit/0cf081e) Update: add importNames option to [no-restricted-imports](/docs/rules/no-restricted-imports) ([#9506](https://github.com/eslint/eslint/issues/9506)) (Benjamin R Gibson)




## Bug Fixes


* [208fb0f](https://github.com/eslint/eslint/commit/208fb0f) Fix: Use XML 1.1 on XML formatters (fixes [#9607](https://github.com/eslint/eslint/issues/9607)) ([#9608](https://github.com/eslint/eslint/issues/9608)) (Daniel Reigada)
* [e13d439](https://github.com/eslint/eslint/commit/e13d439) Fix: [space-in-parens](/docs/rules/space-in-parens) crash ([#9655](https://github.com/eslint/eslint/issues/9655)) (Toru Nagashima)
* [a015234](https://github.com/eslint/eslint/commit/a015234) Fix: [prefer-destructuring](/docs/rules/prefer-destructuring) false positive on "super" (fixes [#9625](https://github.com/eslint/eslint/issues/9625)) ([#9626](https://github.com/eslint/eslint/issues/9626)) (Kei Ito)




## Documentation


* [92171cc](https://github.com/eslint/eslint/commit/92171cc) Docs: Updating migration guide for single-line disable ([#9385](https://github.com/eslint/eslint/issues/9385)) (Justin Helmer)
* [f39ffe7](https://github.com/eslint/eslint/commit/f39ffe7) Docs: remove extra punctuation from readme ([#9640](https://github.com/eslint/eslint/issues/9640)) (Teddy Katz)
* [332c214](https://github.com/eslint/eslint/commit/332c214) Docs: Add @platinumazure to TSC ([#9618](https://github.com/eslint/eslint/issues/9618)) (Ilya Volodin)




## Dependency Upgrades


* [76dab18](https://github.com/eslint/eslint/commit/76dab18) Upgrade: doctrine@^2.0.2 ([#9656](https://github.com/eslint/eslint/issues/9656)) (Kevin Partington)
* [6e04f14](https://github.com/eslint/eslint/commit/6e04f14) Upgrade: `globals` to 11.0.1 (fixes [#9614](https://github.com/eslint/eslint/issues/9614)) ([#9632](https://github.com/eslint/eslint/issues/9632)) (Toru Nagashima)
