---
layout: post
title: ESLint v4.11.0 released
teaser: "We just pushed ESLint v4.11.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - kaicataldo
categories:
  - Release Notes
---

## Highlights

npm installed formatters can now be specified with or without the package name's `eslint-formatter-` prefix. Example:

```
npm install eslint-formatter-pretty

eslint -f pretty file.js

// equivalent:
eslint -f eslint-formatter-pretty file.js
```

## Enhancements


* [4d7d7ab](https://github.com/eslint/eslint/commit/4d7d7ab) Update: Resolve npm installed formatters ([#5900](https://github.com/eslint/eslint/issues/5900)) ([#9464](https://github.com/eslint/eslint/issues/9464)) (Tom Erik Støwer)




## Bug Fixes


* [7e3bf6a](https://github.com/eslint/eslint/commit/7e3bf6a) Fix: edge-cases of [semi-style](/docs/rules/semi-style) ([#9560](https://github.com/eslint/eslint/issues/9560)) (Toru Nagashima)
* [e5a37ce](https://github.com/eslint/eslint/commit/e5a37ce) Fix: [object-curly-newline](/docs/rules/object-curly-newline) for flow code ([#9458](https://github.com/eslint/eslint/issues/9458)) (Tiddo Langerak)
* [b7c5b19](https://github.com/eslint/eslint/commit/b7c5b19) Fix: Correct [object Object] output of error.data. ([#9561](https://github.com/eslint/eslint/issues/9561)) (Jonathan Pool)
* [accc490](https://github.com/eslint/eslint/commit/accc490) Fix: Files with no failures get "passing" testcase ([#9547](https://github.com/eslint/eslint/issues/9547)) (Samuel Levy)
* [a9606a3](https://github.com/eslint/eslint/commit/a9606a3) Fix: invalid tests with super (fixes [#9539](https://github.com/eslint/eslint/issues/9539)) ([#9545](https://github.com/eslint/eslint/issues/9545)) (Teddy Katz)




## Documentation


* [d4557a6](https://github.com/eslint/eslint/commit/d4557a6) Docs: disallow use of the comma operator using [no-restricted-syntax](/docs/rules/no-restricted-syntax) ([#9585](https://github.com/eslint/eslint/issues/9585)) (薛定谔的猫)
* [6672fae](https://github.com/eslint/eslint/commit/6672fae) Docs: Fixed a typo on [lines-between-class-members](/docs/rules/lines-between-class-members) doc ([#9603](https://github.com/eslint/eslint/issues/9603)) (Moinul Hossain)
* [2542f04](https://github.com/eslint/eslint/commit/2542f04) Docs: Add missing options for [`lines-around-comment`](/docs/rules/lines-around-comment) ([#9589](https://github.com/eslint/eslint/issues/9589)) (Clément Fiorio)
* [51c8cf0](https://github.com/eslint/eslint/commit/51c8cf0) Docs: Disambiguate definition of Update tag ([#9584](https://github.com/eslint/eslint/issues/9584)) (Jonathan Pool)
* [afc3c75](https://github.com/eslint/eslint/commit/afc3c75) Docs: clarify what eslint-config-eslint is ([#9582](https://github.com/eslint/eslint/issues/9582)) (Teddy Katz)
* [aedae9d](https://github.com/eslint/eslint/commit/aedae9d) Docs: fix spelling in [valid-typeof](/docs/rules/valid-typeof) example ([#9574](https://github.com/eslint/eslint/issues/9574)) (Maksim Degtyarev)
* [4c5aaf3](https://github.com/eslint/eslint/commit/4c5aaf3) Docs: Fix typo in [no-underscore-dangle](/docs/rules/no-underscore-dangle) rule ([#9567](https://github.com/eslint/eslint/issues/9567)) (Fabien Lucas)
* [ab0f66d](https://github.com/eslint/eslint/commit/ab0f66d) Docs: Add examples to better show rule coverage. ([#9548](https://github.com/eslint/eslint/issues/9548)) (Jonathan Pool)
* [acccfbd](https://github.com/eslint/eslint/commit/acccfbd) Docs: Minor rephrase in [`no-invalid-this`](/docs/rules/no-invalid-this). ([#9542](https://github.com/eslint/eslint/issues/9542)) (Francisc)
* [8f9c0fe](https://github.com/eslint/eslint/commit/8f9c0fe) Docs: improve [id-match](/docs/rules/id-match) usage advice ([#9544](https://github.com/eslint/eslint/issues/9544)) (Teddy Katz)
* [06b491e](https://github.com/eslint/eslint/commit/06b491e) Docs: fix duplicate entries in changelog ([#9530](https://github.com/eslint/eslint/issues/9530)) (Teddy Katz)
* [9cf4ebe](https://github.com/eslint/eslint/commit/9cf4ebe) Docs: add .md to link(for github users) ([#9529](https://github.com/eslint/eslint/issues/9529)) (薛定谔的猫)




## Dependency Upgrades


* [d602f9e](https://github.com/eslint/eslint/commit/d602f9e) Upgrade: espree v3.5.2 ([#9611](https://github.com/eslint/eslint/issues/9611)) (Kai Cataldo)




## Build Related


* [cc2c7c9](https://github.com/eslint/eslint/commit/cc2c7c9) Build: use Node 8 in appveyor ([#9595](https://github.com/eslint/eslint/issues/9595)) (薛定谔的猫)
* [b6a7490](https://github.com/eslint/eslint/commit/b6a7490) Build: ensure fuzzer tests get run with `npm test` ([#9590](https://github.com/eslint/eslint/issues/9590)) (Teddy Katz)
* [1073bc5](https://github.com/eslint/eslint/commit/1073bc5) Build: remove shelljs-nodecli (refs [#9533](https://github.com/eslint/eslint/issues/9533)) ([#9588](https://github.com/eslint/eslint/issues/9588)) (Teddy Katz)
* [7f37b1c](https://github.com/eslint/eslint/commit/7f37b1c) Build: test Node 9 on Travis ([#9556](https://github.com/eslint/eslint/issues/9556)) (Teddy Katz)




## Chores


* [4def876](https://github.com/eslint/eslint/commit/4def876) Chore: avoid handling rules instances in config-validator ([#9364](https://github.com/eslint/eslint/issues/9364)) (Teddy Katz)
* [fe5ac7e](https://github.com/eslint/eslint/commit/fe5ac7e) Chore: fix incorrect comment in safe-emitter.js ([#9605](https://github.com/eslint/eslint/issues/9605)) (Teddy Katz)
* [980ecd3](https://github.com/eslint/eslint/commit/980ecd3) Chore: Update copyright and license info ([#9599](https://github.com/eslint/eslint/issues/9599)) (薛定谔的猫)
* [9064b9c](https://github.com/eslint/eslint/commit/9064b9c) Chore: add equalTokens in ast-utils. ([#9500](https://github.com/eslint/eslint/issues/9500)) (薛定谔的猫)
* [3623600](https://github.com/eslint/eslint/commit/3623600) Chore: upgrade ajv@5.3.0 ([#9557](https://github.com/eslint/eslint/issues/9557)) (薛定谔的猫)
* [1b606cd](https://github.com/eslint/eslint/commit/1b606cd) Chore: Remove an indirect dependency on jsonify ([#9444](https://github.com/eslint/eslint/issues/9444)) (Rouven Weßling)
* [88d2303](https://github.com/eslint/eslint/commit/88d2303) Chore: Add [object-property-newline](/docs/rules/object-property-newline) tests to increase coverage. ([#9553](https://github.com/eslint/eslint/issues/9553)) (Jonathan Pool)
* [8e1a095](https://github.com/eslint/eslint/commit/8e1a095) Chore: enable a modified version of [multiline-comment-style](/docs/rules/multiline-comment-style) on codebase ([#9452](https://github.com/eslint/eslint/issues/9452)) (Teddy Katz)
* [cb60285](https://github.com/eslint/eslint/commit/cb60285) Chore: remove commented test for HTML formatter ([#9532](https://github.com/eslint/eslint/issues/9532)) (Teddy Katz)
* [2224733](https://github.com/eslint/eslint/commit/2224733) Chore: use eslint-plugin-rulesdir instead of --rulesdir for self-linting ([#9164](https://github.com/eslint/eslint/issues/9164)) (Teddy Katz)
