---
layout: post
title: ESLint v4.10.0 released
teaser: "We just pushed ESLint v4.10.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - ilyavolodin
categories:
  - Release Notes
---

## Enhancements


* [ebb530d](https://github.com/eslint/eslint/commit/ebb530d) Update: Don't ignore comments ([no-trailing-spaces](/docs/rules/no-trailing-spaces)) ([#9416](https://github.com/eslint/eslint/issues/9416)) (Chris van Marle)




## Bug Fixes


* [bb6e60a](https://github.com/eslint/eslint/commit/bb6e60a) Fix: Improve the doc for [no-restricted-modules](/docs/rules/no-restricted-modules) rule (fixes [#9437](https://github.com/eslint/eslint/issues/9437)) ([#9495](https://github.com/eslint/eslint/issues/9495)) (vibss2397)
* [d80b9d0](https://github.com/eslint/eslint/commit/d80b9d0) Fix: [no-var](/docs/rules/no-var) don't fix globals (fixes [#9520](https://github.com/eslint/eslint/issues/9520)) ([#9525](https://github.com/eslint/eslint/issues/9525)) (Toru Nagashima)
* [b8aa071](https://github.com/eslint/eslint/commit/b8aa071) Fix: allow linting the empty string from stdin (fixes [#9515](https://github.com/eslint/eslint/issues/9515)) ([#9517](https://github.com/eslint/eslint/issues/9517)) (Teddy Katz)
* [2fa64b7](https://github.com/eslint/eslint/commit/2fa64b7) Fix: should not convert non-consecutive line comments to a single blo… ([#9475](https://github.com/eslint/eslint/issues/9475)) (薛定谔的猫)
* [9725146](https://github.com/eslint/eslint/commit/9725146) Fix: [multiline-comment-style](/docs/rules/multiline-comment-style) fix produces invalid code (fixes [#9461](https://github.com/eslint/eslint/issues/9461)). ([#9463](https://github.com/eslint/eslint/issues/9463)) (薛定谔的猫)
* [b12cff8](https://github.com/eslint/eslint/commit/b12cff8) Fix: Expected order of jsdoc tags (fixes [#9412](https://github.com/eslint/eslint/issues/9412)) ([#9451](https://github.com/eslint/eslint/issues/9451)) (Orlando Wenzinger)
* [8768b2d](https://github.com/eslint/eslint/commit/8768b2d) Fix: [multiline-comment-style](/docs/rules/multiline-comment-style) autofixer added trailing space ([#9454](https://github.com/eslint/eslint/issues/9454)) (Teddy Katz)
* [e830aa1](https://github.com/eslint/eslint/commit/e830aa1) Fix: [multiline-comment-style](/docs/rules/multiline-comment-style) reports block comments followed by code ([#9450](https://github.com/eslint/eslint/issues/9450)) (Teddy Katz)
* [eb8cfb1](https://github.com/eslint/eslint/commit/eb8cfb1) Fix: change err report in constant condition (fixes [#9398](https://github.com/eslint/eslint/issues/9398)) ([#9436](https://github.com/eslint/eslint/issues/9436)) (Victor Hom)




## Documentation


* [c529de9](https://github.com/eslint/eslint/commit/c529de9) Docs: Amend rule document to correct and complete it (refs [#6251](https://github.com/eslint/eslint/issues/6251)). ([#9498](https://github.com/eslint/eslint/issues/9498)) (Jonathan Pool)
* [7d390b2](https://github.com/eslint/eslint/commit/7d390b2) Docs: Revise contributor documentation on issue labels. ([#9469](https://github.com/eslint/eslint/issues/9469)) (Jonathan Pool)
* [720b6d5](https://github.com/eslint/eslint/commit/720b6d5) Docs: Update ISSUE_TEMPLATE.md ([#9504](https://github.com/eslint/eslint/issues/9504)) (薛定谔的猫)
* [f054ab5](https://github.com/eslint/eslint/commit/f054ab5) Docs: add `.md` to link (for github users) ([#9501](https://github.com/eslint/eslint/issues/9501)) (薛定谔的猫)
* [5ed9cfc](https://github.com/eslint/eslint/commit/5ed9cfc) Docs: Correct violations of “Variable Declarations” in Code Conventions ([#9447](https://github.com/eslint/eslint/issues/9447)) (Jonathan Pool)
* [3171097](https://github.com/eslint/eslint/commit/3171097) Docs: Clears confusion on usage of global and local plugins.([#9492](https://github.com/eslint/eslint/issues/9492)) (Vasili Sviridov)
* [0f71fef](https://github.com/eslint/eslint/commit/0f71fef) Docs: Unquote booleans in [lines-between-class-members](/docs/rules/lines-between-class-members) docs ([#9497](https://github.com/eslint/eslint/issues/9497)) (Brandon Mills)
* [b3d7532](https://github.com/eslint/eslint/commit/b3d7532) Docs: use consistent terminology & fix link etc. ([#9490](https://github.com/eslint/eslint/issues/9490)) (薛定谔的猫)
* [87db8ae](https://github.com/eslint/eslint/commit/87db8ae) Docs: Fix broken links ([#9488](https://github.com/eslint/eslint/issues/9488)) (gpiress)
* [51bdb2f](https://github.com/eslint/eslint/commit/51bdb2f) Docs: Incorrect link to related rule ([#9477](https://github.com/eslint/eslint/issues/9477)) (Gavin King)
* [1a962e8](https://github.com/eslint/eslint/commit/1a962e8) Docs: Add FAQ for when ESLint cannot find plugin ([#9467](https://github.com/eslint/eslint/issues/9467)) (Kevin Partington)
* [b12e5fe](https://github.com/eslint/eslint/commit/b12e5fe) Docs: Repair broken links and add migration links. ([#9473](https://github.com/eslint/eslint/issues/9473)) (Jonathan Pool)
* [eca01ed](https://github.com/eslint/eslint/commit/eca01ed) Docs: Add missing info about special status of home-dir config files. ([#9472](https://github.com/eslint/eslint/issues/9472)) (Jonathan Pool)
* [47e5f6f](https://github.com/eslint/eslint/commit/47e5f6f) Docs: ensure "good commit message" examples actually follow guidelines ([#9466](https://github.com/eslint/eslint/issues/9466)) (Teddy Katz)
* [ecac0fd](https://github.com/eslint/eslint/commit/ecac0fd) Docs: Remove blockBindings references ([#9446](https://github.com/eslint/eslint/issues/9446)) (Jan Pilzer)
* [052c504](https://github.com/eslint/eslint/commit/052c504) Docs: suggest deleting branches after merging PRs ([#9449](https://github.com/eslint/eslint/issues/9449)) (Teddy Katz)
* [a7521e3](https://github.com/eslint/eslint/commit/a7521e3) Docs: improve examples for [multiline-comment-style](/docs/rules/multiline-comment-style) ([#9440](https://github.com/eslint/eslint/issues/9440)) (Teddy Katz)






## Build Related


* [5012661](https://github.com/eslint/eslint/commit/5012661) Build: fix `npm run profile` script (fixes [#9397](https://github.com/eslint/eslint/issues/9397)) ([#9455](https://github.com/eslint/eslint/issues/9455)) (Teddy Katz)
* [b6f31a9](https://github.com/eslint/eslint/commit/b6f31a9) Build: changelog update for 4.9.0 (ESLint Jenkins)




## Chores


* [f9c6673](https://github.com/eslint/eslint/commit/f9c6673) Chore: Add tests to cover array and object values and leading commas. ([#9502](https://github.com/eslint/eslint/issues/9502)) (Jonathan Pool)
* [9169258](https://github.com/eslint/eslint/commit/9169258) Chore: remove `npm run check-commit` script ([#9513](https://github.com/eslint/eslint/issues/9513)) (Teddy Katz)
* [350a72c](https://github.com/eslint/eslint/commit/350a72c) Chore: regex.test => string.startsWith ([#9518](https://github.com/eslint/eslint/issues/9518)) (薛定谔的猫)
* [de0bef4](https://github.com/eslint/eslint/commit/de0bef4) Chore: remove obsolete eslintbot templates ([#9512](https://github.com/eslint/eslint/issues/9512)) (Teddy Katz)
* [3204773](https://github.com/eslint/eslint/commit/3204773) Chore: enable [max-len](/docs/rules/max-len). ([#9414](https://github.com/eslint/eslint/issues/9414)) (薛定谔的猫)
* [da77eb4](https://github.com/eslint/eslint/commit/da77eb4) Chore: Revise no-config-file test to prevent false failure. ([#9443](https://github.com/eslint/eslint/issues/9443)) (Jonathan Pool)
* [0b89865](https://github.com/eslint/eslint/commit/0b89865) Chore: ensure tests for internal rules get run ([#9453](https://github.com/eslint/eslint/issues/9453)) (Teddy Katz)
* [b31e55a](https://github.com/eslint/eslint/commit/b31e55a) Chore: move internal rules out of lib/ ([#9448](https://github.com/eslint/eslint/issues/9448)) (Teddy Katz)
