---
layout: post
title: ESLint v4.9.0 released
teaser: "We just pushed ESLint v4.9.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - ilyavolodin
categories:
  - Release Notes
---

## Highlights

We've added 2 new rules with this release:

* [multiline-comment-style](/docs/rules/multiline-comment-style)
* [lines-between-class-members](/docs/rules/lines-between-class-members)

We also added new CLI option [`--fix-dry-run`](/docs/user-guide/command-line-interface#--fix-dry-run). This option will allow you to apply fixes without writing them to the disk.

## Features


* [8eb4aae](https://github.com/eslint/eslint/commit/8eb4aae) New: [multiline-comment-style](/docs/rules/multiline-comment-style) rule (fixes [#8320](https://github.com/eslint/eslint/issues/8320)) ([#9389](https://github.com/eslint/eslint/issues/9389)) (薛定谔的猫)
* [ee99876](https://github.com/eslint/eslint/commit/ee99876) New: [lines-between-class-members](/docs/rules/lines-between-class-members) rule (fixes [#5949](https://github.com/eslint/eslint/issues/5949)) ([#9141](https://github.com/eslint/eslint/issues/9141)) (薛定谔的猫)
* [4567ab1](https://github.com/eslint/eslint/commit/4567ab1) New: Add the fix-dry-run flag (fixes [#9076](https://github.com/eslint/eslint/issues/9076)) ([#9073](https://github.com/eslint/eslint/issues/9073)) (Rafał Ruciński)




## Enhancements


* [2247efa](https://github.com/eslint/eslint/commit/2247efa) Update: Add FunctionExpression to [require-jsdoc](/docs/rules/require-jsdoc) (fixes [#5867](https://github.com/eslint/eslint/issues/5867)) ([#9395](https://github.com/eslint/eslint/issues/9395)) (Kai Cataldo)
* [b02fbb6](https://github.com/eslint/eslint/commit/b02fbb6) Update: custom messages for no-restricted-* (refs [#8400](https://github.com/eslint/eslint/issues/8400)) (Maja Wichrowska)
* [6767857](https://github.com/eslint/eslint/commit/6767857) Update: fix ignored nodes in [indent](/docs/rules/indent) rule when using tabs (fixes [#9392](https://github.com/eslint/eslint/issues/9392)) ([#9393](https://github.com/eslint/eslint/issues/9393)) (Robin Houston)
* [786cc73](https://github.com/eslint/eslint/commit/786cc73) Update: Add "consistent" option to [array-bracket-newline](/docs/rules/array-bracket-newline) (fixes [#9136](https://github.com/eslint/eslint/issues/9136)) ([#9206](https://github.com/eslint/eslint/issues/9206)) (Ethan Rutherford)
* [1167638](https://github.com/eslint/eslint/commit/1167638) Update: add allowElseIf option to [no-else-return](/docs/rules/no-else-return) (fixes [#9228](https://github.com/eslint/eslint/issues/9228)) ([#9229](https://github.com/eslint/eslint/issues/9229)) (Thomas Grainger)
* [62a323c](https://github.com/eslint/eslint/commit/62a323c) Fix: Add class options for [`lines-around-comment`](/docs/rules/lines-around-comment) (fixes [#8564](https://github.com/eslint/eslint/issues/8564)) ([#8565](https://github.com/eslint/eslint/issues/8565)) (Ed Lee)



## Bug Fixes


* [85388fb](https://github.com/eslint/eslint/commit/85388fb) Fix: Correct error and test messages to fit config search path ([#9428](https://github.com/eslint/eslint/issues/9428)) (Jonathan Pool)
* [8da525f](https://github.com/eslint/eslint/commit/8da525f) Fix: recognise multiline comments as multiline arrays (fixes [#9211](https://github.com/eslint/eslint/issues/9211)) ([#9369](https://github.com/eslint/eslint/issues/9369)) (Phil Quinn)




## Documentation


* [6791d18](https://github.com/eslint/eslint/commit/6791d18) Docs: Corrected noun to verb. ([#9438](https://github.com/eslint/eslint/issues/9438)) (Jonathan Pool)
* [02732bd](https://github.com/eslint/eslint/commit/02732bd) Docs: Reorganized to avoid misunderstandings. ([#9434](https://github.com/eslint/eslint/issues/9434)) (Jonathan Pool)
* [d9466b8](https://github.com/eslint/eslint/commit/d9466b8) Docs: Correct time forecast for tests. ([#9432](https://github.com/eslint/eslint/issues/9432)) (Jonathan Pool)
* [f7ed84f](https://github.com/eslint/eslint/commit/f7ed84f) Docs: Add instruction re home-directory config files (refs [#7729](https://github.com/eslint/eslint/issues/7729)) ([#9426](https://github.com/eslint/eslint/issues/9426)) (Jonathan Pool)
* [2d8a303](https://github.com/eslint/eslint/commit/2d8a303) Docs: fix examples for [prefer-numeric-literals](/docs/rules/prefer-numeric-literals) ([#9155](https://github.com/eslint/eslint/issues/9155)) (Lutz Lengemann)
* [d7610f5](https://github.com/eslint/eslint/commit/d7610f5) Docs: Add jquery warning to [prefer-destructuring](/docs/rules/prefer-destructuring) ([#9409](https://github.com/eslint/eslint/issues/9409)) (Thomas Grainger)
* [e835dd1](https://github.com/eslint/eslint/commit/e835dd1) Docs: clarify [no-mixed-operators](/docs/rules/no-mixed-operators) (fixes [#8051](https://github.com/eslint/eslint/issues/8051)) (Ruxandra Fediuc)
* [51360c8](https://github.com/eslint/eslint/commit/51360c8) Docs: update [block-spacing](/docs/rules/block-spacing) details (fixes [#8743](https://github.com/eslint/eslint/issues/8743)) ([#9375](https://github.com/eslint/eslint/issues/9375)) (Victor Hom)
* [7654c99](https://github.com/eslint/eslint/commit/7654c99) Docs: add installing prerequisites in readme. ([#9401](https://github.com/eslint/eslint/issues/9401)) (薛定谔的猫)
* [e171f6b](https://github.com/eslint/eslint/commit/e171f6b) Docs: add installing prerequisites. ([#9394](https://github.com/eslint/eslint/issues/9394)) (薛定谔的猫)
* [74dfc87](https://github.com/eslint/eslint/commit/74dfc87) Docs: update doc for [class-methods-use-this](/docs/rules/class-methods-use-this) (fixes [#8910](https://github.com/eslint/eslint/issues/8910)) ([#9374](https://github.com/eslint/eslint/issues/9374)) (Victor Hom)
* [b4a9dbf](https://github.com/eslint/eslint/commit/b4a9dbf) Docs: show console call with [no-restricted-syntax](/docs/rules/no-restricted-syntax) (fixes [#7806](https://github.com/eslint/eslint/issues/7806)) ([#9376](https://github.com/eslint/eslint/issues/9376)) (Victor Hom)








## Chores


* [db41408](https://github.com/eslint/eslint/commit/db41408) Chore: avoid applying eslint-env comments twice ([#9278](https://github.com/eslint/eslint/issues/9278)) (Teddy Katz)
* [febb897](https://github.com/eslint/eslint/commit/febb897) Chore: avoid loose equality assertions ([#9415](https://github.com/eslint/eslint/issues/9415)) (Teddy Katz)
* [30d018b](https://github.com/eslint/eslint/commit/30d018b) Chore: Add Aladdin-ADD & VictorHom to README ([#9424](https://github.com/eslint/eslint/issues/9424)) (Kai Cataldo)
* [37dde77](https://github.com/eslint/eslint/commit/37dde77) Chore: Refactor SourceCode#getJSDocComment ([#9403](https://github.com/eslint/eslint/issues/9403)) (Kai Cataldo)
* [9fedd51](https://github.com/eslint/eslint/commit/9fedd51) Chore: Add missing space in blog post template ([#9407](https://github.com/eslint/eslint/issues/9407)) (Kevin Partington)
* [c581b77](https://github.com/eslint/eslint/commit/c581b77) Chore: Error => TypeError ([#9390](https://github.com/eslint/eslint/issues/9390)) (薛定谔的猫)
* [9d3f5ad](https://github.com/eslint/eslint/commit/9d3f5ad) Chore: report unused eslint-disable directives in ESLint codebase ([#9371](https://github.com/eslint/eslint/issues/9371)) (Teddy Katz)
