---
layout: post
title: ESLint v4.8.0 released
teaser: "We just pushed ESLint v4.8.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - kaicataldo
categories:
  - Release Notes
---

## Highlights

### --report-unused-disable-directives

This release includes a new CLI option that, when on, reports unused `eslint-disable` directives! Running this periodically will ensure that all `eslint-disable` comments are still relevant and up to date.

Please see the [documentation](https://eslint.org/docs/user-guide/command-line-interface#--report-unused-disable-directives) for more information.

## Features


* [3f2b908](https://github.com/eslint/eslint/commit/3f2b908) New: add option to report unused eslint-disable directives (fixes [#9249](https://github.com/eslint/eslint/issues/9249)) ([#9250](https://github.com/eslint/eslint/issues/9250)) (Teddy Katz)






## Bug Fixes


* [ff2be59](https://github.com/eslint/eslint/commit/ff2be59) Fix: dot notation rule failing to catch string template (fixes [#9350](https://github.com/eslint/eslint/issues/9350)) ([#9357](https://github.com/eslint/eslint/issues/9357)) (Phil Quinn)
* [06efe87](https://github.com/eslint/eslint/commit/06efe87) Fix: Add meta element with charset attribute. ([#9365](https://github.com/eslint/eslint/issues/9365)) (H1Gdev)
* [1c6bc67](https://github.com/eslint/eslint/commit/1c6bc67) Fix: special EventEmitter keys leak information about other rules ([#9328](https://github.com/eslint/eslint/issues/9328)) (Teddy Katz)
* [38d0cb2](https://github.com/eslint/eslint/commit/38d0cb2) Fix: fix wrong code-path about try-for-in (fixes [#8848](https://github.com/eslint/eslint/issues/8848)) ([#9348](https://github.com/eslint/eslint/issues/9348)) (Toru Nagashima)
* [434d9e2](https://github.com/eslint/eslint/commit/434d9e2) Fix: Invalid font-size property value issue. ([#9341](https://github.com/eslint/eslint/issues/9341)) (H1Gdev)




## Documentation


* [cef6f8c](https://github.com/eslint/eslint/commit/cef6f8c) Docs: remove line about removing rules from semver policy ([#9367](https://github.com/eslint/eslint/issues/9367)) (Teddy Katz)
* [458ca67](https://github.com/eslint/eslint/commit/458ca67) Docs: update architecture page (fixes [#9337](https://github.com/eslint/eslint/issues/9337)) ([#9345](https://github.com/eslint/eslint/issues/9345)) (Victor Hom)
* [d593e61](https://github.com/eslint/eslint/commit/d593e61) Docs: update eslint.org links to use https ([#9358](https://github.com/eslint/eslint/issues/9358)) (Teddy Katz)








## Chores


* [b1372da](https://github.com/eslint/eslint/commit/b1372da) Chore: remove sourceCode property from Linter (refs [#9161](https://github.com/eslint/eslint/issues/9161)) ([#9363](https://github.com/eslint/eslint/issues/9363)) (Teddy Katz)
* [a7668c2](https://github.com/eslint/eslint/commit/a7668c2) Chore: Remove unnecessary slice from logging utility ([#9343](https://github.com/eslint/eslint/issues/9343)) (Gyandeep Singh)
* [2ff6fb6](https://github.com/eslint/eslint/commit/2ff6fb6) Chore: remove unused arguments in codebase ([#9340](https://github.com/eslint/eslint/issues/9340)) (Teddy Katz)
