---
layout: post
title: ESLint v4.7.0 released
teaser: "We just pushed ESLint v4.7.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - btmills
categories:
  - Release Notes
---

## Highlights

- [newline-per-chained-call](/docs/rules/newline-per-chained-call) supports autofix.
- Processor plugins can now autofix code.
    To support autofix in processor plugins, developers can signal support by setting `supportsAutofix: true` and update the `postprocess` method to transform `fix` ranges in reported problems.
    This is explained fully in the [Processors documentation](https://eslint.org/docs/developer-guide/working-with-plugins#processors-in-plugins).




## Enhancements


* [1488b51](https://github.com/eslint/eslint/commit/1488b51) Update: run rules after `node.parent` is already set (fixes [#9122](https://github.com/eslint/eslint/issues/9122)) ([#9283](https://github.com/eslint/eslint/issues/9283)) (Teddy Katz)
* [ce1f084](https://github.com/eslint/eslint/commit/ce1f084) Update: fix MemberExpression handling in [no-extra-parens](/docs/rules/no-extra-parens) (fixes [#9156](https://github.com/eslint/eslint/issues/9156)) (jackyho112)
* [0c720a3](https://github.com/eslint/eslint/commit/0c720a3) Update: allow autofixing when using processors (fixes [#7510](https://github.com/eslint/eslint/issues/7510)) ([#9090](https://github.com/eslint/eslint/issues/9090)) (Teddy Katz)
* [f12def6](https://github.com/eslint/eslint/commit/f12def6) Update: [indent](/docs/rules/indent) flatTernary option to handle `return` (fixes [#9285](https://github.com/eslint/eslint/issues/9285)) ([#9296](https://github.com/eslint/eslint/issues/9296)) (Teddy Katz)
* [2731f94](https://github.com/eslint/eslint/commit/2731f94) Update: make [newline-per-chained-call](/docs/rules/newline-per-chained-call) fixable ([#9149](https://github.com/eslint/eslint/issues/9149)) (João Granado)
* [a32ec36](https://github.com/eslint/eslint/commit/a32ec36) Update: refactor eslint-disable comment processing ([#9216](https://github.com/eslint/eslint/issues/9216)) (Teddy Katz)




## Bug Fixes


* [e220687](https://github.com/eslint/eslint/commit/e220687) Fix: remove autofix for var undef inits (fixes [#9231](https://github.com/eslint/eslint/issues/9231)) ([#9288](https://github.com/eslint/eslint/issues/9288)) (Victor Hom)
* [7685fed](https://github.com/eslint/eslint/commit/7685fed) Fix: IIFE and arrow functions in [no-invalid-this](/docs/rules/no-invalid-this) (fixes [#9126](https://github.com/eslint/eslint/issues/9126)) ([#9258](https://github.com/eslint/eslint/issues/9258)) (Toru Nagashima)
* [981f933](https://github.com/eslint/eslint/commit/981f933) Fix: reuse the AST of source code object in verify ([#9256](https://github.com/eslint/eslint/issues/9256)) (Toru Nagashima)
* [51132d6](https://github.com/eslint/eslint/commit/51132d6) Fix: Formatters keep trailing '.' if preceded by a space (fixes [#9154](https://github.com/eslint/eslint/issues/9154)) ([#9247](https://github.com/eslint/eslint/issues/9247)) (i-ron-y)
* [7ba46e6](https://github.com/eslint/eslint/commit/7ba46e6) Fix: shebang error in eslint-disable-new-line; add tests (fixes [#9238](https://github.com/eslint/eslint/issues/9238)) ([#9240](https://github.com/eslint/eslint/issues/9240)) (i-ron-y)




## Documentation


* [4431d68](https://github.com/eslint/eslint/commit/4431d68) Docs: fix wrong config in [max-len](/docs/rules/max-len) example. ([#9309](https://github.com/eslint/eslint/issues/9309)) (薛定谔的猫)
* [7d24dde](https://github.com/eslint/eslint/commit/7d24dde) Docs: Fix code snippet to refer to the correct option ([#9313](https://github.com/eslint/eslint/issues/9313)) (Ruben Tytgat)
* [002e199](https://github.com/eslint/eslint/commit/002e199) Docs: fix [no-restricted-globals](/docs/rules/no-restricted-globals) wrong config. ([#9305](https://github.com/eslint/eslint/issues/9305)) (薛定谔的猫)
* [fcfe91a](https://github.com/eslint/eslint/commit/fcfe91a) Docs: fix wrong config in [id-length](/docs/rules/id-length) example. ([#9303](https://github.com/eslint/eslint/issues/9303)) (薛定谔的猫)
* [cd698ba](https://github.com/eslint/eslint/commit/cd698ba) Docs: move RuleTester documentation to Node.js API page ([#9273](https://github.com/eslint/eslint/issues/9273)) (Teddy Katz)
* [4ae7ad3](https://github.com/eslint/eslint/commit/4ae7ad3) Docs: fix inaccuracy in `npm run perf` description ([#9274](https://github.com/eslint/eslint/issues/9274)) (Teddy Katz)
* [cad45bd](https://github.com/eslint/eslint/commit/cad45bd) Docs: improve documentation for rule contexts ([#9272](https://github.com/eslint/eslint/issues/9272)) (Teddy Katz)
* [c3231b3](https://github.com/eslint/eslint/commit/c3231b3) Docs: Fix typo in [array-bracket-newline](/docs/rules/array-bracket-newline).md ([#9269](https://github.com/eslint/eslint/issues/9269)) (宋文强)
* [82d8b73](https://github.com/eslint/eslint/commit/82d8b73) Docs: Fix error in example code for [sort-imports](/docs/rules/sort-imports) (fixes [#8734](https://github.com/eslint/eslint/issues/8734)) ([#9245](https://github.com/eslint/eslint/issues/9245)) (i-ron-y)
* [5566e94](https://github.com/eslint/eslint/commit/5566e94) Docs: Replace misleading CLA links ([#9133](https://github.com/eslint/eslint/issues/9133)) ([#9232](https://github.com/eslint/eslint/issues/9232)) (i-ron-y)




## Dependency Upgrades


* [787b78b](https://github.com/eslint/eslint/commit/787b78b) Upgrade: Espree v3.5.1 (fixes [#9153](https://github.com/eslint/eslint/issues/9153)) ([#9314](https://github.com/eslint/eslint/issues/9314)) (Brandon Mills)




## Build Related


* [abc8634](https://github.com/eslint/eslint/commit/abc8634) Build: re-run browserify when generating site ([#9275](https://github.com/eslint/eslint/issues/9275)) (Teddy Katz)




## Chores


* [838df76](https://github.com/eslint/eslint/commit/838df76) Chore: upgrade deps. ([#9289](https://github.com/eslint/eslint/issues/9289)) (薛定谔的猫)
* [61f1093](https://github.com/eslint/eslint/commit/61f1093) Chore: avoid monkeypatching Linter instances in RuleTester ([#9276](https://github.com/eslint/eslint/issues/9276)) (Teddy Katz)
* [28929cb](https://github.com/eslint/eslint/commit/28929cb) Chore: remove Linter#reset (refs [#9161](https://github.com/eslint/eslint/issues/9161)) ([#9268](https://github.com/eslint/eslint/issues/9268)) (Teddy Katz)
* [2b1eba2](https://github.com/eslint/eslint/commit/2b1eba2) Chore: enable eslint-plugin/no-deprecated-context-methods ([#9279](https://github.com/eslint/eslint/issues/9279)) (Teddy Katz)
* [3b0c6fd](https://github.com/eslint/eslint/commit/3b0c6fd) Chore: remove extraneous linter properties (refs [#9161](https://github.com/eslint/eslint/issues/9161)) ([#9267](https://github.com/eslint/eslint/issues/9267)) (Teddy Katz)
* [88d5d4d](https://github.com/eslint/eslint/commit/88d5d4d) Chore: remove undocumented Linter#markVariableAsUsed method (refs [#9161](https://github.com/eslint/eslint/issues/9161)) ([#9266](https://github.com/eslint/eslint/issues/9266)) (Teddy Katz)
* [09414cf](https://github.com/eslint/eslint/commit/09414cf) Chore: remove internal Linter#getDeclaredVariables method (refs [#9161](https://github.com/eslint/eslint/issues/9161)) ([#9264](https://github.com/eslint/eslint/issues/9264)) (Teddy Katz)
* [f31f59d](https://github.com/eslint/eslint/commit/f31f59d) Chore: prefer smaller scope for variables in codebase ([#9265](https://github.com/eslint/eslint/issues/9265)) (Teddy Katz)
* [3693e4e](https://github.com/eslint/eslint/commit/3693e4e) Chore: remove undocumented Linter#getScope method ([#9253](https://github.com/eslint/eslint/issues/9253)) (Teddy Katz)
* [5d7eb81](https://github.com/eslint/eslint/commit/5d7eb81) Chore: refactor config hash caching in CLIEngine ([#9260](https://github.com/eslint/eslint/issues/9260)) (Teddy Katz)
* [1a76c4d](https://github.com/eslint/eslint/commit/1a76c4d) Chore: remove SourceCode passthroughs from Linter.prototype (refs [#9161](https://github.com/eslint/eslint/issues/9161)) ([#9263](https://github.com/eslint/eslint/issues/9263)) (Teddy Katz)
* [40ae27b](https://github.com/eslint/eslint/commit/40ae27b) Chore: avoid relying on Linter#getScope/markVariableAsUsed in tests ([#9252](https://github.com/eslint/eslint/issues/9252)) (Teddy Katz)
* [b383d81](https://github.com/eslint/eslint/commit/b383d81) Chore: make executeOnFile a pure function in CLIEngine ([#9262](https://github.com/eslint/eslint/issues/9262)) (Teddy Katz)
* [5e0e579](https://github.com/eslint/eslint/commit/5e0e579) Chore: avoid internal SourceCode methods in Linter tests (refs [#9161](https://github.com/eslint/eslint/issues/9161)) ([#9223](https://github.com/eslint/eslint/issues/9223)) (Teddy Katz)
* [adab827](https://github.com/eslint/eslint/commit/adab827) Chore: remove unused eslint-disable comment ([#9251](https://github.com/eslint/eslint/issues/9251)) (Teddy Katz)
* [31e4ec8](https://github.com/eslint/eslint/commit/31e4ec8) Chore: use consistent names for apply-disable-directives in tests ([#9246](https://github.com/eslint/eslint/issues/9246)) (Teddy Katz)
* [8f6546c](https://github.com/eslint/eslint/commit/8f6546c) Chore: remove undocumented defaults() method (refs [#9161](https://github.com/eslint/eslint/issues/9161)) ([#9237](https://github.com/eslint/eslint/issues/9237)) (Teddy Katz)
* [583f0b8](https://github.com/eslint/eslint/commit/583f0b8) Chore: avoid using globals in CLIEngine tests ([#9242](https://github.com/eslint/eslint/issues/9242)) (Teddy Katz)
* [c8bf687](https://github.com/eslint/eslint/commit/c8bf687) Chore: upgrade eslint-plugin-eslint-plugin@1.0.0 ([#9234](https://github.com/eslint/eslint/issues/9234)) (薛定谔的猫)
* [3c41a05](https://github.com/eslint/eslint/commit/3c41a05) Chore: always normalize rules to new API in rules.js ([#9236](https://github.com/eslint/eslint/issues/9236)) (Teddy Katz)
* [c5f4227](https://github.com/eslint/eslint/commit/c5f4227) Chore: move logic for handling missing rules to rules.js ([#9235](https://github.com/eslint/eslint/issues/9235)) (Teddy Katz)
* [bf1e344](https://github.com/eslint/eslint/commit/bf1e344) Chore: create report translators lazily ([#9221](https://github.com/eslint/eslint/issues/9221)) (Teddy Katz)
* [2eedc1f](https://github.com/eslint/eslint/commit/2eedc1f) Chore: remove currentFilename prop from Linter instances (refs [#9161](https://github.com/eslint/eslint/issues/9161)) ([#9219](https://github.com/eslint/eslint/issues/9219)) (Teddy Katz)
* [c991630](https://github.com/eslint/eslint/commit/c991630) Chore: remove ConfigOps.normalize in favor of ConfigOps.getRuleSeverity ([#9224](https://github.com/eslint/eslint/issues/9224)) (Teddy Katz)
* [171962a](https://github.com/eslint/eslint/commit/171962a) Chore: remove internal Linter#getAncestors helper (refs [#9161](https://github.com/eslint/eslint/issues/9161)) ([#9222](https://github.com/eslint/eslint/issues/9222)) (Teddy Katz)
* [a567499](https://github.com/eslint/eslint/commit/a567499) Chore: avoid storing list of problems on Linter instance (refs [#9161](https://github.com/eslint/eslint/issues/9161)) ([#9214](https://github.com/eslint/eslint/issues/9214)) (Teddy Katz)
* [ed6d088](https://github.com/eslint/eslint/commit/ed6d088) Chore: avoid relying on undocumented Linter#getFilename API in tests ([#9218](https://github.com/eslint/eslint/issues/9218)) (Teddy Katz)
