---
layout: post
title: ESLint v4.6.0 released
teaser: "We just pushed ESLint v4.6.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - not-an-aardvark
categories:
  - Release Notes
---

## Highlights

* One new rule has been added: [`function-paren-newline`](/docs/rules/function-paren-newline)
* The [`generator-star-spacing`](/docs/rules/generator-star-spacing) rule is now configurable by function type.

## Features


* [0e09973](https://github.com/eslint/eslint/commit/0e09973) New: [function-paren-newline](/docs/rules/function-paren-newline) rule (fixes [#6074](https://github.com/eslint/eslint/issues/6074)) ([#8102](https://github.com/eslint/eslint/issues/8102)) (Teddy Katz)




## Enhancements


* [6becf91](https://github.com/eslint/eslint/commit/6becf91) Update: add eslint version to error output. (fixes [#9037](https://github.com/eslint/eslint/issues/9037)) ([#9071](https://github.com/eslint/eslint/issues/9071)) (薛定谔的猫)
* [2db356b](https://github.com/eslint/eslint/commit/2db356b) Update: [no-unused-vars](/docs/rules/no-unused-vars) Improve message to include the allowed patterns ([#9176](https://github.com/eslint/eslint/issues/9176)) (Eli White)
* [8fbaf0a](https://github.com/eslint/eslint/commit/8fbaf0a) Update: Add configurability to [generator-star-spacing](/docs/rules/generator-star-spacing) ([#8985](https://github.com/eslint/eslint/issues/8985)) (Ethan Rutherford)




## Bug Fixes


* [1bbac51](https://github.com/eslint/eslint/commit/1bbac51) Fix: avoid breaking eslint-plugin-eslint-comments (fixes [#9193](https://github.com/eslint/eslint/issues/9193)) ([#9196](https://github.com/eslint/eslint/issues/9196)) (Teddy Katz)
* [3e8b70a](https://github.com/eslint/eslint/commit/3e8b70a) Fix: off-by-one error in eslint-disable comment checking ([#9195](https://github.com/eslint/eslint/issues/9195)) (Teddy Katz)
* [af4ad60](https://github.com/eslint/eslint/commit/af4ad60) Fix: Handle error when running init without npm ([#9169](https://github.com/eslint/eslint/issues/9169)) (Gabriel Aumala)
* [5ab0434](https://github.com/eslint/eslint/commit/5ab0434) Fix: [indent](/docs/rules/indent) crash on sparse arrays with "off" option (fixes [#9157](https://github.com/eslint/eslint/issues/9157)) ([#9166](https://github.com/eslint/eslint/issues/9166)) (Teddy Katz)
* [d6e436f](https://github.com/eslint/eslint/commit/d6e436f) Fix: [no-extra-parens](/docs/rules/no-extra-parens) reported some parenthesized IIFEs (fixes [#9140](https://github.com/eslint/eslint/issues/9140)) ([#9158](https://github.com/eslint/eslint/issues/9158)) (Teddy Katz)




## Documentation


* [56dd769](https://github.com/eslint/eslint/commit/56dd769) Docs: fix link format in [prefer-arrow-callback](/docs/rules/prefer-arrow-callback).md ([#9198](https://github.com/eslint/eslint/issues/9198)) (Vse Mozhet Byt)
* [73815f6](https://github.com/eslint/eslint/commit/73815f6) Docs: rewrite [prefer-arrow-callback](/docs/rules/prefer-arrow-callback) documentation (fixes [#8950](https://github.com/eslint/eslint/issues/8950)) ([#9077](https://github.com/eslint/eslint/issues/9077)) (Charles E. Morgan)
* [de6dccd](https://github.com/eslint/eslint/commit/de6dccd) Docs: add documentation for Linter methods (refs [#6525](https://github.com/eslint/eslint/issues/6525)) ([#9151](https://github.com/eslint/eslint/issues/9151)) (Teddy Katz)
* [ffa021e](https://github.com/eslint/eslint/commit/ffa021e) Docs: [quotes](/docs/rules/quotes) rule - when does \n require backticks ([#9135](https://github.com/eslint/eslint/issues/9135)) (avimar)






## Build Related


* [e6b115c](https://github.com/eslint/eslint/commit/e6b115c) Build: Add an edit link to the rule docs’ metadata ([#9049](https://github.com/eslint/eslint/issues/9049)) (Jed Fox)




## Chores


* [88a64cc](https://github.com/eslint/eslint/commit/88a64cc) Chore: Make parseJsonConfig() a pure function in Linter ([#9186](https://github.com/eslint/eslint/issues/9186)) (Teddy Katz)
* [0d3a854](https://github.com/eslint/eslint/commit/0d3a854) Chore: avoid mutating report descriptors in report-translator ([#9189](https://github.com/eslint/eslint/issues/9189)) (Teddy Katz)
* [8ed779c](https://github.com/eslint/eslint/commit/8ed779c) Chore: remove currentScopes property from Linter instances (refs [#9161](https://github.com/eslint/eslint/issues/9161)) ([#9187](https://github.com/eslint/eslint/issues/9187)) (Teddy Katz)
* [4b94c6c](https://github.com/eslint/eslint/commit/4b94c6c) Chore: make parse() a pure function in Linter (refs [#9161](https://github.com/eslint/eslint/issues/9161)) ([#9183](https://github.com/eslint/eslint/issues/9183)) (Teddy Katz)
* [1be5634](https://github.com/eslint/eslint/commit/1be5634) Chore: don't make Linter a subclass of EventEmitter (refs [#9161](https://github.com/eslint/eslint/issues/9161)) ([#9177](https://github.com/eslint/eslint/issues/9177)) (Teddy Katz)
* [e95af9b](https://github.com/eslint/eslint/commit/e95af9b) Chore: don't include internal test helpers in npm package ([#9160](https://github.com/eslint/eslint/issues/9160)) (Teddy Katz)
* [6fb32e1](https://github.com/eslint/eslint/commit/6fb32e1) Chore: avoid using private Linter APIs in astUtils tests (refs [#9161](https://github.com/eslint/eslint/issues/9161)) ([#9173](https://github.com/eslint/eslint/issues/9173)) (Teddy Katz)
* [2d90030](https://github.com/eslint/eslint/commit/2d90030) Chore: remove unused assignment. ([#9182](https://github.com/eslint/eslint/issues/9182)) (薛定谔的猫)
* [d672aef](https://github.com/eslint/eslint/commit/d672aef) Chore: refactor reporting logic (refs [#9161](https://github.com/eslint/eslint/issues/9161)) ([#9168](https://github.com/eslint/eslint/issues/9168)) (Teddy Katz)
* [c147b97](https://github.com/eslint/eslint/commit/c147b97) Chore: Make SourceCodeFixer accept text instead of a SourceCode instance ([#9178](https://github.com/eslint/eslint/issues/9178)) (Teddy Katz)
* [f127423](https://github.com/eslint/eslint/commit/f127423) Chore: avoid using private Linter APIs in Linter tests (refs [#9161](https://github.com/eslint/eslint/issues/9161)) ([#9175](https://github.com/eslint/eslint/issues/9175)) (Teddy Katz)
* [2334335](https://github.com/eslint/eslint/commit/2334335) Chore: avoid using private Linter APIs in SourceCode tests (refs [#9161](https://github.com/eslint/eslint/issues/9161)) ([#9174](https://github.com/eslint/eslint/issues/9174)) (Teddy Katz)
* [2dc243a](https://github.com/eslint/eslint/commit/2dc243a) Chore: avoid using internal Linter APIs in RuleTester (refs [#9161](https://github.com/eslint/eslint/issues/9161)) ([#9172](https://github.com/eslint/eslint/issues/9172)) (Teddy Katz)
* [fcb7bb4](https://github.com/eslint/eslint/commit/fcb7bb4) Chore: avoid unnecessarily complex forEach calls in [no-extra-parens](/docs/rules/no-extra-parens) ([#9159](https://github.com/eslint/eslint/issues/9159)) (Teddy Katz)
* [60c5148](https://github.com/eslint/eslint/commit/60c5148) Chore: improve coverage in lib/*.js ([#9130](https://github.com/eslint/eslint/issues/9130)) (Teddy Katz)
