---
layout: post
title: ESLint v4.5.0 released
teaser: "We just pushed ESLint v4.5.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - not-an-aardvark
categories:
  - Release Notes
---

## Highlights

* The [`indent`](/docs/rules/indent) rule can now be configured to ignore the indentation of specific types of syntax, using the `ignoredNodes` option. This can be useful if you disagree with some of the indentation choices made by the `indent` rule; instead of disabling the rule entirely when this happens, you can now configure it to avoid checking indentation for the specific cases that you want it to ignore.


## Enhancements


* [decdd2c](https://github.com/eslint/eslint/commit/decdd2c) Update: allow arbitrary nodes to be ignored in [`indent`](/docs/rules/indent) (fixes [#8594](https://github.com/eslint/eslint/issues/8594)) ([#9105](https://github.com/eslint/eslint/issues/9105)) (Teddy Katz)
* [79062f3](https://github.com/eslint/eslint/commit/79062f3) Update: fix indentation of multiline `new.target` expressions ([#9116](https://github.com/eslint/eslint/issues/9116)) (Teddy Katz)
* [bd09cd5](https://github.com/eslint/eslint/commit/bd09cd5) Update: avoid requiring NaN spaces of indentation (fixes [#9083](https://github.com/eslint/eslint/issues/9083)) ([#9085](https://github.com/eslint/eslint/issues/9085)) (Teddy Katz)




## Bug Fixes


* [a4f53ba](https://github.com/eslint/eslint/commit/a4f53ba) Fix: Include files with no messages in junit results ([#9093](https://github.com/eslint/eslint/issues/9093)) ([#9094](https://github.com/eslint/eslint/issues/9094)) (Sean DuBois)
* [f8add8f](https://github.com/eslint/eslint/commit/f8add8f) Fix: don't autofix with linter.verifyAndFix when `fix: false` is used ([#9098](https://github.com/eslint/eslint/issues/9098)) (Teddy Katz)




## Documentation


* [6ef734a](https://github.com/eslint/eslint/commit/6ef734a) Docs: add missing word in processor documentation ([#9106](https://github.com/eslint/eslint/issues/9106)) (Teddy Katz)
* [77bcee4](https://github.com/eslint/eslint/commit/77bcee4) Docs: update instructions for adding TSC members ([#9086](https://github.com/eslint/eslint/issues/9086)) (Teddy Katz)




## Dependency Upgrades


* [d00e24f](https://github.com/eslint/eslint/commit/d00e24f) Upgrade: `chalk` to 2.x release ([#9115](https://github.com/eslint/eslint/issues/9115)) (Stephen Edgar)






## Chores


* [1d6a9c0](https://github.com/eslint/eslint/commit/1d6a9c0) Chore: enable eslint-plugin/test-case-shorthand-strings ([#9067](https://github.com/eslint/eslint/issues/9067)) (薛定谔的猫)
* [c93a853](https://github.com/eslint/eslint/commit/c93a853) Chore: Remove extra space in blogpost template ([#9088](https://github.com/eslint/eslint/issues/9088)) (Kai Cataldo)
