---
layout: post
title: ESLint v4.4.0 released
teaser: "We just pushed ESLint v4.4.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - kaicataldo
categories:
  - Release Notes
---

## Highlights


### Initial support for ECMAScript 2018
Because ECMAScript 2018 is still under development, we are implementing features as they are finalized. This release includes the following:

* Invalid escape sequences in tagged template literals




## Enhancements


* [62911e4](https://github.com/eslint/eslint/commit/62911e4) Update: Add ImportDeclaration option to [indent](/docs/rules/indent) rule ([#8955](https://github.com/eslint/eslint/issues/8955)) (David Irvine)
* [7247b6c](https://github.com/eslint/eslint/commit/7247b6c) Update: handle indentation of custom destructuring syntax (fixes [#8990](https://github.com/eslint/eslint/issues/8990)) ([#9027](https://github.com/eslint/eslint/issues/9027)) (Teddy Katz)
* [3d020b9](https://github.com/eslint/eslint/commit/3d020b9) Update: emit a warning for ecmaFeatures rather than throwing an error ([#8974](https://github.com/eslint/eslint/issues/8974)) (Teddy Katz)




## Bug Fixes


* [b3e4598](https://github.com/eslint/eslint/commit/b3e4598) Fix: clarify AST and don't use `node.start`/`node.end` (fixes [#8956](https://github.com/eslint/eslint/issues/8956)) ([#8984](https://github.com/eslint/eslint/issues/8984)) (Toru Nagashima)
* [78a85e0](https://github.com/eslint/eslint/commit/78a85e0) Fix: [no-extra-parens](/docs/rules/no-extra-parens) incorrectly reports async function expressions ([#9035](https://github.com/eslint/eslint/issues/9035)) (薛定谔的猫)
* [c794f86](https://github.com/eslint/eslint/commit/c794f86) Fix: [getter-return](/docs/rules/getter-return) reporting method named 'get' (fixes [#8919](https://github.com/eslint/eslint/issues/8919)) ([#9004](https://github.com/eslint/eslint/issues/9004)) (薛定谔的猫)
* [5ab282f](https://github.com/eslint/eslint/commit/5ab282f) Fix: Print error message in bin/eslint.js (fixes [#9011](https://github.com/eslint/eslint/issues/9011)) ([#9041](https://github.com/eslint/eslint/issues/9041)) (Victor Hom)
* [cdb82f2](https://github.com/eslint/eslint/commit/cdb82f2) Fix: [padding-line-between-statements](/docs/rules/padding-line-between-statements) crash on semicolons after blocks ([#8748](https://github.com/eslint/eslint/issues/8748)) (Alexander Madyankin)
* [0f97279](https://github.com/eslint/eslint/commit/0f97279) Fix: refactor [no-multi-spaces](/docs/rules/no-multi-spaces) to avoid regex backtracking (fixes [#9001](https://github.com/eslint/eslint/issues/9001)) ([#9008](https://github.com/eslint/eslint/issues/9008)) (Teddy Katz)
* [b74514d](https://github.com/eslint/eslint/commit/b74514d) Fix: refactor RuleContext to not modify report locations (fixes [#8980](https://github.com/eslint/eslint/issues/8980)) ([#8997](https://github.com/eslint/eslint/issues/8997)) (Teddy Katz)
* [31d7fd2](https://github.com/eslint/eslint/commit/31d7fd2) Fix: inconsistent [`indent`](/docs/rules/indent) behavior on computed properties (fixes [#8989](https://github.com/eslint/eslint/issues/8989)) ([#8999](https://github.com/eslint/eslint/issues/8999)) (Teddy Katz)
* [3393894](https://github.com/eslint/eslint/commit/3393894) Fix: avoid reporting the entire AST for missing rules ([#8998](https://github.com/eslint/eslint/issues/8998)) (Teddy Katz)
* [d2f8f9f](https://github.com/eslint/eslint/commit/d2f8f9f) Fix: include name of invalid config in validation messages (fixes [#8963](https://github.com/eslint/eslint/issues/8963)) ([#8973](https://github.com/eslint/eslint/issues/8973)) (Teddy Katz)




## Documentation


* [5ae8458](https://github.com/eslint/eslint/commit/5ae8458) Docs: fix typo in [object-shorthand](/docs/rules/object-shorthand).md ([#9066](https://github.com/eslint/eslint/issues/9066)) (Jon Berry)
* [c3d5b39](https://github.com/eslint/eslint/commit/c3d5b39) Docs: clarify options descriptions (fixes [#8875](https://github.com/eslint/eslint/issues/8875)) ([#9060](https://github.com/eslint/eslint/issues/9060)) (Brandon Mailhiot)
* [37158c5](https://github.com/eslint/eslint/commit/37158c5) Docs: clarified behavior of globalReturn option (fixes [#8953](https://github.com/eslint/eslint/issues/8953)) ([#9058](https://github.com/eslint/eslint/issues/9058)) (Brandon Mailhiot)
* [c2f3553](https://github.com/eslint/eslint/commit/c2f3553) Docs: Update example for MemberExpression option of [indent](/docs/rules/indent) (fixes [#9056](https://github.com/eslint/eslint/issues/9056)) ([#9057](https://github.com/eslint/eslint/issues/9057)) (Jeff)
* [d0f78ec](https://github.com/eslint/eslint/commit/d0f78ec) Docs: update rule deprecation policy (fixes [#8635](https://github.com/eslint/eslint/issues/8635)) ([#9033](https://github.com/eslint/eslint/issues/9033)) (Teddy Katz)
* [50e3cf3](https://github.com/eslint/eslint/commit/50e3cf3) Docs: Update [sort-keys](/docs/rules/sort-keys) doc to define natural ordering (fixes [#9043](https://github.com/eslint/eslint/issues/9043)) ([#9045](https://github.com/eslint/eslint/issues/9045)) (Karan Sharma)
* [66c1d43](https://github.com/eslint/eslint/commit/66c1d43) Docs: Create SUPPORT.md ([#9031](https://github.com/eslint/eslint/issues/9031)) (Teddy Katz)




## Dependency Upgrades


* [89196fd](https://github.com/eslint/eslint/commit/89196fd) Upgrade: Espree to 3.5.0 ([#9074](https://github.com/eslint/eslint/issues/9074)) (Gyandeep Singh)
* [ad32697](https://github.com/eslint/eslint/commit/ad32697) Upgrade: js-yaml to 3.9.1 (refs [#9011](https://github.com/eslint/eslint/issues/9011)) ([#9044](https://github.com/eslint/eslint/issues/9044)) (Teddy Katz)
* [9b6c552](https://github.com/eslint/eslint/commit/9b6c552) Upgrade: eslint-plugin-eslint-plugin@0.8.0 ([#9012](https://github.com/eslint/eslint/issues/9012)) (薛定谔的猫)






## Chores


* [de75f9b](https://github.com/eslint/eslint/commit/de75f9b) Chore: enable [object-curly-newline](/docs/rules/object-curly-newline) & [object-property-newline](/docs/rules/object-property-newline).(fixes [#9042](https://github.com/eslint/eslint/issues/9042)) ([#9068](https://github.com/eslint/eslint/issues/9068)) (薛定谔的猫)
* [7ecfe6a](https://github.com/eslint/eslint/commit/7ecfe6a) Chore: enable eslint-plugin/test-case-property-ordering ([#9040](https://github.com/eslint/eslint/issues/9040)) (薛定谔的猫)
* [3141872](https://github.com/eslint/eslint/commit/3141872) Chore: remove unnecessary eslint-disable comments in codebase ([#9032](https://github.com/eslint/eslint/issues/9032)) (Teddy Katz)
* [b3b95b8](https://github.com/eslint/eslint/commit/b3b95b8) Chore: enable additional rules on ESLint codebase ([#9013](https://github.com/eslint/eslint/issues/9013)) (Teddy Katz)
* [acbe86a](https://github.com/eslint/eslint/commit/acbe86a) Chore: disallow .substr and .substring in favor of .slice ([#9010](https://github.com/eslint/eslint/issues/9010)) (Teddy Katz)
* [d0536d6](https://github.com/eslint/eslint/commit/d0536d6) Chore: Optimizes adding Linter methods (fixes [#9000](https://github.com/eslint/eslint/issues/9000)) ([#9007](https://github.com/eslint/eslint/issues/9007)) (Sean C Denison)
* [0a0401f](https://github.com/eslint/eslint/commit/0a0401f) Chore: fix spelling error. ([#9003](https://github.com/eslint/eslint/issues/9003)) (薛定谔的猫)
* [c3ee46b](https://github.com/eslint/eslint/commit/c3ee46b) Chore: fix misleading comment in RuleTester ([#8995](https://github.com/eslint/eslint/issues/8995)) (Teddy Katz)
