---
layout: post
title: ESLint v4.3.0 released
teaser: "We just pushed ESLint v4.3.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - kaicataldo
categories:
  - Release Notes
---

## Enhancements


* [91dccdf](https://github.com/eslint/eslint/commit/91dccdf) Update: support more options in [prefer-destructuring](/docs/rules/prefer-destructuring) ([#8796](https://github.com/eslint/eslint/issues/8796)) (Victor Hom)
* [3bebcfd](https://github.com/eslint/eslint/commit/3bebcfd) Update: Support generator yields in no constant condition ([#8762](https://github.com/eslint/eslint/issues/8762)) (Victor Hom)
* [e639358](https://github.com/eslint/eslint/commit/e639358) Update: add question to confirm downgrade (fixes [#8870](https://github.com/eslint/eslint/issues/8870)) ([#8911](https://github.com/eslint/eslint/issues/8911)) (Toru Nagashima)
* [3c231fa](https://github.com/eslint/eslint/commit/3c231fa) Update: add enforceInMethodNames to [no-underscore-dangle](/docs/rules/no-underscore-dangle) (fixes [#7065](https://github.com/eslint/eslint/issues/7065)) ([#7234](https://github.com/eslint/eslint/issues/7234)) (Gabriele Petronella)
* [128591f](https://github.com/eslint/eslint/commit/128591f) Update: [prefer-numeric-literals](/docs/rules/prefer-numeric-literals) warns Number.parseInt (fixes [#8913](https://github.com/eslint/eslint/issues/8913)) ([#8929](https://github.com/eslint/eslint/issues/8929)) (Kevin Partington)
* [fb8005d](https://github.com/eslint/eslint/commit/fb8005d) Update: [no-restricted-globals](/docs/rules/no-restricted-globals) custom error messages (fixes [#8315](https://github.com/eslint/eslint/issues/8315)) ([#8932](https://github.com/eslint/eslint/issues/8932)) (Kevin Partington)
* [1ea3723](https://github.com/eslint/eslint/commit/1ea3723) Update: fix indentation of parenthesized MemberExpressions (fixes [#8924](https://github.com/eslint/eslint/issues/8924)) ([#8928](https://github.com/eslint/eslint/issues/8928)) (Teddy Katz)
* [9abc6f7](https://github.com/eslint/eslint/commit/9abc6f7) Update: fix BinaryExpression indentation edge case (fixes [#8914](https://github.com/eslint/eslint/issues/8914)) ([#8930](https://github.com/eslint/eslint/issues/8930)) (Teddy Katz)




## Bug Fixes


* [96df8c9](https://github.com/eslint/eslint/commit/96df8c9) Fix: Handle fixing objects containing comments (fixes [#8484](https://github.com/eslint/eslint/issues/8484)) ([#8944](https://github.com/eslint/eslint/issues/8944)) (Brian Schemp)
* [a5fd101](https://github.com/eslint/eslint/commit/a5fd101) Fix: duplicated error message if a crash occurs (fixes [#8964](https://github.com/eslint/eslint/issues/8964)) ([#8965](https://github.com/eslint/eslint/issues/8965)) (Teddy Katz)
* [55bc35d](https://github.com/eslint/eslint/commit/55bc35d) Fix: Avoid shell mangling during eslint --init ([#8936](https://github.com/eslint/eslint/issues/8936)) (Anders Kaseorg)
* [597c217](https://github.com/eslint/eslint/commit/597c217) Fix: confusing error if plugins from config is not an array ([#8888](https://github.com/eslint/eslint/issues/8888)) (Calvin Freitas)




## Documentation


* [e39d41d](https://github.com/eslint/eslint/commit/e39d41d) Docs: Make `peerDependencies` package.json snippet valid JSON ([#8971](https://github.com/eslint/eslint/issues/8971)) (Sam Adams)
* [f8d122c](https://github.com/eslint/eslint/commit/f8d122c) Docs: trailing commas not allowed in json ([#8969](https://github.com/eslint/eslint/issues/8969)) (Scott Fletcher)
* [601039d](https://github.com/eslint/eslint/commit/601039d) Docs: fix badge in eslint-config-eslint readme ([#8954](https://github.com/eslint/eslint/issues/8954)) (Teddy Katz)
* [846f8b1](https://github.com/eslint/eslint/commit/846f8b1) Docs: Clarified that core PRs require issue in maintainer guide ([#8927](https://github.com/eslint/eslint/issues/8927)) (Kevin Partington)
* [0e90453](https://github.com/eslint/eslint/commit/0e90453) Docs: Fixing broken cyclomatic [complexity](/docs/rules/complexity) link (fixes [#8396](https://github.com/eslint/eslint/issues/8396)) ([#8937](https://github.com/eslint/eslint/issues/8937)) (Chris Bargren)
* [3c1dd6d](https://github.com/eslint/eslint/commit/3c1dd6d) Docs: add description of [no-sync](/docs/rules/no-sync) `allowAtRootLevel` option (fixes [#8902](https://github.com/eslint/eslint/issues/8902)) ([#8906](https://github.com/eslint/eslint/issues/8906)) (Teddy Katz)
* [45f8cd9](https://github.com/eslint/eslint/commit/45f8cd9) Docs: fix verifyAndFix result property name ([#8903](https://github.com/eslint/eslint/issues/8903)) (Tino Vyatkin)
* [1a89e1c](https://github.com/eslint/eslint/commit/1a89e1c) Docs: Fix always-multiline example in [multiline-ternary](/docs/rules/multiline-ternary) docs ([#8904](https://github.com/eslint/eslint/issues/8904)) (Nathan Woltman)








## Chores


* [d09288a](https://github.com/eslint/eslint/commit/d09288a) Chore: Use `output: null` to assert that a test case is not autofixed. ([#8960](https://github.com/eslint/eslint/issues/8960)) (薛定谔的猫)
* [10c3d78](https://github.com/eslint/eslint/commit/10c3d78) Chore: fix misleading [`indent`](/docs/rules/indent) test ([#8925](https://github.com/eslint/eslint/issues/8925)) (Teddy Katz)
* [a747b6f](https://github.com/eslint/eslint/commit/a747b6f) Chore: make minor improvements to [`indent`](/docs/rules/indent) internals ([#8947](https://github.com/eslint/eslint/issues/8947)) (Teddy Katz)
* [a8a8350](https://github.com/eslint/eslint/commit/a8a8350) Chore: improve performance of [`indent`](/docs/rules/indent) rule ([#8905](https://github.com/eslint/eslint/issues/8905)) (Teddy Katz)
* [764b2a9](https://github.com/eslint/eslint/commit/764b2a9) Chore: update header info in [`indent`](/docs/rules/indent) ([#8926](https://github.com/eslint/eslint/issues/8926)) (Teddy Katz)
* [933a9cf](https://github.com/eslint/eslint/commit/933a9cf) Chore: add a fuzzer to detect bugs in core rules ([#8422](https://github.com/eslint/eslint/issues/8422)) (Teddy Katz)
