---
layout: post
title: ESLint v4.2.0 released
teaser: "We just pushed ESLint v4.2.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - not-an-aardvark
categories:
  - Release Notes
---

## Highlights

* `linter.verifyAndFix` can now accept a filter function for fixes

    When using the Node.js API to autofix code, it's sometimes undesirable to autofix every problem at once. For example, a user might want to avoid fixing problems reported by particular rule, or a tool might want to only fix one problem at a time. You can now pass an object like `{ fix: message => /* ... */ }` to the third argument of `linter.verifyAndFix`, or to the `CLIEngine` constructor. If the `fix` function returns `true`, a fix is applied -- otherwise, a fix is not applied. [`eslint-nibble`](https://github.com/IanVS/eslint-nibble) uses this feature to autofix individual rules, or only autofix errors rather than warnings.

    Also see: [documentation](/docs/developer-guide/nodejs-api#cliengine)

* The [`getter-return`](/docs/rules/getter-return) rule has been added.
* The [`no-sync`](/docs/rules/no-sync) rule now has a boolean `allowAtRootLevel` option to allow sync function calls at the top level of a file.
* The [`multiline-ternary`](/docs/rules/multiline-ternary) rule now has an `always-multiline` option.

## Features


* [c693be5](https://github.com/eslint/eslint/commit/c693be5) New: Allow passing a function as `fix` option (fixes [#8039](https://github.com/eslint/eslint/issues/8039)) ([#8730](https://github.com/eslint/eslint/issues/8730)) (Ian VanSchooten)
* [8698a92](https://github.com/eslint/eslint/commit/8698a92) New: [getter-return](/docs/rules/getter-return) rule (fixes [#8449](https://github.com/eslint/eslint/issues/8449)) ([#8460](https://github.com/eslint/eslint/issues/8460)) (薛定谔的猫)




## Enhancements


* [e0f0101](https://github.com/eslint/eslint/commit/e0f0101) Update: fix indentation of nested function parameters (fixes [#8892](https://github.com/eslint/eslint/issues/8892)) ([#8900](https://github.com/eslint/eslint/issues/8900)) (Teddy Katz)
* [975dacf](https://github.com/eslint/eslint/commit/975dacf) Update: fix indentation of EmptyStatements (fixes [#8882](https://github.com/eslint/eslint/issues/8882)) ([#8885](https://github.com/eslint/eslint/issues/8885)) (Teddy Katz)
* [3767cda](https://github.com/eslint/eslint/commit/3767cda) Update: add [no-sync](/docs/rules/no-sync) option to allow at root level (fixes [#7985](https://github.com/eslint/eslint/issues/7985)) ([#8859](https://github.com/eslint/eslint/issues/8859)) (Victor Hom)
* [1f5bfc2](https://github.com/eslint/eslint/commit/1f5bfc2) Update: Add always-multiline option to [multiline-ternary](/docs/rules/multiline-ternary) (fixes [#8770](https://github.com/eslint/eslint/issues/8770)) ([#8841](https://github.com/eslint/eslint/issues/8841)) (Nathan Woltman)
* [676af9e](https://github.com/eslint/eslint/commit/676af9e) Update: fix indentation of JSXExpressionContainer contents (fixes [#8832](https://github.com/eslint/eslint/issues/8832)) ([#8850](https://github.com/eslint/eslint/issues/8850)) (Teddy Katz)
* [85c9327](https://github.com/eslint/eslint/commit/85c9327) Update: fix parenthesized CallExpression indentation (fixes [#8790](https://github.com/eslint/eslint/issues/8790)) ([#8802](https://github.com/eslint/eslint/issues/8802)) (Teddy Katz)
* [be8d354](https://github.com/eslint/eslint/commit/be8d354) Update: simplify variable declarator [indent](/docs/rules/indent) handling (fixes [#8785](https://github.com/eslint/eslint/issues/8785)) ([#8801](https://github.com/eslint/eslint/issues/8801)) (Teddy Katz)




## Bug Fixes


* [11ffe6b](https://github.com/eslint/eslint/commit/11ffe6b) Fix: [no-regex-spaces](/docs/rules/no-regex-spaces) rule incorrectly fixes quantified spaces ([#8773](https://github.com/eslint/eslint/issues/8773)) (Keri Warr)
* [931a9f1](https://github.com/eslint/eslint/commit/931a9f1) Fix: [indent](/docs/rules/indent) false positive with multi-line await expression ([#8837](https://github.com/eslint/eslint/issues/8837)) (薛定谔的猫)
* [f00854e](https://github.com/eslint/eslint/commit/f00854e) Fix: --quiet no longer fixes warnings (fixes [#8675](https://github.com/eslint/eslint/issues/8675)) ([#8858](https://github.com/eslint/eslint/issues/8858)) (Kevin Partington)
* [22116f2](https://github.com/eslint/eslint/commit/22116f2) Fix: correct [comma-dangle](/docs/rules/comma-dangle) JSON schema ([#8864](https://github.com/eslint/eslint/issues/8864)) (Evgeny Poberezkin)
* [5c3ac8e](https://github.com/eslint/eslint/commit/5c3ac8e) Fix: [arrow-parens](/docs/rules/arrow-parens) fixer gets tripped up with trailing comma in args ([#8838](https://github.com/eslint/eslint/issues/8838)) (薛定谔的猫)
* [9417818](https://github.com/eslint/eslint/commit/9417818) Fix: [no-debugger](/docs/rules/no-debugger) autofixer produced invalid syntax ([#8806](https://github.com/eslint/eslint/issues/8806)) (Teddy Katz)
* [eac06f2](https://github.com/eslint/eslint/commit/eac06f2) Fix: [no-extra-parens](/docs/rules/no-extra-parens) false positives for variables called "let" ([#8808](https://github.com/eslint/eslint/issues/8808)) (Teddy Katz)
* [616587f](https://github.com/eslint/eslint/commit/616587f) Fix: [dot-notation](/docs/rules/dot-notation) autofix produces syntax errors for object called "let" ([#8807](https://github.com/eslint/eslint/issues/8807)) (Teddy Katz)
* [a53ef7e](https://github.com/eslint/eslint/commit/a53ef7e) Fix: don't require a third argument in linter.verifyAndFix (fixes [#8805](https://github.com/eslint/eslint/issues/8805)) ([#8809](https://github.com/eslint/eslint/issues/8809)) (Teddy Katz)




## Documentation


* [7c8de92](https://github.com/eslint/eslint/commit/7c8de92) Docs: Clarified PR guidelines in maintainer guide ([#8876](https://github.com/eslint/eslint/issues/8876)) (Kevin Partington)
* [d1fc408](https://github.com/eslint/eslint/commit/d1fc408) Docs: Update CLA link in Contributing docs ([#8883](https://github.com/eslint/eslint/issues/8883)) (Calvin Freitas)
* [1ce553d](https://github.com/eslint/eslint/commit/1ce553d) Docs: Fix wording of minProperties in [object-curly-newline](/docs/rules/object-curly-newline) (fixes [#8874](https://github.com/eslint/eslint/issues/8874)) ([#8878](https://github.com/eslint/eslint/issues/8878)) (solmsted)
* [8796d55](https://github.com/eslint/eslint/commit/8796d55) Docs: add missing item to 4.0 migration guide table of contents ([#8835](https://github.com/eslint/eslint/issues/8835)) (薛定谔的猫)
* [ce969f9](https://github.com/eslint/eslint/commit/ce969f9) Docs: add guidelines for patch release communication (fixes [#7277](https://github.com/eslint/eslint/issues/7277)) ([#8823](https://github.com/eslint/eslint/issues/8823)) (Teddy Katz)
* [5c83c99](https://github.com/eslint/eslint/commit/5c83c99) Docs: Clarify arrow function parens in [no-extra-parens](/docs/rules/no-extra-parens) (fixes [#8741](https://github.com/eslint/eslint/issues/8741)) ([#8822](https://github.com/eslint/eslint/issues/8822)) (Kevin Partington)
* [84d921d](https://github.com/eslint/eslint/commit/84d921d) Docs: Added note about Node/CJS scoping to [no-redeclare](/docs/rules/no-redeclare) (fixes [#8814](https://github.com/eslint/eslint/issues/8814)) ([#8820](https://github.com/eslint/eslint/issues/8820)) (Kevin Partington)
* [5ad8b70](https://github.com/eslint/eslint/commit/5ad8b70) Docs: add minor formatting improvement to paragraph about parsers ([#8816](https://github.com/eslint/eslint/issues/8816)) (Teddy Katz)






## Build Related


* [88ed041](https://github.com/eslint/eslint/commit/88ed041) Build: Turnoff CI branch build (fixes [#8804](https://github.com/eslint/eslint/issues/8804)) ([#8873](https://github.com/eslint/eslint/issues/8873)) (Gyandeep Singh)
* [c4f2e29](https://github.com/eslint/eslint/commit/c4f2e29) Build: fix race condition in demo ([#8827](https://github.com/eslint/eslint/issues/8827)) (Teddy Katz)




## Chores


* [9f95a3e](https://github.com/eslint/eslint/commit/9f95a3e) Chore: remove unused helper method from [`indent`](/docs/rules/indent) ([#8901](https://github.com/eslint/eslint/issues/8901)) (Teddy Katz)
* [72f22eb](https://github.com/eslint/eslint/commit/72f22eb) Chore: replace is-my-json-valid with Ajv ([#8852](https://github.com/eslint/eslint/issues/8852)) (Gajus Kuizinas)
* [b678535](https://github.com/eslint/eslint/commit/b678535) Chore: Add collapsible block for config in ISSUE_TEMPLATE ([#8872](https://github.com/eslint/eslint/issues/8872)) (Gyandeep Singh)
* [330dd58](https://github.com/eslint/eslint/commit/330dd58) Chore: fix title of linter test suite ([#8861](https://github.com/eslint/eslint/issues/8861)) (Teddy Katz)
* [60099ed](https://github.com/eslint/eslint/commit/60099ed) Chore: enable [for-direction](/docs/rules/for-direction) rule on ESLint codebase ([#8853](https://github.com/eslint/eslint/issues/8853)) (薛定谔的猫)
* [e0d1a84](https://github.com/eslint/eslint/commit/e0d1a84) Chore: upgrade eslint-plugin-eslint-plugin & eslint-plugin-node ([#8856](https://github.com/eslint/eslint/issues/8856)) (薛定谔的猫)
* [0780d86](https://github.com/eslint/eslint/commit/0780d86) Chore: remove identical tests ([#8851](https://github.com/eslint/eslint/issues/8851)) (Teddy Katz)
