---
layout: post
title: ESLint v4.1.0 released
teaser: "We just pushed ESLint v4.1.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - not-an-aardvark
categories:
  - Release Notes
---

## Highlights

### Glob-based configuration

Previously, it was not possible to use different ESLint configurations for two different files in the same directory. For example, projects that place test files in the same directory as the corresponding source files were unable to use different ESLint configurations for the test files. Adding support for this has been one of our most requested features.

This release adds support for glob-based configuration via an `overrides` key in a config file, which can be used to apply a configuration to specific globs. For example, you can now enable the `mocha` environment on only test files, with the following config:

```js
module.exports = {
  rules: {
    // ... the rest of your config (applied to all files)
  },
  overrides: [
    {
      files: ["foo/**/*.spec.js", "bar/**/*.spec.js"],

      // Override config (only applied to files that match the given globs)
      env: { mocha: true }
    }
  ]
};
```

For full details, see the [documentation](/docs/user-guide/configuring#configuration-based-on-glob-patterns).

### Ignoring files from `package.json`

It's common for users to use an `.eslintignore` file to indicate the files that they would like ESLint to ignore. However, if you don't want to add additional files to your project root, you can now ignore files by setting the `eslintIgnore` property in a `package.json` file to a list of globs:

```json
{
  "eslintIgnore": [
    "build/**/*.js",
    "dist/**/*.js"
  ]
}
```

Also see: [documentation](/docs/user-guide/configuring#ignoring-files-and-directories)

### Applying multiple autofixes simultaneously

When writing a custom rule that can automatically fix problems, one sometimes needs to apply multiple fixes atomically. For example, if an autofix adds parentheses around a piece of source code, adding only one parenthesis will result in a syntax error. Since ESLint does not guarantee that it will be able to apply every fix without conflicts, it was previously not possible to atomically apply multiple fixes (without using confusing workarounds).

Starting in 4.1.0, if you return an array of fixes from a `fix` function rather than a single fix, all the fixes in the array will be applied atomically.

```js
context.report({
  node,
  message,
  fix(fixer) {
    return [
      fixer.insertTextBefore(node, "("),
      fixer.insertTextAfter(node, ")")
    ]
  }
})
```

Also see: [Autofixing docs](/docs/developer-guide/working-with-rules#applying-fixes)

### Applying autofixes from `Linter`

When using ESLint's Node.js API, it was previously not possible to get automatic fix information for a given source code and configuration when using `eslint.Linter`. Instead, one had to use `eslint.CLIEngine`, which is more general and less easy to use.

Starting in 4.1.0, you can now use `Linter#verifyAndFix` to get autofixing information when using `Linter`. (You should still use `CLIEngine` if you need to do more general operations, such as reading config files from the filesystem.)

For more details, see the [documentation](/docs/developer-guide/nodejs-api#verifyandfix).

### Other highlights

* An `enforceForArrowConditionals` option has been added to the [`no-extra-parens`](/docs/rules/no-extra-parens) rule.
* An `ignoreComments` option has been added to the [`no-trailing-spaces`](/docs/rules/no-trailing-spaces) rule.

---

# Full Changelog

## Features


* [a21dd32c](https://github.com/eslint/eslint/commit/a21dd32c) New: Add `overrides`/`files` options for glob-based config (fixes [#3611](https://github.com/eslint/eslint/issues/3611)) ([#8081](https://github.com/eslint/eslint/issues/8081)) (Sylvan Mably)
* [5f81a68a](https://github.com/eslint/eslint/commit/5f81a68a) New: Add eslintIgnore support to package.json (fixes [#8458](https://github.com/eslint/eslint/issues/8458)) ([#8690](https://github.com/eslint/eslint/issues/8690)) (Victor Hom)




## Enhancements


* [291a7830](https://github.com/eslint/eslint/commit/291a7830) Update: `enforceForArrowConditionals` to [`no-extra-parens`](/docs/rules/no-extra-parens) (fixes [#6196](https://github.com/eslint/eslint/issues/6196)) ([#8439](https://github.com/eslint/eslint/issues/8439)) (Evilebot Tnawi)
* [879688ce](https://github.com/eslint/eslint/commit/879688ce) Update: Add ignoreComments option to [no-trailing-spaces](/docs/rules/no-trailing-spaces) ([#8061](https://github.com/eslint/eslint/issues/8061)) (Jake Roussel)
* [98512881](https://github.com/eslint/eslint/commit/98512881) Update: fix [indent](/docs/rules/indent) errors on multiline destructure (fixes [#8729](https://github.com/eslint/eslint/issues/8729)) ([#8756](https://github.com/eslint/eslint/issues/8756)) (Victor Hom)
* [673a58bc](https://github.com/eslint/eslint/commit/673a58bc) Update: support multiple fixes in a report (fixes [#7348](https://github.com/eslint/eslint/issues/7348)) ([#8101](https://github.com/eslint/eslint/issues/8101)) (Toru Nagashima)
* [b5a70b4e](https://github.com/eslint/eslint/commit/b5a70b4e) Update: fix multiline binary operator/parentheses indentation ([#8719](https://github.com/eslint/eslint/issues/8719)) (Teddy Katz)
* [ab8b0167](https://github.com/eslint/eslint/commit/ab8b0167) Update: fix MemberExpression indentation with "off" option (fixes [#8721](https://github.com/eslint/eslint/issues/8721)) ([#8724](https://github.com/eslint/eslint/issues/8724)) (Teddy Katz)
* [eb5d12c1](https://github.com/eslint/eslint/commit/eb5d12c1) Update: Add Fixer method to Linter API ([#8631](https://github.com/eslint/eslint/issues/8631)) (Gyandeep Singh)




## Bug Fixes


* [7a1bc389](https://github.com/eslint/eslint/commit/7a1bc389) Fix: don't pass default parserOptions to custom parsers (fixes [#8744](https://github.com/eslint/eslint/issues/8744)) ([#8745](https://github.com/eslint/eslint/issues/8745)) (Teddy Katz)
* [b7cc1e6f](https://github.com/eslint/eslint/commit/b7cc1e6f) Fix: Space-infix-ops should ignore type annotations in TypeScript ([#8341](https://github.com/eslint/eslint/issues/8341)) (Reyad Attiyat)
* [46e73eea](https://github.com/eslint/eslint/commit/46e73eea) Fix: eslint --init installs wrong dependencies of popular styles (fixes [#7338](https://github.com/eslint/eslint/issues/7338)) ([#8713](https://github.com/eslint/eslint/issues/8713)) (Toru Nagashima)




## Documentation


* [e8f1362a](https://github.com/eslint/eslint/commit/e8f1362a) Docs: Remove wrong descriptions in `padded-block` rule ([#8783](https://github.com/eslint/eslint/issues/8783)) (Plusb Preco)
* [3608f06c](https://github.com/eslint/eslint/commit/3608f06c) Docs: Increase visibility of code of conduct (fixes [#8758](https://github.com/eslint/eslint/issues/8758)) ([#8764](https://github.com/eslint/eslint/issues/8764)) (Kai Cataldo)
* [3419f644](https://github.com/eslint/eslint/commit/3419f644) Docs: describe how to use formatters on the formatter demo page ([#8754](https://github.com/eslint/eslint/issues/8754)) (Teddy Katz)








## Chores


* [b58ae2e6](https://github.com/eslint/eslint/commit/b58ae2e6) Chore: Only instantiate fileEntryCache when cache flage set (perf) ([#8763](https://github.com/eslint/eslint/issues/8763)) (Gyandeep Singh)
* [c5b40528](https://github.com/eslint/eslint/commit/c5b40528) Chore: enable [computed-property-spacing](/docs/rules/computed-property-spacing) on ESLint codebase ([#8760](https://github.com/eslint/eslint/issues/8760)) (Teddy Katz)
* [a3ff8f21](https://github.com/eslint/eslint/commit/a3ff8f21) Chore: combine tests in tests/lib/eslint.js and tests/lib/linter.js ([#8746](https://github.com/eslint/eslint/issues/8746)) (Teddy Katz)
* [a82361b6](https://github.com/eslint/eslint/commit/a82361b6) Chore: Prevent package-lock.json files from being created (fixes [#8742](https://github.com/eslint/eslint/issues/8742)) ([#8747](https://github.com/eslint/eslint/issues/8747)) (Teddy Katz)
* [26a2daab](https://github.com/eslint/eslint/commit/26a2daab) Chore: Cache fs reads in ignored-paths (fixes [#8363](https://github.com/eslint/eslint/issues/8363)) ([#8706](https://github.com/eslint/eslint/issues/8706)) (Victor Hom)
