---
layout: post
title: ESLint v4.0.0 released
teaser: "We just pushed ESLint v4.0.0, which is a major release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release. This release also has some breaking changes, so please read the following closely."
image: release-notes-major.png
tags:
  - release
  - minor
authors:
  - not-an-aardvark
categories:
  - Release Notes
---

## Highlights

* There are several breaking changes in 4.0.0. We've created a [migration guide](/docs/user-guide/migrating-to-4.0.0) to explain the breaking changes and describe how to upgrade.
* Seven new rules have been added:
  * [`array-element-newline`](/docs/rules/array-element-newline)
  * [`semi-style`](/docs/rules/semi-style)
  * [`padding-line-between-statements`](/docs/rules/padding-line-between-statements)
  * [`for-direction`](/docs/rules/for-direction)
  * [`switch-colon-spacing`](/docs/rules/switch-colon-spacing)
  * [`array-bracket-newline`](/docs/rules/array-bracket-newline)
  * [`no-buffer-constructor`](/docs/rules/no-buffer-constructor)
* Two rules are now autofixable with the `--fix` flag:
  * [`no-debugger`](/docs/rules/no-debugger)
  * [`no-confusing-arrow`](/docs/rules/no-confusing-arrow)
* Three rules have been deprecated in favor of the new [`padding-line-between-statements`](/docs/rules/padding-line-between-statements) rule:
  * [`lines-around-directive`](/docs/rules/lines-around-directive)
  * [`newline-after-var`](/docs/rules/newline-after-var)
  * [`newline-before-return`](/docs/rules/newline-before-return)
* Three new utility methods have been added to the [`SourceCode`](/docs/developer-guide/working-with-rules#contextgetsourcecode) API, and `SourceCode#getComments` has been deprecated.
* A new option has been added to the [`object-curly-newline`](/docs/rules/object-curly-newline) rule.

---

Changes since v4.0.0-rc.0:

## Enhancements


* [34c4020](https://github.com/eslint/eslint/commit/34c4020) Update: Add support for parens on left side for-loops (fixes: [#8393](https://github.com/eslint/eslint/issues/8393)) ([#8679](https://github.com/eslint/eslint/issues/8679)) (Victor Hom)




## Bug Fixes


* [3da7b5e](https://github.com/eslint/eslint/commit/3da7b5e) Fix: Semi-Style only check for comments when tokens exist (fixes [#8696](https://github.com/eslint/eslint/issues/8696)) ([#8697](https://github.com/eslint/eslint/issues/8697)) (Reyad Attiyat)
* [3cfe9ee](https://github.com/eslint/eslint/commit/3cfe9ee) Fix: Add space between async and param on fix (fixes [#8682](https://github.com/eslint/eslint/issues/8682)) ([#8693](https://github.com/eslint/eslint/issues/8693)) (Reyad Attiyat)




## Documentation


* [735cd09](https://github.com/eslint/eslint/commit/735cd09) Docs: Correct the comment in an example for [`no-mixed-requires`](/docs/rules/no-mixed-requires) ([#8686](https://github.com/eslint/eslint/issues/8686)) (Fangzhou Li)








## Chores


* [4aefb49](https://github.com/eslint/eslint/commit/4aefb49) Chore: avoid using deprecated rules on ESLint codebase ([#8708](https://github.com/eslint/eslint/issues/8708)) (Teddy Katz)
* [389feba](https://github.com/eslint/eslint/commit/389feba) Chore: upgrade deps. ([#8684](https://github.com/eslint/eslint/issues/8684)) (薛定谔的猫)
* [c702858](https://github.com/eslint/eslint/commit/c702858) Chore: enable [no-multiple-empty-lines](/docs/rules/no-multiple-empty-lines) on ESLint codebase ([#8694](https://github.com/eslint/eslint/issues/8694)) (Teddy Katz)
* [026f048](https://github.com/eslint/eslint/commit/026f048) Chore: remove dead code from [prefer-const](/docs/rules/prefer-const) ([#8683](https://github.com/eslint/eslint/issues/8683)) (Teddy Katz)
