---
layout: post
title: ESLint v4.0.0-rc.0 released
teaser: "We just pushed ESLint v4.0.0-rc.0, which is a major release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release. This release also has some breaking changes, so please read the following closely."
image: release-notes-beta.png
tags:
  - release
  - major
authors:
  - btmills
categories:
  - Release Notes
---

Note: This version of ESLint is not ready for production use and is provided to gather feedback from the community before releasing the final version. Please let us know if you having any problems or feedback by creating issues on our [GitHub repo](https://github.com/eslint/eslint) or joining our [Gitter channel](https://gitter.im/eslint/eslint).

## Highlights

* If you're upgrading from 3.x, see the [migration guide](/docs/4.0.0/user-guide/migrating-to-4.0.0).
* One new rule was added in this release:
  * [`array-element-newline`](/docs/4.0.0/rules/array-element-newline)
* One rule gained support for `--fix`:
  * [`no-debugger`](/docs/4.0.0/rules/no-debugger)


## Features

* [7ebd9d6f](https://github.com/eslint/eslint/commit/7ebd9d6f) New: [array-element-newline](/docs/4.0.0/rules/array-element-newline) rule (fixes [#6075](https://github.com/eslint/eslint/issues/6075)) ([#8375](https://github.com/eslint/eslint/issues/8375)) (Jan Peer Stöcklmair)



## Enhancements

* [0058b0f8](https://github.com/eslint/eslint/commit/0058b0f8) Update: add --fix to [no-debugger](/docs/rules/no-debugger) ([#8660](https://github.com/eslint/eslint/issues/8660)) (薛定谔的猫)
* [c4ac969c](https://github.com/eslint/eslint/commit/c4ac969c) Update: fix parenthesized ternary expression indentation (fixes [#8637](https://github.com/eslint/eslint/issues/8637)) ([#8649](https://github.com/eslint/eslint/issues/8649)) (Teddy Katz)



## Bug Fixes

* [95248336](https://github.com/eslint/eslint/commit/95248336) Fix: Don't check object destructing in integer property (fixes [#8654](https://github.com/eslint/eslint/issues/8654)) ([#8657](https://github.com/eslint/eslint/issues/8657)) (flowmemo)
* [d0e9fd2d](https://github.com/eslint/eslint/commit/d0e9fd2d) Fix: Config merge to correctly account for extends (fixes [#8193](https://github.com/eslint/eslint/issues/8193)) ([#8636](https://github.com/eslint/eslint/issues/8636)) (Gyandeep Singh)



## Documentation

* [b4daa225](https://github.com/eslint/eslint/commit/b4daa225) Docs: Note to --fix option for [strict](/docs/rules/strict) rule ([#8680](https://github.com/eslint/eslint/issues/8680)) (Vitaliy Potapov)
* [b0c83bd1](https://github.com/eslint/eslint/commit/b0c83bd1) Docs: suggest pushing new commits to a PR instead of amending ([#8632](https://github.com/eslint/eslint/issues/8632)) (Teddy Katz)
* [705d88f7](https://github.com/eslint/eslint/commit/705d88f7) Docs: Update CLA link on Pull Requests page ([#8642](https://github.com/eslint/eslint/issues/8642)) (Teddy Katz)
* [794d4d6c](https://github.com/eslint/eslint/commit/794d4d6c) Docs: missing paren on readme ([#8640](https://github.com/eslint/eslint/issues/8640)) (Dan Beam)
* [936bc174](https://github.com/eslint/eslint/commit/936bc174) Docs: Add missing documentation for scoped modules in sharable config developer-guide ([#8610](https://github.com/eslint/eslint/issues/8610)) (Jonathan Samines)



## Build Related

* [c9b980ce](https://github.com/eslint/eslint/commit/c9b980ce) Build: Add Node 8 on travis ([#8669](https://github.com/eslint/eslint/issues/8669)) (Gyandeep Singh)
* [4f2f9fcb](https://github.com/eslint/eslint/commit/4f2f9fcb) Build: update license checker to allow LGPL (fixes [#8647](https://github.com/eslint/eslint/issues/8647)) ([#8652](https://github.com/eslint/eslint/issues/8652)) (Teddy Katz)



## Chores

* [4df33e7c](https://github.com/eslint/eslint/commit/4df33e7c) Chore: check for root:true in project sooner (fixes [#8561](https://github.com/eslint/eslint/issues/8561)) ([#8638](https://github.com/eslint/eslint/issues/8638)) (Victor Hom)
* [f62cff66](https://github.com/eslint/eslint/commit/f62cff66) Chore: Remove dependency to user-home (fixes [#8604](https://github.com/eslint/eslint/issues/8604)) ([#8629](https://github.com/eslint/eslint/issues/8629)) (Pavol Madar)
