---
layout: post
title: ESLint v4.0.0-beta.0 released
teaser: "We just pushed ESLint v4.0.0-beta.0, which is a major release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release. This release also has some breaking changes, so please read the following closely."
image: release-notes-beta.png
tags:
  - release
  - major
authors:
  - not-an-aardvark
categories:
  - Release Notes
---

Note: This version of ESLint is not ready for production use and is provided to gather feedback from the community before releasing the final version. Please let us know if you having any problems or feedback by creating issues on our [GitHub repo](https://github.com/eslint/eslint) or joining our [Gitter channel](https://gitter.im/eslint/eslint).

## Highlights

* If you're upgrading from 3.x, see the [migration guide](/docs/4.0.0/user-guide/migrating-to-4.0.0).
* Four new rules have been added in this release:
  * [`semi-style`](/docs/4.0.0/rules/semi-style)
  * [`padding-line-between-statements`](/docs/4.0.0/rules/padding-line-between-statements)
  * [`for-direction`](/docs/4.0.0/rules/for-direction)
  * [`switch-colon-spacing`](/docs/4.0.0/rules/switch-colon-spacing)
* Previously, ESLint's Node.js API exposed a mutable `eslint.linter` object which could be used to lint text. This could cause problems if two unrelated modules were using `eslint.linter` at the same time, because they might both mutate it and interfere with each other. To resolve this, ESLint now exposes an `eslint.Linter` constructor, which can be used to create mutable `linter` instances. We recommend that integrations switch to using `eslint.Linter` rather than `eslint.linter`.
* Three rules have been deprecated in favor of the new [`padding-line-between-statements`](/docs/4.0.0/rules/padding-line-between-statements) rule:
  * [`lines-around-directive`](/docs/4.0.0/rules/lines-around-directive)
  * [`newline-after-var`](/docs/4.0.0/rules/newline-after-var)
  * [`newline-before-return`](/docs/4.0.0/rules/newline-before-return)

## Breaking Changes


* [3ec436ee](https://github.com/eslint/eslint/commit/3ec436ee) Breaking: New Linter API (fixes [#8454](https://github.com/eslint/eslint/issues/8454)) ([#8465](https://github.com/eslint/eslint/issues/8465)) (Gyandeep Singh)




## Features


* [2f7015b6](https://github.com/eslint/eslint/commit/2f7015b6) New: [semi-style](/docs/4.0.0/rules/semi-style) rule (fixes [#8169](https://github.com/eslint/eslint/issues/8169)) ([#8542](https://github.com/eslint/eslint/issues/8542)) (Toru Nagashima)
* [a93a2f95](https://github.com/eslint/eslint/commit/a93a2f95) New: [padding-line-between-statements](/docs/4.0.0/rules/padding-line-between-statements) rule (fixes [#7356](https://github.com/eslint/eslint/issues/7356)) ([#8099](https://github.com/eslint/eslint/issues/8099)) (Toru Nagashima)
* [0ef09ea0](https://github.com/eslint/eslint/commit/0ef09ea0) New: [for-direction](/docs/4.0.0/rules/for-direction) rule (fixes [#8387](https://github.com/eslint/eslint/issues/8387)) ([#8519](https://github.com/eslint/eslint/issues/8519)) (薛定谔的猫)
* [482d5720](https://github.com/eslint/eslint/commit/482d5720) New: [switch-colon-spacing](/docs/4.0.0/rules/switch-colon-spacing) rule (fixes [#7981](https://github.com/eslint/eslint/issues/7981)) ([#8540](https://github.com/eslint/eslint/issues/8540)) (Toru Nagashima)




## Enhancements


* [3418479a](https://github.com/eslint/eslint/commit/3418479a) Update: improve [indent](/docs/rules/indent) of `flatTernaryExpressions` (fixes [#8481](https://github.com/eslint/eslint/issues/8481)) ([#8587](https://github.com/eslint/eslint/issues/8587)) (Toru Nagashima)
* [268d52ef](https://github.com/eslint/eslint/commit/268d52ef) Update: Use sane defaults for JSX indentation (fixes [#8425](https://github.com/eslint/eslint/issues/8425)) ([#8593](https://github.com/eslint/eslint/issues/8593)) (Teddy Katz)
* [afa35c68](https://github.com/eslint/eslint/commit/afa35c68) Update: check allman-style classes correctly in [indent](/docs/rules/indent) (fixes [#8493](https://github.com/eslint/eslint/issues/8493)) ([#8569](https://github.com/eslint/eslint/issues/8569)) (Teddy Katz)
* [456f519b](https://github.com/eslint/eslint/commit/456f519b) Update: make [indent](/docs/rules/indent) MemberExpression handling more robust (fixes [#8552](https://github.com/eslint/eslint/issues/8552)) ([#8554](https://github.com/eslint/eslint/issues/8554)) (Teddy Katz)




## Bug Fixes


* [eb14584a](https://github.com/eslint/eslint/commit/eb14584a) Fix: [no-unneeded-ternary](/docs/rules/no-unneeded-ternary) change code behavior after fix (fixes [#8507](https://github.com/eslint/eslint/issues/8507)) ([#8624](https://github.com/eslint/eslint/issues/8624)) (Jan Peer Stöcklmair)
* [3fc9653a](https://github.com/eslint/eslint/commit/3fc9653a) Fix: Call expression consistency in variable declaration (fixes [#8607](https://github.com/eslint/eslint/issues/8607)) ([#8619](https://github.com/eslint/eslint/issues/8619)) (Reyad Attiyat)
* [a73e6c09](https://github.com/eslint/eslint/commit/a73e6c09) Fix: Fix failing uknown node test since [#8569](https://github.com/eslint/eslint/issues/8569) indents class bodies ([#8588](https://github.com/eslint/eslint/issues/8588)) (Reyad Attiyat)
* [c6c639d6](https://github.com/eslint/eslint/commit/c6c639d6) Fix: Ignore unknown nodes for Indent rule (fixes [#8440](https://github.com/eslint/eslint/issues/8440)) ([#8504](https://github.com/eslint/eslint/issues/8504)) (Reyad Attiyat)
* [df17bc87](https://github.com/eslint/eslint/commit/df17bc87) Fix: [object-shorthand](/docs/rules/object-shorthand) crash on some computed keys (fixes [#8576](https://github.com/eslint/eslint/issues/8576)) ([#8577](https://github.com/eslint/eslint/issues/8577)) (Teddy Katz)
* [de0b4ad7](https://github.com/eslint/eslint/commit/de0b4ad7) Fix: Indent Ignore Variable Declaration init operator (fixes [#8546](https://github.com/eslint/eslint/issues/8546)) ([#8563](https://github.com/eslint/eslint/issues/8563)) (Reyad Attiyat)
* [927ca0dc](https://github.com/eslint/eslint/commit/927ca0dc) Fix: invalid syntax from [prefer-arrow-callback](/docs/rules/prefer-arrow-callback) autofixer (fixes [#8541](https://github.com/eslint/eslint/issues/8541)) ([#8555](https://github.com/eslint/eslint/issues/8555)) (Teddy Katz)
* [873310e5](https://github.com/eslint/eslint/commit/873310e5) Fix: run [no-unexpected-multiline](/docs/rules/no-unexpected-multiline) only if needed (fixes [#8550](https://github.com/eslint/eslint/issues/8550)) ([#8551](https://github.com/eslint/eslint/issues/8551)) (Ruben Bridgewater)
* [833a0cad](https://github.com/eslint/eslint/commit/833a0cad) Fix: confusing RuleTester error message when options is not an array ([#8557](https://github.com/eslint/eslint/issues/8557)) (Teddy Katz)




## Documentation


* [5b6093ef](https://github.com/eslint/eslint/commit/5b6093ef) Docs: Remove .eslintignore reference to transpiled file filtering ([#8622](https://github.com/eslint/eslint/issues/8622)) (Alex Summer)
* [11493781](https://github.com/eslint/eslint/commit/11493781) Docs: Rephrase in about section ([#8609](https://github.com/eslint/eslint/issues/8609)) (Sudarsan G P)








## Chores


* [729bbcdb](https://github.com/eslint/eslint/commit/729bbcdb) Chore: Fix lgtm alerts. ([#8611](https://github.com/eslint/eslint/issues/8611)) (Max Schaefer)
* [d21f5283](https://github.com/eslint/eslint/commit/d21f5283) Chore: make shelljs a devDependency instead of a dependency ([#8608](https://github.com/eslint/eslint/issues/8608)) (Teddy Katz)
* [23401626](https://github.com/eslint/eslint/commit/23401626) Chore: remove strip-bom dependency (refs [#8603](https://github.com/eslint/eslint/issues/8603)) ([#8606](https://github.com/eslint/eslint/issues/8606)) (Teddy Katz)
* [25db3d22](https://github.com/eslint/eslint/commit/25db3d22) Chore: avoid skipping test for env overrides (refs [#8291](https://github.com/eslint/eslint/issues/8291)) ([#8556](https://github.com/eslint/eslint/issues/8556)) (Teddy Katz)
