---
layout: post
title: ESLint v4.0.0-alpha.2 released
teaser: "We just pushed ESLint v4.0.0-alpha.2, which is a major release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release. This release also has some breaking changes, so please read the following closely."
image: release-notes-beta.png
tags:
  - release
  - major
authors:
  - ilyavolodin
categories:
  - Release Notes
---

Note: This version of ESLint is not ready for production use and is provided to gather feedback from the community before releasing the final version. Please let us know if you having any problems or feedback by creating issues on our [GitHub repo](https://github.com/eslint/eslint) or joining our [Gitter channel](https://gitter.im/eslint/eslint).


## Highlights

* ESLint will now validate .eslintrc.* files for unknown properties

## Breaking Changes


* [734846b](https://github.com/eslint/eslint/commit/734846b) Breaking: validate eslintrc properties (fixes [#8213](https://github.com/eslint/eslint/issues/8213)) ([#8295](https://github.com/eslint/eslint/issues/8295)) (alberto)






## Enhancements


* [74ab344](https://github.com/eslint/eslint/commit/74ab344) Update: check allman-style blocks correctly in [indent](/docs/rules/indent) rule (fixes [#8493](https://github.com/eslint/eslint/issues/8493)) ([#8499](https://github.com/eslint/eslint/issues/8499)) (Teddy Katz)
* [f6256d4](https://github.com/eslint/eslint/commit/f6256d4) Update: [no-extend-native](/docs/rules/no-extend-native) checks global scope refs only (fixes [#8461](https://github.com/eslint/eslint/issues/8461)) ([#8528](https://github.com/eslint/eslint/issues/8528)) (Kevin Partington)
* [99c56d5](https://github.com/eslint/eslint/commit/99c56d5) Update: handle multiline parents consistently in [indent](/docs/rules/indent) (fixes [#8455](https://github.com/eslint/eslint/issues/8455)) ([#8498](https://github.com/eslint/eslint/issues/8498)) (Teddy Katz)
* [cf940c6](https://github.com/eslint/eslint/commit/cf940c6) Update: [indent](/docs/rules/indent) `from` tokens in import statements (fixes [#8438](https://github.com/eslint/eslint/issues/8438)) ([#8466](https://github.com/eslint/eslint/issues/8466)) (Teddy Katz)
* [d49acc3](https://github.com/eslint/eslint/commit/d49acc3) Update: fix [no-self-compare](/docs/rules/no-self-compare) false negative on non-literals (fixes [#7677](https://github.com/eslint/eslint/issues/7677)) ([#8492](https://github.com/eslint/eslint/issues/8492)) (Teddy Katz)




## Bug Fixes


* [0a9a90f](https://github.com/eslint/eslint/commit/0a9a90f) Fix: [max-len](/docs/rules/max-len) doesn't allow comments longer than code ([#8532](https://github.com/eslint/eslint/issues/8532)) (Ken Gregory)
* [aaa1a81](https://github.com/eslint/eslint/commit/aaa1a81) Fix: avoid creating extra whitespace in [brace-style](/docs/rules/brace-style) fixer (fixes [#7621](https://github.com/eslint/eslint/issues/7621)) ([#8491](https://github.com/eslint/eslint/issues/8491)) (Teddy Katz)




## Documentation


* [b463045](https://github.com/eslint/eslint/commit/b463045) Docs: add typescript-eslint-parser ([#8388](https://github.com/eslint/eslint/issues/8388)) ([#8534](https://github.com/eslint/eslint/issues/8534)) (薛定谔的猫)
* [e52d998](https://github.com/eslint/eslint/commit/e52d998) Docs: Configuring Cascading and Hierarchy example correction ([#8512](https://github.com/eslint/eslint/issues/8512)) (Cheong Yip)
* [e135aa5](https://github.com/eslint/eslint/commit/e135aa5) Docs: Correct code of conduct link on Readme.md ([#8517](https://github.com/eslint/eslint/issues/8517)) (Zander Mackie)
* [9c3da77](https://github.com/eslint/eslint/commit/9c3da77) Docs: list another related rule in [no-undefined](/docs/rules/no-undefined) ([#8467](https://github.com/eslint/eslint/issues/8467)) (Ethan)
* [f987814](https://github.com/eslint/eslint/commit/f987814) Docs: Update CHANGELOG.md for v4.0.0-alpha.1 release ([#8488](https://github.com/eslint/eslint/issues/8488)) (Kai Cataldo)




## Dependency Upgrades


* [6a333ff](https://github.com/eslint/eslint/commit/6a333ff) Upgrade: espree@^3.4.2 ([#8526](https://github.com/eslint/eslint/issues/8526)) (Kevin Partington)






## Chores


* [025e97a](https://github.com/eslint/eslint/commit/025e97a) Chore: delete duplicated test. ([#8527](https://github.com/eslint/eslint/issues/8527)) (薛定谔的猫)
* [37e3ba1](https://github.com/eslint/eslint/commit/37e3ba1) Chore: Add license report and scan status ([#8503](https://github.com/eslint/eslint/issues/8503)) (Kevin Wang)
* [afbea78](https://github.com/eslint/eslint/commit/afbea78) Chore: don't pull default options from eslint:recommended (fixes [#8374](https://github.com/eslint/eslint/issues/8374)) ([#8381](https://github.com/eslint/eslint/issues/8381)) (Teddy Katz)
