---
layout: post
title: ESLint v4.0.0-alpha.1 released
teaser: "We just pushed ESLint v4.0.0-alpha.1, which is a major release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release. This release also has some breaking changes, so please read the following closely."
image: release-notes-beta.png
tags:
  - release
  - major
authors:
  - not-an-aardvark
categories:
  - Release Notes
---

Note: This version of ESLint is not ready for production use and is provided to gather feedback from the community before releasing the final version. Please let us know if you having any problems or feedback by creating issues on our [GitHub repo](https://github.com/eslint/eslint) or joining our [Gitter channel](https://gitter.im/eslint/eslint).

## Highlights

* The [`array-callback-return`](/docs/rules/array-callback-return) rule was added to `eslint:recommended` in the last prerelease, but it has been removed from `eslint:recommended` in this prerelease due to false positives that would occur when using methods in a few popular libraries. As a result, this rule will not be in `eslint:recommended` for 4.0.0.
* Three new utility methods have been added to the `SourceCode` API, and `SourceCode#getComments` has been deprecated.
* One new rule has been added: [`array-bracket-newline`](/docs/4.0.0/rules/array-bracket-newline).
* The [`no-confusing-arrow`](/docs/4.0.0/rules/no-confusing-arrow) rule can now be autofixed.
* The [`object-curly-newline`](/docs/4.0.0/rules/object-curly-newline) rule has a new option.

## Breaking Changes


* [fac53890](https://github.com/eslint/eslint/commit/fac53890) Breaking: Remove [array-callback-return](/docs/rules/array-callback-return) from recommended (fixes [#8428](https://github.com/eslint/eslint/issues/8428)) ([#8433](https://github.com/eslint/eslint/issues/8433)) (Kai Cataldo)




## Features


* [7bc6fe0a](https://github.com/eslint/eslint/commit/7bc6fe0a) New: [array-bracket-newline](/docs/rules/array-bracket-newline) rule ([#8314](https://github.com/eslint/eslint/issues/8314)) (Jan Peer Stöcklmair)




## Enhancements


* [b337738f](https://github.com/eslint/eslint/commit/b337738f) Update: Add `consistent` option to [`object-curly-newline`](/docs/rules/object-curly-newline) (fixes [#6488](https://github.com/eslint/eslint/issues/6488)) ([#7720](https://github.com/eslint/eslint/issues/7720)) (Evilebot Tnawi)
* [53fefb3b](https://github.com/eslint/eslint/commit/53fefb3b) Update: add fix for [no-confusing-arrow](/docs/rules/no-confusing-arrow) ([#8347](https://github.com/eslint/eslint/issues/8347)) (Mordy Tikotzky)
* [735d02d5](https://github.com/eslint/eslint/commit/735d02d5) Update: Deprecate sourceCode.getComments() (fixes [#8408](https://github.com/eslint/eslint/issues/8408)) ([#8434](https://github.com/eslint/eslint/issues/8434)) (Kai Cataldo)
* [ac39e3b0](https://github.com/eslint/eslint/commit/ac39e3b0) Update: [no-unexpected-multiline](/docs/rules/no-unexpected-multiline) to flag confusing division (fixes [#8469](https://github.com/eslint/eslint/issues/8469)) ([#8475](https://github.com/eslint/eslint/issues/8475)) (Teddy Katz)
* [9f540fd2](https://github.com/eslint/eslint/commit/9f540fd2) Update: [no-unused-vars](/docs/rules/no-unused-vars) false negative about destructuring (fixes [#8442](https://github.com/eslint/eslint/issues/8442)) ([#8459](https://github.com/eslint/eslint/issues/8459)) (Toru Nagashima)




## Bug Fixes


* [e35107f0](https://github.com/eslint/eslint/commit/e35107f0) Fix: [indent](/docs/rules/indent) crash on arrow functions without parens at start of line ([#8477](https://github.com/eslint/eslint/issues/8477)) (Teddy Katz)




## Documentation


* [b0dadfe3](https://github.com/eslint/eslint/commit/b0dadfe3) Docs: Update comments section of Migrating to v4.0.0 ([#8486](https://github.com/eslint/eslint/issues/8486)) (Kai Cataldo)
* [973adeb6](https://github.com/eslint/eslint/commit/973adeb6) Docs: State that functions option only applies in ES2017 (fixes [#7809](https://github.com/eslint/eslint/issues/7809)) ([#8468](https://github.com/eslint/eslint/issues/8468)) (Thenaesh Elango)
* [741ed393](https://github.com/eslint/eslint/commit/741ed393) Docs: Clarify how to run local ESLint installation ([#8463](https://github.com/eslint/eslint/issues/8463)) (Kai Cataldo)
* [48700fc8](https://github.com/eslint/eslint/commit/48700fc8) Docs: Remove extra header line from LICENSE ([#8448](https://github.com/eslint/eslint/issues/8448)) (Teddy Katz)
* [0c2a386e](https://github.com/eslint/eslint/commit/0c2a386e) Docs: clarify new [indent](/docs/rules/indent) behavior with MemberExpressions ([#8432](https://github.com/eslint/eslint/issues/8432)) (Teddy Katz)
* [446b8876](https://github.com/eslint/eslint/commit/446b8876) Docs: update [space-before-function-paren](/docs/rules/space-before-function-paren) docs for 4.0 (fixes [#8430](https://github.com/eslint/eslint/issues/8430)) ([#8431](https://github.com/eslint/eslint/issues/8431)) (Teddy Katz)




## Dependency Upgrades


* [288c96c1](https://github.com/eslint/eslint/commit/288c96c1) Upgrade: dependencies ([#8304](https://github.com/eslint/eslint/issues/8304)) (alberto)




## Build Related


* [1c7efbd2](https://github.com/eslint/eslint/commit/1c7efbd2) Build: changelog update for 4.0.0-alpha.1 (Kai Cataldo)




## Chores


* [10a1a2d7](https://github.com/eslint/eslint/commit/10a1a2d7) Chore: Do not use cache when testing ([#8464](https://github.com/eslint/eslint/issues/8464)) (Kai Cataldo)
* [161ee4ea](https://github.com/eslint/eslint/commit/161ee4ea) Chore: avoid cloning comments array in TokenStore ([#8436](https://github.com/eslint/eslint/issues/8436)) (Teddy Katz)
