---
layout: post
title: ESLint v4.0.0-alpha.0 released
teaser: "We just pushed ESLint v4.0.0-alpha.0, which is a major release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release. This release also has some breaking changes, so please read the following closely."
image: release-notes-beta.png
tags:
  - release
  - major
authors:
  - ilyavolodin
categories:
  - Release Notes
---

Note: This version of ESLint is not ready for production use and is provided to gather feedback from the community before releasing the final version. Please let us know if you having any problems or feedback by creating issues on our [GitHub repo](https://github.com/eslint/eslint) or joining our [Gitter channel](https://gitter.im/eslint/eslint).

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Installing

Since this is a pre-release version, you will not automatically be upgraded by npm. You must specify the `next` tag when installing:

```
npm i eslint@next --save-dev
```

You can also specify the version directly:

```
npm i eslint@4.0.0-alpha.0 --save-dev
```

### Migration Guide

As there are a lot of changes, we've created a [migration guide](/docs/4.0.0/user-guide/migrating-to-4.0.0) describing the changes in great detail along with the steps you should take to address them. Not all ESLint users will be affected by the changes, however, the changes are big enough that we recommend everyone read the migration thoroughly.

### New Rules

There is one new rule in this release:

* [`no-buffer-constructor`](/docs/4.0.0/rules/no-buffer-constructor)

## Breaking Changes


* [f5a7e42](https://github.com/eslint/eslint/commit/f5a7e42) Breaking: log number of fixable problems (fixes [#7364](https://github.com/eslint/eslint/issues/7364)) ([#8324](https://github.com/eslint/eslint/issues/8324)) (alberto)
* [cc53481](https://github.com/eslint/eslint/commit/cc53481) Breaking: rewrite [indent](/docs/4.0.0/rules/indent) (fixes [#1801](https://github.com/eslint/eslint/issues/1801), [#3737](https://github.com/eslint/eslint/issues/3737), [#3845](https://github.com/eslint/eslint/issues/3845), [#6007](https://github.com/eslint/eslint/issues/6007), ...16 more) ([#7618](https://github.com/eslint/eslint/issues/7618)) (Teddy Katz)
* [867dd2e](https://github.com/eslint/eslint/commit/867dd2e) Breaking: Calculate leading/trailing comments in core (fixes [#6724](https://github.com/eslint/eslint/issues/6724)) ([#7516](https://github.com/eslint/eslint/issues/7516)) (Kai Cataldo)
* [66af53e](https://github.com/eslint/eslint/commit/66af53e) Breaking: Traverse into type annotations (fixes [#7129](https://github.com/eslint/eslint/issues/7129)) ([#8365](https://github.com/eslint/eslint/issues/8365)) (Kai Cataldo)
* [e395919](https://github.com/eslint/eslint/commit/e395919) Breaking: Resolve patterns from .eslintignore directory (fixes [#6759](https://github.com/eslint/eslint/issues/6759)) ([#7678](https://github.com/eslint/eslint/issues/7678)) (Ian VanSchooten)
* [c778676](https://github.com/eslint/eslint/commit/c778676) Breaking: convert RuleTester to ES6 class (refs [#8231](https://github.com/eslint/eslint/issues/8231)) ([#8263](https://github.com/eslint/eslint/issues/8263)) (Teddy Katz)
* [6f7757e](https://github.com/eslint/eslint/commit/6f7757e) Breaking: convert SourceCode to ES6 class (refs [#8231](https://github.com/eslint/eslint/issues/8231)) ([#8264](https://github.com/eslint/eslint/issues/8264)) (Teddy Katz)
* [9a9d916](https://github.com/eslint/eslint/commit/9a9d916) Breaking: update eslint:recommended for 4.0.0 (fixes [#8236](https://github.com/eslint/eslint/issues/8236)) ([#8372](https://github.com/eslint/eslint/issues/8372)) (Teddy Katz)
* [b0c63f0](https://github.com/eslint/eslint/commit/b0c63f0) Breaking: infer endLine and endColumn from a reported node (fixes [#8004](https://github.com/eslint/eslint/issues/8004)) ([#8234](https://github.com/eslint/eslint/issues/8234)) (Teddy Katz)
* [40b8c69](https://github.com/eslint/eslint/commit/40b8c69) Breaking: [no-multi-spaces](/docs/4.0.0/rules/no-multi-spaces) check around inline comments (fixes [#7693](https://github.com/eslint/eslint/issues/7693)) ([#7696](https://github.com/eslint/eslint/issues/7696)) (Kai Cataldo)
* [034a575](https://github.com/eslint/eslint/commit/034a575) Breaking: convert CLIEngine to ES6 class (refs [#8231](https://github.com/eslint/eslint/issues/8231)) ([#8262](https://github.com/eslint/eslint/issues/8262)) (Teddy Katz)
* [7dd890d](https://github.com/eslint/eslint/commit/7dd890d) Breaking: tweak [space-before-function-paren](/docs/4.0.0/rules/space-before-function-paren) default option (fixes [#8267](https://github.com/eslint/eslint/issues/8267)) ([#8285](https://github.com/eslint/eslint/issues/8285)) (Teddy Katz)
* [0e0dd27](https://github.com/eslint/eslint/commit/0e0dd27) Breaking: Remove `ecmaFeatures` from `eslint:recommended` ([#8239](https://github.com/eslint/eslint/issues/8239)) (alberto)
* [2fa7502](https://github.com/eslint/eslint/commit/2fa7502) Breaking: disallow scoped plugin references without scope (fixes [#6362](https://github.com/eslint/eslint/issues/6362)) ([#8233](https://github.com/eslint/eslint/issues/8233)) (Teddy Katz)
* [e232464](https://github.com/eslint/eslint/commit/e232464) Breaking: change defaults for [padded-blocks](/docs/4.0.0/rules/padded-blocks) (fixes [#7879](https://github.com/eslint/eslint/issues/7879)) ([#8134](https://github.com/eslint/eslint/issues/8134)) (alberto)




## Features


* [86cf3e4](https://github.com/eslint/eslint/commit/86cf3e4) New: [no-buffer-constructor](/docs/4.0.0/rules/no-buffer-constructor) rule (fixes [#5614](https://github.com/eslint/eslint/issues/5614)) ([#8413](https://github.com/eslint/eslint/issues/8413)) (Teddy Katz)




## Enhancements


* [8394e48](https://github.com/eslint/eslint/commit/8394e48) Update: add deprecated [indent-legacy](/docs/4.0.0/rules/indent-legacy) rule as v3.x [indent](/docs/4.0.0/rules/indent) rule snapshot ([#8286](https://github.com/eslint/eslint/issues/8286)) (Teddy Katz)
* [f560c06](https://github.com/eslint/eslint/commit/f560c06) Update: fix [space-unary-ops](/docs/4.0.0/rules/space-unary-ops) behavior with postfix UpdateExpressions ([#8391](https://github.com/eslint/eslint/issues/8391)) (Teddy Katz)




## Bug Fixes


* [2754141](https://github.com/eslint/eslint/commit/2754141) Fix: more autofix token-combining bugs ([#8394](https://github.com/eslint/eslint/issues/8394)) (Teddy Katz)
* [3c87e85](https://github.com/eslint/eslint/commit/3c87e85) Fix: [no-multi-spaces](/docs/4.0.0/rules/no-multi-spaces) false positive with irregular [indent](/docs/4.0.0/rules/indent) whitespace ([#8412](https://github.com/eslint/eslint/issues/8412)) (Teddy Katz)
* [936af66](https://github.com/eslint/eslint/commit/936af66) Fix: [no-multiple-empty-lines](/docs/4.0.0/rules/no-multiple-empty-lines) crash on space after last \n (fixes [#8401](https://github.com/eslint/eslint/issues/8401)) ([#8402](https://github.com/eslint/eslint/issues/8402)) (Teddy Katz)




## Documentation


* [950874f](https://github.com/eslint/eslint/commit/950874f) Docs: add 4.0.0 migration guide (fixes [#8306](https://github.com/eslint/eslint/issues/8306)) ([#8313](https://github.com/eslint/eslint/issues/8313)) (Teddy Katz)
* [de9f1a0](https://github.com/eslint/eslint/commit/de9f1a0) Docs: ES6 syntax vs globals configuration (fixes [#7984](https://github.com/eslint/eslint/issues/7984)) ([#8350](https://github.com/eslint/eslint/issues/8350)) (Zander Mackie)








## Chores


* [769b121](https://github.com/eslint/eslint/commit/769b121) Chore: Fix indentation errors in [indent-legacy](/docs/4.0.0/rules/indent-legacy) ([#8424](https://github.com/eslint/eslint/issues/8424)) (Kai Cataldo)
* [8842d7e](https://github.com/eslint/eslint/commit/8842d7e) Chore: fix comment spacing in tests ([#8405](https://github.com/eslint/eslint/issues/8405)) (Teddy Katz)
* [4673f6e](https://github.com/eslint/eslint/commit/4673f6e) Chore: Switch to eslint-scope from escope ([#8280](https://github.com/eslint/eslint/issues/8280)) (Corbin Uselton)
