---
layout: post
title: ESLint v3.19.0 released
teaser: "We just pushed ESLint v3.19.0, which is a minor release upgrade of ESLint. This release adds a new feature and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - btmills
categories:
  - Release Notes
---

## Highlights

Building on the release of [AST selectors](/docs/developer-guide/selectors) in [v3.18.0](/blog/2017/03/eslint-v3.18.0-released), [no-restricted-syntax](/docs/rules/no-restricted-syntax) now supports custom error messages:

```json
{
    "rules": {
        "no-restricted-syntax": [
            "error",
            {
                "selector": "CallExpression[callee.name='setTimeout'][arguments.length!=2]",
                "message": "setTimeout must always be invoked with two arguments."
            }
        ]
    }
}
```

Autofix is now more reliable thanks to nine individual fixes in this release.

## Enhancements


* [91baed4](https://github.com/eslint/eslint/commit/91baed4) Update: allow custom messages in [no-restricted-syntax](/docs/rules/no-restricted-syntax) (fixes [#8298](https://github.com/eslint/eslint/issues/8298)) ([#8357](https://github.com/eslint/eslint/issues/8357)) (Vitor Balocco)




## Bug Fixes


* [e09132f](https://github.com/eslint/eslint/commit/e09132f) Fix: [no-extra-parens](/docs/rules/no-extra-parens) false positive with exports and object literals ([#8359](https://github.com/eslint/eslint/issues/8359)) (Teddy Katz)
* [35c93e6](https://github.com/eslint/eslint/commit/35c93e6) Fix: prevent [space-before-function-paren](/docs/rules/space-before-function-paren) from checking type annotations ([#8349](https://github.com/eslint/eslint/issues/8349)) (Teddy Katz)
* [3342e9f](https://github.com/eslint/eslint/commit/3342e9f) Fix: don't modify operator precedence in [operator-assignment](/docs/rules/operator-assignment) autofixer ([#8358](https://github.com/eslint/eslint/issues/8358)) (Teddy Katz)
* [155424c](https://github.com/eslint/eslint/commit/155424c) Fix: ignore empty path in patterns (fixes [#8362](https://github.com/eslint/eslint/issues/8362)) ([#8364](https://github.com/eslint/eslint/issues/8364)) (alberto)
* [27616a8](https://github.com/eslint/eslint/commit/27616a8) Fix: [prefer-const](/docs/rules/prefer-const) false positive with object spread (fixes [#8187](https://github.com/eslint/eslint/issues/8187)) ([#8297](https://github.com/eslint/eslint/issues/8297)) (Vitor Balocco)
* [1b1046b](https://github.com/eslint/eslint/commit/1b1046b) Fix: don't classify plugins that throw errors as "missing" (fixes [#6874](https://github.com/eslint/eslint/issues/6874)) ([#8323](https://github.com/eslint/eslint/issues/8323)) (Teddy Katz)
* [29f4ba5](https://github.com/eslint/eslint/commit/29f4ba5) Fix: [no-useless-computed-key](/docs/rules/no-useless-computed-key) invalid autofix for getters and setters ([#8335](https://github.com/eslint/eslint/issues/8335)) (Teddy Katz)
* [0541eaf](https://github.com/eslint/eslint/commit/0541eaf) Fix: [no-implicit-coercion](/docs/rules/no-implicit-coercion) invalid autofix with consecutive identifiers ([#8340](https://github.com/eslint/eslint/issues/8340)) (Teddy Katz)
* [41b9786](https://github.com/eslint/eslint/commit/41b9786) Fix: [no-extra-parens](/docs/rules/no-extra-parens) false positive with objects following arrows ([#8339](https://github.com/eslint/eslint/issues/8339)) (Teddy Katz)
* [3146167](https://github.com/eslint/eslint/commit/3146167) Fix: `eslint.verify` should not mutate config argument (fixes [#8329](https://github.com/eslint/eslint/issues/8329)) ([#8334](https://github.com/eslint/eslint/issues/8334)) (alberto)
* [927de90](https://github.com/eslint/eslint/commit/927de90) Fix: [dot-notation](/docs/rules/dot-notation) autofix produces invalid syntax for integer properties ([#8332](https://github.com/eslint/eslint/issues/8332)) (Teddy Katz)
* [a9d1bea](https://github.com/eslint/eslint/commit/a9d1bea) Fix: [comma-style](/docs/rules/comma-style) autofix produces errors on parenthesized elements ([#8331](https://github.com/eslint/eslint/issues/8331)) (Teddy Katz)
* [d52173f](https://github.com/eslint/eslint/commit/d52173f) Fix: don't generate invalid options in config-rule ([#8326](https://github.com/eslint/eslint/issues/8326)) (Teddy Katz)
* [6eda3b5](https://github.com/eslint/eslint/commit/6eda3b5) Fix: [no-extra-parens](/docs/rules/no-extra-parens) invalid autofix in for-of statements ([#8337](https://github.com/eslint/eslint/issues/8337)) (Teddy Katz)
* [6c819d8](https://github.com/eslint/eslint/commit/6c819d8) Fix: [dot-notation](/docs/rules/dot-notation) autofix produces errors on parenthesized computed keys ([#8330](https://github.com/eslint/eslint/issues/8330)) (Teddy Katz)
* [2d883d7](https://github.com/eslint/eslint/commit/2d883d7) Fix: [object-shorthand](/docs/rules/object-shorthand) autofix produces errors on parenthesized functions ([#8328](https://github.com/eslint/eslint/issues/8328)) (Teddy Katz)
* [cd9b774](https://github.com/eslint/eslint/commit/cd9b774) Fix: [quotes](/docs/rules/quotes) false positive with backtick option in method names ([#8327](https://github.com/eslint/eslint/issues/8327)) (Teddy Katz)
* [d064ba2](https://github.com/eslint/eslint/commit/d064ba2) Fix: [no-else-return](/docs/rules/no-else-return) false positive for ifs in single-statement position ([#8338](https://github.com/eslint/eslint/issues/8338)) (Teddy Katz)
* [2f144ca](https://github.com/eslint/eslint/commit/2f144ca) Fix: [operator-assignment](/docs/rules/operator-assignment) autofix errors with parentheses (fixes [#8293](https://github.com/eslint/eslint/issues/8293)) ([#8294](https://github.com/eslint/eslint/issues/8294)) (Teddy Katz)
* [ddc6350](https://github.com/eslint/eslint/commit/ddc6350) Fix: [no-param-reassign](/docs/rules/no-param-reassign) false positive on destructuring (fixes [#8279](https://github.com/eslint/eslint/issues/8279)) ([#8281](https://github.com/eslint/eslint/issues/8281)) (Teddy Katz)




## Documentation


* [f88375f](https://github.com/eslint/eslint/commit/f88375f) Docs: clarify that [no-unsafe-negation](/docs/rules/no-unsafe-negation) is in eslint:recommended ([#8371](https://github.com/eslint/eslint/issues/8371)) (Teddy Katz)
* [02f0d27](https://github.com/eslint/eslint/commit/02f0d27) Docs: Add soda0289 to Development Team ([#8367](https://github.com/eslint/eslint/issues/8367)) (Kai Cataldo)
* [8569a90](https://github.com/eslint/eslint/commit/8569a90) Docs: add note about git's linebreak handling to [linebreak-style](/docs/rules/linebreak-style) docs ([#8361](https://github.com/eslint/eslint/issues/8361)) (Teddy Katz)
* [602e9c2](https://github.com/eslint/eslint/commit/602e9c2) Docs: fix incorrect selector examples ([#8278](https://github.com/eslint/eslint/issues/8278)) (Teddy Katz)




## Dependency Upgrades


* [79a97cb](https://github.com/eslint/eslint/commit/79a97cb) Upgrade: devDependencies ([#8303](https://github.com/eslint/eslint/issues/8303)) (alberto)
* [e4da200](https://github.com/eslint/eslint/commit/e4da200) Upgrade: Mocha to 3.2.0 ([#8299](https://github.com/eslint/eslint/issues/8299)) (Ilya Volodin)






## Chores


* [5878593](https://github.com/eslint/eslint/commit/5878593) Chore: fix invalid syntax in [no-param-reassign](/docs/rules/no-param-reassign) test ([#8360](https://github.com/eslint/eslint/issues/8360)) (Teddy Katz)
* [6a718ba](https://github.com/eslint/eslint/commit/6a718ba) Chore: enable [max-statements-per-line](/docs/rules/max-statements-per-line) on ESLint codebase ([#8321](https://github.com/eslint/eslint/issues/8321)) (Teddy Katz)
* [614b62e](https://github.com/eslint/eslint/commit/614b62e) Chore: update sinon calls to deprecated API. ([#8310](https://github.com/eslint/eslint/issues/8310)) (alberto)
* [0491572](https://github.com/eslint/eslint/commit/0491572) Chore: use precalculated counts in codeframe formatter ([#8296](https://github.com/eslint/eslint/issues/8296)) (Vitor Balocco)
* [8733e6a](https://github.com/eslint/eslint/commit/8733e6a) Chore: Fix incorrect error location properties in tests ([#8307](https://github.com/eslint/eslint/issues/8307)) (alberto)
* [c4ffb49](https://github.com/eslint/eslint/commit/c4ffb49) Chore: Fix typos in test option assertions ([#8305](https://github.com/eslint/eslint/issues/8305)) (Teddy Katz)
* [7521cd5](https://github.com/eslint/eslint/commit/7521cd5) Chore: update token logic in rules to use ast-utils ([#8288](https://github.com/eslint/eslint/issues/8288)) (Teddy Katz)
* [9b509ce](https://github.com/eslint/eslint/commit/9b509ce) Chore: refactor [space-before-function-paren](/docs/rules/space-before-function-paren) rule ([#8284](https://github.com/eslint/eslint/issues/8284)) (Teddy Katz)
* [f8176b3](https://github.com/eslint/eslint/commit/f8176b3) Chore: improve test coverage for node-event-generator ([#8287](https://github.com/eslint/eslint/issues/8287)) (Teddy Katz)
