---
layout: post
title: ESLint v3.18.0 released
teaser: "We just pushed ESLint v3.18.0, which is a minor release upgrade of ESLint. This release adds a new feature and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - not-an-aardvark
categories:
  - Release Notes
---

## Highlights

This release adds support for [AST selectors](/docs/developer-guide/selectors). AST selectors can describe syntax patterns very precisely, using a similar syntax to CSS selectors. Selectors can be used to:

* simplify the implementation of custom rules.
* disallow particular syntax patterns in a codebase using the [no-restricted-syntax](/docs/rules/no-restricted-syntax) rule.

For example, suppose you want to disallow calls to Mocha's `xdescribe` function in your codebase. Previously, it was not possible to do this without writing a custom rule. However, now you can configure the no-restricted-syntax rule with a selector:

```json
{
  "rules": {
    "no-restricted-syntax": [
      "error",
      "CallExpression[callee.name='xdescribe']"
    ]
  }
}
```

Selectors can give you a lot of control over specific patterns in your code, without needing to write a custom rule for each pattern.

For more details, see the [selector documentation](/docs/developer-guide/selectors).

## Features


* [1b678a6](https://github.com/eslint/eslint/commit/1b678a6) New: allow rules to listen for AST selectors (fixes [#5407](https://github.com/eslint/eslint/issues/5407)) ([#7833](https://github.com/eslint/eslint/issues/7833)) (Teddy Katz)




## Enhancements


* [23eca51](https://github.com/eslint/eslint/commit/23eca51) Update: Add allowTaggedTemplates to [no-unused-expressions](/docs/rules/no-unused-expressions) (fixes [#7632](https://github.com/eslint/eslint/issues/7632)) ([#8253](https://github.com/eslint/eslint/issues/8253)) (Kevin Partington)
* [7f8afe6](https://github.com/eslint/eslint/commit/7f8afe6) Update: [no-extra-parens](/docs/rules/no-extra-parens) overlooked spread and superClass (fixes [#8175](https://github.com/eslint/eslint/issues/8175)) ([#8209](https://github.com/eslint/eslint/issues/8209)) (Toru Nagashima)




## Bug Fixes


* [85f74ca](https://github.com/eslint/eslint/commit/85f74ca) Fix: broken code path of direct nested loops (fixes [#8248](https://github.com/eslint/eslint/issues/8248)) ([#8274](https://github.com/eslint/eslint/issues/8274)) (Toru Nagashima)
* [a61c359](https://github.com/eslint/eslint/commit/a61c359) Fix: Ignore hidden folders when resolving globs (fixes [#8259](https://github.com/eslint/eslint/issues/8259)) ([#8270](https://github.com/eslint/eslint/issues/8270)) (Ian VanSchooten)
* [0c0fc31](https://github.com/eslint/eslint/commit/0c0fc31) Fix: false positive of [no-extra-parens](/docs/rules/no-extra-parens) about spread and sequense ([#8275](https://github.com/eslint/eslint/issues/8275)) (Toru Nagashima)
* [47c3171](https://github.com/eslint/eslint/commit/47c3171) Fix: typo in console.error ([#8258](https://github.com/eslint/eslint/issues/8258)) (Jan Peer Stöcklmair)
* [13eead9](https://github.com/eslint/eslint/commit/13eead9) Fix: [sort-vars](/docs/rules/sort-vars) crash on mixed destructuring declarations ([#8245](https://github.com/eslint/eslint/issues/8245)) (Teddy Katz)
* [133f489](https://github.com/eslint/eslint/commit/133f489) Fix: [func-name-matching](/docs/rules/func-name-matching) crash on destructuring assignment to functions ([#8247](https://github.com/eslint/eslint/issues/8247)) (Teddy Katz)
* [a34b9c4](https://github.com/eslint/eslint/commit/a34b9c4) Fix: [func-name-matching](/docs/rules/func-name-matching) crash on non-string literal computed keys ([#8246](https://github.com/eslint/eslint/issues/8246)) (Teddy Katz)
* [5b5c236](https://github.com/eslint/eslint/commit/5b5c236) Fix: wrong comment when module not found in config (fixes [#8192](https://github.com/eslint/eslint/issues/8192)) ([#8196](https://github.com/eslint/eslint/issues/8196)) (alberto)




## Documentation


* [e104973](https://github.com/eslint/eslint/commit/e104973) Docs: remove self-reference in [no-restricted-syntax](/docs/rules/no-restricted-syntax) docs ([#8277](https://github.com/eslint/eslint/issues/8277)) (Vitor Balocco)
* [7276e6d](https://github.com/eslint/eslint/commit/7276e6d) Docs: remove unneeded semicolons in [arrow-parens](/docs/rules/arrow-parens).md ([#8249](https://github.com/eslint/eslint/issues/8249)) (Dmitry Gershun)
* [df12137](https://github.com/eslint/eslint/commit/df12137) Docs: fix typos ([#8235](https://github.com/eslint/eslint/issues/8235)) (Gyandeep Singh)
* [ce6ff56](https://github.com/eslint/eslint/commit/ce6ff56) Docs: set recommended true for [no-global-assign](/docs/rules/no-global-assign) (fixes [#8215](https://github.com/eslint/eslint/issues/8215)) ([#8218](https://github.com/eslint/eslint/issues/8218)) (BinYi LIU)




## Dependency Upgrades


* [f9ede3f](https://github.com/eslint/eslint/commit/f9ede3f) Upgrade: doctrine to 2.0.0 ([#8269](https://github.com/eslint/eslint/issues/8269)) (alberto)
* [8c40a25](https://github.com/eslint/eslint/commit/8c40a25) Upgrade: update concat-stream to 1.5.2 ([#8228](https://github.com/eslint/eslint/pull/8228)) (Samuel)
* [149c055](https://github.com/eslint/eslint/commit/149c055) Upgrade: mock-fs to v4.2.0 (fixes [#8194](https://github.com/eslint/eslint/issues/8194)) ([#8243](https://github.com/eslint/eslint/issues/8243)) (Teddy Katz)




## Build Related


* [a83bff9](https://github.com/eslint/eslint/commit/a83bff9) Build: remove unneeded json config in demo (fixes [#8237](https://github.com/eslint/eslint/issues/8237)) ([#8242](https://github.com/eslint/eslint/issues/8242)) (alberto)




## Chores


* [6f05546](https://github.com/eslint/eslint/commit/6f05546) Chore: convert StubModuleResolver in config tests to ES6 class ([#8265](https://github.com/eslint/eslint/issues/8265)) (Teddy Katz)
* [63ca0c5](https://github.com/eslint/eslint/commit/63ca0c5) Chore: use precalculated counts in stylish formatter ([#8251](https://github.com/eslint/eslint/issues/8251)) (alberto)
* [e74ed6d](https://github.com/eslint/eslint/commit/e74ed6d) Chore: convert Traverser to ES6 class (refs [#7849](https://github.com/eslint/eslint/issues/7849)) ([#8232](https://github.com/eslint/eslint/issues/8232)) (Teddy Katz)
* [b5e9788](https://github.com/eslint/eslint/commit/b5e9788) Chore: rename [no-extra-parens](/docs/rules/no-extra-parens) methods ([#8225](https://github.com/eslint/eslint/issues/8225)) (Vitor Balocco)
