---
layout: post
title: ESLint v3.17.0 released
teaser: "We just pushed ESLint v3.17.0, which is a minor release upgrade of ESLint. This release adds a new feature and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - not-an-aardvark
categories:
  - Release Notes
---

## Highlights

Two new rules were added:

* [no-compare-neg-zero](/docs/rules/no-compare-neg-zero)
* [nonblock-statement-body-position](/docs/rules/nonblock-statement-body-position)

Two new methods were added to the `SourceCode` API for rules:

* [`getLocFromIndex` and `getIndexFromLoc`](/docs/developer-guide/working-with-rules#contextgetsourcecode)

Two enhancements were made to the [`RuleTester`](/docs/developer-guide/working-with-plugins#testing) utility:

* Error message assertions can now be regular expressions.
* `output` for a test case can be set to `null` to assert that the case is not autofixed.

## Features


* [dad20ad](https://github.com/eslint/eslint/commit/dad20ad) New: add SourceCode#getLocFromIndex and #getIndexFromLoc (fixes [#8073](https://github.com/eslint/eslint/issues/8073)) ([#8158](https://github.com/eslint/eslint/issues/8158)) (Teddy Katz)
* [20daea5](https://github.com/eslint/eslint/commit/20daea5) New: [no-compare-neg-zero](/docs/rules/no-compare-neg-zero) rule ([#8091](https://github.com/eslint/eslint/issues/8091)) (薛定谔的猫)
* [287e882](https://github.com/eslint/eslint/commit/287e882) New: [nonblock-statement-body-position](/docs/rules/nonblock-statement-body-position) rule (fixes [#6067](https://github.com/eslint/eslint/issues/6067)) ([#8108](https://github.com/eslint/eslint/issues/8108)) (Teddy Katz)
* [7ff42e8](https://github.com/eslint/eslint/commit/7ff42e8) New: Allow regexes in RuleTester (fixes [#7837](https://github.com/eslint/eslint/issues/7837)) ([#8115](https://github.com/eslint/eslint/issues/8115)) (Daniel Lo Nigro)




## Enhancements


* [4fdf6d7](https://github.com/eslint/eslint/commit/4fdf6d7) Update: deprecate `applyDefaultPatterns` in [`line-comment-position`](/docs/rules/line-comment-position) ([#8183](https://github.com/eslint/eslint/issues/8183)) (alberto)
* [bf4d8cf](https://github.com/eslint/eslint/commit/bf4d8cf) Update: ignore eslint comments in lines-arount-comment (fixes [#4345](https://github.com/eslint/eslint/issues/4345)) ([#8155](https://github.com/eslint/eslint/issues/8155)) (alberto)
* [18a519f](https://github.com/eslint/eslint/commit/18a519f) Update: let RuleTester cases assert that no autofix occurs (fixes [#8157](https://github.com/eslint/eslint/issues/8157)) ([#8163](https://github.com/eslint/eslint/issues/8163)) (Teddy Katz)
* [ca1694b](https://github.com/eslint/eslint/commit/ca1694b) Update: ignore negative ranges in fixes ([#8133](https://github.com/eslint/eslint/issues/8133)) (alberto)
* [da8e8af](https://github.com/eslint/eslint/commit/da8e8af) Update: include function name in report message if possible (fixes [#7260](https://github.com/eslint/eslint/issues/7260)) ([#8058](https://github.com/eslint/eslint/issues/8058)) (Dieter Luypaert)




## Bug Fixes


* [25e5817](https://github.com/eslint/eslint/commit/25e5817) Fix: Don't autofix `+ +a` to `++a` in [space-unary-ops](/docs/rules/space-unary-ops) ([#8176](https://github.com/eslint/eslint/issues/8176)) (Alan Pierce)
* [d02bd11](https://github.com/eslint/eslint/commit/d02bd11) Fix: [padded-blocks](/docs/rules/padded-blocks) autofix problems with comments ([#8149](https://github.com/eslint/eslint/issues/8149)) (alberto)
* [4d35a81](https://github.com/eslint/eslint/commit/4d35a81) Fix: Add a utility to avoid autofix conflicts (fixes [#7928](https://github.com/eslint/eslint/issues/7928), fixes [#8026](https://github.com/eslint/eslint/issues/8026)) ([#8067](https://github.com/eslint/eslint/issues/8067)) (Alan Pierce)
* [1ee5c27](https://github.com/eslint/eslint/commit/1ee5c27) Fix: Make RuleTester handle empty-string cases gracefully (fixes [#8142](https://github.com/eslint/eslint/issues/8142)) ([#8143](https://github.com/eslint/eslint/issues/8143)) (Teddy Katz)
* [4e52cfc](https://github.com/eslint/eslint/commit/4e52cfc) Fix: Improve [keyword-spacing](/docs/rules/keyword-spacing) typescript support (fixes [#8110](https://github.com/eslint/eslint/issues/8110)) ([#8111](https://github.com/eslint/eslint/issues/8111)) (Reyad Attiyat)
* [8f91e32](https://github.com/eslint/eslint/commit/8f91e32) Fix: `ignoreRestSiblings` option didn't cover arguments (fixes [#8119](https://github.com/eslint/eslint/issues/8119)) ([#8120](https://github.com/eslint/eslint/issues/8120)) (Toru Nagashima)




## Documentation


* [a30eb8d](https://github.com/eslint/eslint/commit/a30eb8d) Docs: improve documentation for RuleTester cases ([#8162](https://github.com/eslint/eslint/issues/8162)) (Teddy Katz)
* [9994889](https://github.com/eslint/eslint/commit/9994889) Docs: Add missing space to `create` in [`no-use-before-define`](/docs/rules/no-use-before-define) ([#8166](https://github.com/eslint/eslint/issues/8166)) (Justin Anastos)
* [4d542ba](https://github.com/eslint/eslint/commit/4d542ba) Docs: Remove unneeded statement about autofix ([#8164](https://github.com/eslint/eslint/issues/8164)) (alberto)
* [163d751](https://github.com/eslint/eslint/commit/163d751) Docs: [`lines-around-comment`](/docs/rules/lines-around-comment) doesn't disallow empty lines ([#8151](https://github.com/eslint/eslint/issues/8151)) (alberto)
* [044bc10](https://github.com/eslint/eslint/commit/044bc10) Docs: Add details about "--fix" option for "[sort-imports](/docs/rules/sort-imports)" rule ([#8077](https://github.com/eslint/eslint/issues/8077)) (Olivier Audard)






## Build Related


* [a6ce8f9](https://github.com/eslint/eslint/commit/a6ce8f9) Build: Sort rules before dumping them to doc files ([#8154](https://github.com/eslint/eslint/issues/8154)) (Danny Andrews)
* [cbd7ded](https://github.com/eslint/eslint/commit/cbd7ded) Build: display rules’ meta data in their docs (fixes [#5774](https://github.com/eslint/eslint/issues/5774)) ([#8127](https://github.com/eslint/eslint/issues/8127)) (Wilson Kurniawan)




## Chores


* [0af9057](https://github.com/eslint/eslint/commit/0af9057) Chore: Upgrade to a patched version of mock-fs (fixes [#8177](https://github.com/eslint/eslint/issues/8177)) ([#8188](https://github.com/eslint/eslint/issues/8188)) (Teddy Katz)
* [a78ec9f](https://github.com/eslint/eslint/commit/a78ec9f) Chore: upgrade `coveralls` to ^2.11.16 ([#8161](https://github.com/eslint/eslint/issues/8161)) (alberto)
* [7f1f4e5](https://github.com/eslint/eslint/commit/7f1f4e5) Chore: remove unneeded devDeps `linefix` and `gh-got` ([#8160](https://github.com/eslint/eslint/issues/8160)) (alberto)
* [1c84922](https://github.com/eslint/eslint/commit/1c84922) Chore: upgrade eslint-plugin-node ([#8156](https://github.com/eslint/eslint/issues/8156)) (alberto)
