---
layout: post
title: ESLint v3.16.0 released
teaser: "We just pushed ESLint v3.16.0, which is a minor release upgrade of ESLint. This release adds a new feature and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - kaicataldo
categories:
  - Release Notes
---

## Highlights

This is a summary of some of the notable changes in this version of ESLint.

### Updated Token Iterator Methods

This release includes an exciting update for rule authors! Many of the token iterator methods provided by `sourceCode` have been updated with a new options parameter. Some highlights:

#### includeComments

Many of these methods can now include comments in the returned results using the `{ includeComments: true }` option. The following methods are now deprecated:

- `sourceCode.getTokenOrCommentBefore(node)`
- `sourceCode.getTokenOrCommentAfter(node)`

Instead, please use the following, respectively:
- `sourceCode.getTokenBefore(node, { includeComments: true })`
- `sourceCode.getTokenAfter(node, { includeComments: true })`

#### filter

The `filter` option is a function that will filter the returned tokens. This allows for finding a specific token by type or value without having to create a loop.

For instance, the following:

```js
let token = sourceCode.getTokenAfter(node);

while (token.type !== "Keyword") {
    token = sourceCode.getTokenAfter(token);
}
```

can now be written as:

```js
const token = sourceCode.getTokenAfter(node, { filter: token => token.type === "Keyword" });
```

The update includes other options as well! For more details, please read the [updated documentation](https://eslint.org/docs/developer-guide/working-with-rules#contextgetsourcecode).

### Performance Improvements

Performance improvements were made to both the initial processing of source code as well as to autofixing.

### Autofixing

Autofix support was added to one rule:

- [no-unused-labels](/docs/rules/no-unused-labels)

## Enhancements


* [d89d0b4](https://github.com/eslint/eslint/commit/d89d0b4) Update: fix [quotes](/docs/rules/quotes) false negative for string literals as template tags ([#8107](https://github.com/eslint/eslint/issues/8107)) (Teddy Katz)
* [360dbe4](https://github.com/eslint/eslint/commit/360dbe4) Update: Improve error message when extend config missing (fixes [#6115](https://github.com/eslint/eslint/issues/6115)) ([#8100](https://github.com/eslint/eslint/issues/8100)) (alberto)
* [cfb65c5](https://github.com/eslint/eslint/commit/cfb65c5) Update: make [no-lone-blocks](/docs/rules/no-lone-blocks) report blocks in switch cases (fixes [#8047](https://github.com/eslint/eslint/issues/8047)) ([#8062](https://github.com/eslint/eslint/issues/8062)) (Teddy Katz)
* [290fb1f](https://github.com/eslint/eslint/commit/290fb1f) Update: Add includeComments to getTokenByRangeStart (fixes [#8068](https://github.com/eslint/eslint/issues/8068)) ([#8069](https://github.com/eslint/eslint/issues/8069)) (Kai Cataldo)
* [acc3301](https://github.com/eslint/eslint/commit/acc3301) Update: handle uncommon linebreaks consistently in rules (fixes [#7949](https://github.com/eslint/eslint/issues/7949)) ([#8049](https://github.com/eslint/eslint/issues/8049)) (Teddy Katz)
* [90fd555](https://github.com/eslint/eslint/commit/90fd555) Update: improve null detection in [eqeqeq](/docs/rules/eqeqeq) for ES6 regexes (fixes [#8020](https://github.com/eslint/eslint/issues/8020)) ([#8042](https://github.com/eslint/eslint/issues/8042)) (Teddy Katz)
* [834f45d](https://github.com/eslint/eslint/commit/834f45d) Update: rewrite TokenStore (fixes [#7810](https://github.com/eslint/eslint/issues/7810)) ([#7936](https://github.com/eslint/eslint/issues/7936)) (Toru Nagashima)
* [1e3d4c6](https://github.com/eslint/eslint/commit/1e3d4c6) Update: add fixer for [no-unused-labels](/docs/rules/no-unused-labels) ([#7841](https://github.com/eslint/eslint/issues/7841)) (Teddy Katz)
* [f47fb98](https://github.com/eslint/eslint/commit/f47fb98) Update: ensure [semi-spacing](/docs/rules/semi-spacing) checks import/export declarations ([#8033](https://github.com/eslint/eslint/issues/8033)) (Teddy Katz)
* [e228d56](https://github.com/eslint/eslint/commit/e228d56) Update: [no-undefined](/docs/rules/no-undefined) handles properties/classes/modules (fixes [#7964](https://github.com/eslint/eslint/issues/7964)) ([#7966](https://github.com/eslint/eslint/issues/7966)) (Kevin Partington)




## Bug Fixes


* [daf6f26](https://github.com/eslint/eslint/commit/daf6f26) Fix: check output in RuleTester when errors is a number (fixes [#7640](https://github.com/eslint/eslint/issues/7640)) ([#8097](https://github.com/eslint/eslint/issues/8097)) (alberto)
* [7516303](https://github.com/eslint/eslint/commit/7516303) Fix: `sourceCode.getTokenAfter` shouldn't skip tokens after comments ([#8055](https://github.com/eslint/eslint/issues/8055)) (Toru Nagashima)
* [c53e034](https://github.com/eslint/eslint/commit/c53e034) Fix: [unicode-bom](/docs/rules/unicode-bom) fixer insert BOM in appropriate location (fixes [#8083](https://github.com/eslint/eslint/issues/8083)) ([#8084](https://github.com/eslint/eslint/issues/8084)) (pantosha)
* [16248e2](https://github.com/eslint/eslint/commit/16248e2) Fix: [no-extra-boolean-cast](/docs/rules/no-extra-boolean-cast) incorrect Boolean() autofixing (fixes [#7977](https://github.com/eslint/eslint/issues/7977)) ([#8037](https://github.com/eslint/eslint/issues/8037)) (Jonathan Wilsson)




## Documentation


* [14d146d](https://github.com/eslint/eslint/commit/14d146d) Docs: Clarify --ext only works with directories (fixes [#7939](https://github.com/eslint/eslint/issues/7939)) ([#8095](https://github.com/eslint/eslint/issues/8095)) (alberto)
* [013a454](https://github.com/eslint/eslint/commit/013a454) Docs: Add TSC meeting quorum requirement ([#8086](https://github.com/eslint/eslint/issues/8086)) (Kevin Partington)
* [6445d2a](https://github.com/eslint/eslint/commit/6445d2a) Docs: Add documentation for /* exported */ (fixes [#7998](https://github.com/eslint/eslint/issues/7998)) ([#8065](https://github.com/eslint/eslint/issues/8065)) (Lee Yi Min)
* [c596690](https://github.com/eslint/eslint/commit/c596690) Docs: Clarify [generator-star-spacing](/docs/rules/generator-star-spacing) config example (fixes [#8027](https://github.com/eslint/eslint/issues/8027)) ([#8034](https://github.com/eslint/eslint/issues/8034)) (Hòa Trần)
* [a11d4a6](https://github.com/eslint/eslint/commit/a11d4a6) Docs: fix a typo in shareable configs documentation ([#8036](https://github.com/eslint/eslint/issues/8036)) (Dan Homola)




## Dependency Upgrades


* [c7e64f3](https://github.com/eslint/eslint/commit/c7e64f3) Upgrade: mock-fs ([#8070](https://github.com/eslint/eslint/issues/8070)) (Toru Nagashima)






## Chores


* [21be366](https://github.com/eslint/eslint/commit/21be366) Chore: Ensuring eslint:recommended rules are sorted. ([#8106](https://github.com/eslint/eslint/issues/8106)) (Kevin Partington)
* [f62a724](https://github.com/eslint/eslint/commit/f62a724) Chore: use updated token iterator methods ([#8103](https://github.com/eslint/eslint/issues/8103)) (Kai Cataldo)
* [ff066dc](https://github.com/eslint/eslint/commit/ff066dc) Chore: Incorrect source code test text ([#8096](https://github.com/eslint/eslint/issues/8096)) (Jack Ford)
* [55ac302](https://github.com/eslint/eslint/commit/55ac302) Chore: fix the timing to define rules for tests ([#8082](https://github.com/eslint/eslint/issues/8082)) (Toru Nagashima)
* [591b74a](https://github.com/eslint/eslint/commit/591b74a) Chore: enable [operator-linebreak](/docs/rules/operator-linebreak) on ESLint codebase ([#8064](https://github.com/eslint/eslint/issues/8064)) (Teddy Katz)
* [fcc38db](https://github.com/eslint/eslint/commit/fcc38db) Chore: simplify and improve performance for autofix ([#8035](https://github.com/eslint/eslint/issues/8035)) (Toru Nagashima)
* [b04fde7](https://github.com/eslint/eslint/commit/b04fde7) Chore: improve performance of SourceCode constructor ([#8054](https://github.com/eslint/eslint/issues/8054)) (Teddy Katz)
* [329dcdc](https://github.com/eslint/eslint/commit/329dcdc) Chore: unify checks for statement list parents ([#8048](https://github.com/eslint/eslint/issues/8048)) (Teddy Katz)
* [7bc92d9](https://github.com/eslint/eslint/commit/7bc92d9) Chore: fix invalid test cases ([#8030](https://github.com/eslint/eslint/issues/8030)) (Toru Nagashima)
