---
layout: post
title: ESLint v3.15.0 released
teaser: "We just pushed ESLint v3.15.0, which is a minor release upgrade of ESLint. This release adds a new feature and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - ilyavolodin
categories:
  - Release Notes
---

## Highlights

This is a summary of some of the notable changes in this version of ESLint.

### New Rules

One new rule was added:

- [`template-tag-spacing`](/docs/rules/template-tag-spacing)


## Features


* [09546a4](https://github.com/eslint/eslint/commit/09546a4) New: [`template-tag-spacing`](/docs/rules/template-tag-spacing) rule (fixes [#7631](https://github.com/eslint/eslint/issues/7631)) ([#7913](https://github.com/eslint/eslint/issues/7913)) (Jonathan Wilsson)




## Enhancements


* [c59a0ba](https://github.com/eslint/eslint/commit/c59a0ba) Update: add ignoreRestSiblings option to [no-unused-vars](/docs/rules/no-unused-vars) ([#7968](https://github.com/eslint/eslint/issues/7968)) (Zack Argyle)
* [fbd7c13](https://github.com/eslint/eslint/commit/fbd7c13) Update: ensure [operator-assignment](/docs/rules/operator-assignment) handles exponentiation operators ([#7970](https://github.com/eslint/eslint/issues/7970)) (Teddy Katz)
* [c5066ce](https://github.com/eslint/eslint/commit/c5066ce) Update: add "variables" option to [no-use-before-define](/docs/rules/no-use-before-define) (fixes [#7111](https://github.com/eslint/eslint/issues/7111)) ([#7948](https://github.com/eslint/eslint/issues/7948)) (Teddy Katz)




## Bug Fixes


* [f2a3580](https://github.com/eslint/eslint/commit/f2a3580) Fix: [`no-extra-parens`](/docs/rules/no-extra-parens) incorrect precedence (fixes [#7978](https://github.com/eslint/eslint/issues/7978)) ([#7999](https://github.com/eslint/eslint/issues/7999)) (alberto)
* [d6b6ba1](https://github.com/eslint/eslint/commit/d6b6ba1) Fix: [no-var](/docs/rules/no-var) should fix ForStatement.init ([#7993](https://github.com/eslint/eslint/issues/7993)) (Toru Nagashima)




## Documentation


* [42390fd](https://github.com/eslint/eslint/commit/42390fd) Docs: update README.md for team ([#8016](https://github.com/eslint/eslint/issues/8016)) (Toru Nagashima)
* [f2be7e3](https://github.com/eslint/eslint/commit/f2be7e3) Docs: Fix typo in [object-curly-newline](/docs/rules/object-curly-newline).md ([#8002](https://github.com/eslint/eslint/issues/8002)) (Danny Andrews)
* [df2351a](https://github.com/eslint/eslint/commit/df2351a) Docs: Fix misleading section in [brace-style](/docs/rules/brace-style) documentation ([#7996](https://github.com/eslint/eslint/issues/7996)) (Teddy Katz)




## Dependency Upgrades


* [99d386d](https://github.com/eslint/eslint/commit/99d386d) Upgrade: Espree v3.4.0 ([#8019](https://github.com/eslint/eslint/issues/8019)) (Kai Cataldo)






## Chores


* [d7ffd88](https://github.com/eslint/eslint/commit/d7ffd88) Chore: enable [template-tag-spacing](/docs/rules/template-tag-spacing) on ESLint codebase ([#8005](https://github.com/eslint/eslint/issues/8005)) (Teddy Katz)
* [5ae6e00](https://github.com/eslint/eslint/commit/5ae6e00) Chore: avoid unnecessary feature detection for Symbol ([#7992](https://github.com/eslint/eslint/issues/7992)) (Teddy Katz)
* [5d57c57](https://github.com/eslint/eslint/commit/5d57c57) Chore: fix [no-else-return](/docs/rules/no-else-return) lint error (refs [#7986](https://github.com/eslint/eslint/issues/7986)) ([#7994](https://github.com/eslint/eslint/issues/7994)) (Vitor Balocco)
* [62fb054](https://github.com/eslint/eslint/commit/62fb054) Chore: enable [no-else-return](/docs/rules/no-else-return) on ESLint codebase ([#7986](https://github.com/eslint/eslint/issues/7986)) (Teddy Katz)
* [5cdfa99](https://github.com/eslint/eslint/commit/5cdfa99) Chore: enable [no-unneeded-ternary](/docs/rules/no-unneeded-ternary) on ESLint codebase ([#7987](https://github.com/eslint/eslint/issues/7987)) (Teddy Katz)
