---
layout: post
title: ESLint v3.14.0 released
teaser: "We just pushed ESLint v3.14.0, which is a minor release upgrade of ESLint. This release adds a new feature and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - btmills
categories:
  - Release Notes
---

## Highlights

This is a summary of some of the notable changes in this version of ESLint.

### New Rules

Two new rules were added:

- [`no-multi-assign`](/docs/rules/no-multi-assign)
- [`prefer-promise-reject-errors`](/docs/rules/prefer-promise-reject-errors)

### Autofixing

Autofix support was added to one rule:

- [`no-else-return`](/docs/rules/no-else-return)


## Features


* [05e7432](https://github.com/eslint/eslint/commit/05e7432) New: [`no-multi-assign`](/docs/rules/no-multi-assign) rule (fixes [#6424](https://github.com/eslint/eslint/issues/6424)) ([#7904](https://github.com/eslint/eslint/issues/7904)) (Stewart Rand)
* [f091d95](https://github.com/eslint/eslint/commit/f091d95) New: [`prefer-promise-reject-errors`](/docs/rules/prefer-promise-reject-errors) rule (fixes [#7685](https://github.com/eslint/eslint/issues/7685)) ([#7689](https://github.com/eslint/eslint/issues/7689)) (Teddy Katz)




## Enhancements


* [243e47d](https://github.com/eslint/eslint/commit/243e47d) Update: Add fixer for [no-else-return](/docs/rules/no-else-return) (fixes [#7863](https://github.com/eslint/eslint/issues/7863)) ([#7864](https://github.com/eslint/eslint/issues/7864)) (Xander Dumaine)
* [a664e8a](https://github.com/eslint/eslint/commit/a664e8a) Update: add ignoreJSX option to [no-extra-parens](/docs/rules/no-extra-parens) (Fixes [#7444](https://github.com/eslint/eslint/issues/7444)) ([#7926](https://github.com/eslint/eslint/issues/7926)) (Robert Rossmann)
* [bd5e219](https://github.com/eslint/eslint/commit/bd5e219) Update: ensure [brace-style](/docs/rules/brace-style) validates class bodies (fixes [#7608](https://github.com/eslint/eslint/issues/7608)) ([#7871](https://github.com/eslint/eslint/issues/7871)) (Teddy Katz)
* [55f0cb6](https://github.com/eslint/eslint/commit/55f0cb6) Update: refactor [brace-style](/docs/rules/brace-style) and fix inconsistencies (fixes [#7869](https://github.com/eslint/eslint/issues/7869)) ([#7870](https://github.com/eslint/eslint/issues/7870)) (Teddy Katz)




## Bug Fixes


* [506324a](https://github.com/eslint/eslint/commit/506324a) Fix: [`no-var`](/docs/rules/no-var) does not fix if causes ReferenceError (fixes [#7950](https://github.com/eslint/eslint/issues/7950)) ([#7953](https://github.com/eslint/eslint/issues/7953)) (Toru Nagashima)
* [ca01e00](https://github.com/eslint/eslint/commit/ca01e00) Fix: recognize all line terminators in [func-call-spacing](/docs/rules/func-call-spacing) (fixes [#7923](https://github.com/eslint/eslint/issues/7923)) ([#7924](https://github.com/eslint/eslint/issues/7924)) (Francesco Trotta)
* [8ac3518](https://github.com/eslint/eslint/commit/8ac3518) Fix: [no-useless-computed-key](/docs/rules/no-useless-computed-key) false positive with `__proto__` ([#7934](https://github.com/eslint/eslint/issues/7934)) (Teddy Katz)
* [7e04b33](https://github.com/eslint/eslint/commit/7e04b33) Fix: Ignore inline plugin rule config in autoconfig (fixes [#7860](https://github.com/eslint/eslint/issues/7860)) ([#7919](https://github.com/eslint/eslint/issues/7919)) (Ian VanSchooten)
* [6448ba0](https://github.com/eslint/eslint/commit/6448ba0) Fix: add parentheses in [no-extra-boolean-cast](/docs/rules/no-extra-boolean-cast) autofixer (fixes [#7912](https://github.com/eslint/eslint/issues/7912)) ([#7914](https://github.com/eslint/eslint/issues/7914)) (Szymon Przybylski)
* [b3f2094](https://github.com/eslint/eslint/commit/b3f2094) Fix: [brace-style](/docs/rules/brace-style) crash with lone block statements (fixes [#7908](https://github.com/eslint/eslint/issues/7908)) ([#7909](https://github.com/eslint/eslint/issues/7909)) (Teddy Katz)
* [427543a](https://github.com/eslint/eslint/commit/427543a) Fix: catastrophic backtracking in astUtils linebreak regex (fixes [#7893](https://github.com/eslint/eslint/issues/7893)) ([#7898](https://github.com/eslint/eslint/issues/7898)) (Teddy Katz)
* [995554c](https://github.com/eslint/eslint/commit/995554c) Fix: Correct typos in [no-alert](/docs/rules/no-alert).md and lib/ast-utils.js ([#7905](https://github.com/eslint/eslint/issues/7905)) (Stewart Rand)




## Documentation


* [c835e19](https://github.com/eslint/eslint/commit/c835e19) Docs: remove reference to deleted rule ([#7942](https://github.com/eslint/eslint/issues/7942)) (Alejandro Oviedo)
* [3c1e63b](https://github.com/eslint/eslint/commit/3c1e63b) Docs: Improve examples for [no-case-declarations](/docs/rules/no-case-declarations) (fixes [#6716](https://github.com/eslint/eslint/issues/6716)) ([#7920](https://github.com/eslint/eslint/issues/7920)) (Kevin Rangel)
* [5eb2e88](https://github.com/eslint/eslint/commit/5eb2e88) Docs: Correct typos in configuring.md ([#7916](https://github.com/eslint/eslint/issues/7916)) (Gabriel Delépine)








## Chores


* [d6150e3](https://github.com/eslint/eslint/commit/d6150e3) Chore: Enable [comma-dangle](/docs/rules/comma-dangle) on ESLint codebase (fixes [#7725](https://github.com/eslint/eslint/issues/7725)) ([#7906](https://github.com/eslint/eslint/issues/7906)) (Teddy Katz)
* [075ec25](https://github.com/eslint/eslint/commit/075ec25) Chore: update to use ES6 classes (refs [#7849](https://github.com/eslint/eslint/issues/7849)) ([#7891](https://github.com/eslint/eslint/issues/7891)) (Claire Dranginis)
