---
layout: post
title: ESLint v3.13.0 released
teaser: "We just pushed ESLint v3.13.0, which is a minor release upgrade of ESLint. This release adds a new feature and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - ilyavolodin
categories:
  - Release Notes
---

## Highlights

This is a summary of some of the notable changes in this version of ESLint.

### New Rules

One new rule was added:

- [prefer-destructuring](/docs/rules/prefer-destructuring)

### Autofixing

Autofix support was added to the following rules:

- [no-extra-label](/docs/rules/no-extra-label)
- [no-unneeded-ternary](/docs/rules/no-unneeded-ternary)
- [object-property-newline](/docs/rules/object-property-newline)
- [operator-linebreak](/docs/rules/operator-linebreak)


## Features


* [27424cb](https://github.com/eslint/eslint/commit/27424cb) New: [`prefer-destructuring`](/docs/rules/prefer-destructuring) rule (fixes [#6053](https://github.com/eslint/eslint/issues/6053)) ([#7741](https://github.com/eslint/eslint/issues/7741)) (Alex LaFroscia)




## Enhancements


* [cd4c025](https://github.com/eslint/eslint/commit/cd4c025) Update: add fixer for [no-extra-label](/docs/rules/no-extra-label) ([#7840](https://github.com/eslint/eslint/issues/7840)) (Teddy Katz)
* [c9ba40a](https://github.com/eslint/eslint/commit/c9ba40a) Update: add fixer for [`no-unneeded-ternary`](/docs/rules/no-unneeded-ternary) ([#7540](https://github.com/eslint/eslint/issues/7540)) (Teddy Katz)
* [dd56d87](https://github.com/eslint/eslint/commit/dd56d87) Update: add [object-shorthand](/docs/rules/object-shorthand) option for arrow functions (fixes [#7564](https://github.com/eslint/eslint/issues/7564)) ([#7746](https://github.com/eslint/eslint/issues/7746)) (Teddy Katz)
* [d80d994](https://github.com/eslint/eslint/commit/d80d994) Update: add fixer for [object-property-newline](/docs/rules/object-property-newline) (fixes [#7740](https://github.com/eslint/eslint/issues/7740)) ([#7808](https://github.com/eslint/eslint/issues/7808)) (Teddy Katz)
* [1beecec](https://github.com/eslint/eslint/commit/1beecec) Update: add fixer for [`operator-linebreak`](/docs/rules/operator-linebreak) ([#7702](https://github.com/eslint/eslint/issues/7702)) (Teddy Katz)
* [ebcae1f](https://github.com/eslint/eslint/commit/ebcae1f) Update: [no-return-await](/docs/rules/no-return-await) with with complex `return` argument (fixes [#7594](https://github.com/eslint/eslint/issues/7594)) ([#7595](https://github.com/eslint/eslint/issues/7595)) (Dalton Santos)
* [7d1dc7e](https://github.com/eslint/eslint/commit/7d1dc7e) Update: Make [default-case](/docs/rules/default-case) comment case-insensitive (fixes [#7673](https://github.com/eslint/eslint/issues/7673)) ([#7742](https://github.com/eslint/eslint/issues/7742)) (Robert Rossmann)




## Bug Fixes


* [aa75c92](https://github.com/eslint/eslint/commit/aa75c92) Fix: Ensure [prefer-const](/docs/rules/prefer-const) fixes destructuring assignments (fixes [#7852](https://github.com/eslint/eslint/issues/7852)) ([#7859](https://github.com/eslint/eslint/issues/7859)) (Teddy Katz)
* [ca1f841](https://github.com/eslint/eslint/commit/ca1f841) Fix: [no-useless-return](/docs/rules/no-useless-return) stack overflow on loops after throw (fixes [#7855](https://github.com/eslint/eslint/issues/7855)) ([#7856](https://github.com/eslint/eslint/issues/7856)) (Teddy Katz)
* [bf3ea3a](https://github.com/eslint/eslint/commit/bf3ea3a) Fix: [capitalized-comments](/docs/rules/capitalized-comments): Ignore consec. comments if first is invalid ([#7835](https://github.com/eslint/eslint/issues/7835)) (Kevin Partington)
* [0fc24f7](https://github.com/eslint/eslint/commit/0fc24f7) Fix: adapt new-paren rule so it handles TypeScript (fixes [#7817](https://github.com/eslint/eslint/issues/7817)) ([#7820](https://github.com/eslint/eslint/issues/7820)) (Philipp A)
* [df0b06b](https://github.com/eslint/eslint/commit/df0b06b) Fix: [no-multiple-empty-lines](/docs/rules/no-multiple-empty-lines) perf issue on large files (fixes [#7803](https://github.com/eslint/eslint/issues/7803)) ([#7843](https://github.com/eslint/eslint/issues/7843)) (Teddy Katz)
* [2322733](https://github.com/eslint/eslint/commit/2322733) Fix: Throw error if ruletester is missing required test scenarios ([#7388](https://github.com/eslint/eslint/issues/7388)) (Teddy Katz)
* [c5c3b21](https://github.com/eslint/eslint/commit/c5c3b21) Fix: [no-implied-eval](/docs/rules/no-implied-eval) false positive on 'setTimeoutFoo' (fixes [#7821](https://github.com/eslint/eslint/issues/7821)) ([#7836](https://github.com/eslint/eslint/issues/7836)) (Teddy Katz)
* [fd4cd3b](https://github.com/eslint/eslint/commit/fd4cd3b) Fix: Disable [no-var](/docs/rules/no-var) autofixer in some incorrect cases in loops ([#7811](https://github.com/eslint/eslint/issues/7811)) (Alan Pierce)
* [f20b9e9](https://github.com/eslint/eslint/commit/f20b9e9) Fix: Relax [no-useless-escape](/docs/rules/no-useless-escape)'s handling of ']' in regexes (fixes [#7789](https://github.com/eslint/eslint/issues/7789)) ([#7793](https://github.com/eslint/eslint/issues/7793)) (Teddy Katz)
* [3004c1e](https://github.com/eslint/eslint/commit/3004c1e) Fix: [consistent-return](/docs/rules/consistent-return) shouldn't report class constructors (fixes [#7790](https://github.com/eslint/eslint/issues/7790)) ([#7797](https://github.com/eslint/eslint/issues/7797)) (Teddy Katz)
* [428fbdf](https://github.com/eslint/eslint/commit/428fbdf) Fix: [func-call-spacing](/docs/rules/func-call-spacing) "never" doesn't fix w/ line breaks (fixes [#7787](https://github.com/eslint/eslint/issues/7787)) ([#7788](https://github.com/eslint/eslint/issues/7788)) (Kevin Partington)
* [6e61070](https://github.com/eslint/eslint/commit/6e61070) Fix: [`semi`](/docs/rules/semi) false positive before regex/template literals (fixes [#7782](https://github.com/eslint/eslint/issues/7782)) ([#7783](https://github.com/eslint/eslint/issues/7783)) (Teddy Katz)
* [ff0c050](https://github.com/eslint/eslint/commit/ff0c050) Fix: remove internal property from config generation (fixes [#7758](https://github.com/eslint/eslint/issues/7758)) ([#7761](https://github.com/eslint/eslint/issues/7761)) (alberto)
* [8c3a962](https://github.com/eslint/eslint/commit/8c3a962) Fix: syntax errors from [object-shorthand](/docs/rules/object-shorthand) autofix (fixes [#7744](https://github.com/eslint/eslint/issues/7744)) ([#7745](https://github.com/eslint/eslint/issues/7745)) (Teddy Katz)




## Documentation


* [fbafdc0](https://github.com/eslint/eslint/commit/fbafdc0) Docs: [`padded-blocks`](/docs/rules/padded-blocks) `never` case (fixes [#7868](https://github.com/eslint/eslint/issues/7868)) ([#7878](https://github.com/eslint/eslint/issues/7878)) (alberto)
* [bf45893](https://github.com/eslint/eslint/commit/bf45893) Docs: Clarify that we only support Stage 4 proposals ([#7845](https://github.com/eslint/eslint/issues/7845)) (Kevin Partington)
* [7122205](https://github.com/eslint/eslint/commit/7122205) Docs: Array destructuring example for [no-unused-vars](/docs/rules/no-unused-vars) (fixes [#7838](https://github.com/eslint/eslint/issues/7838)) ([#7839](https://github.com/eslint/eslint/issues/7839)) (Remco Haszing)
* [1f25834](https://github.com/eslint/eslint/commit/1f25834) Docs: update outdated info in Architecture page ([#7816](https://github.com/eslint/eslint/issues/7816)) (Teddy Katz)
* [b938f1f](https://github.com/eslint/eslint/commit/b938f1f) Docs: Add an example for the spread operator to [prefer-spread](/docs/rules/prefer-spread).md ([#7802](https://github.com/eslint/eslint/issues/7802)) ([#7804](https://github.com/eslint/eslint/issues/7804)) (butlermd)
* [b8ce2dc](https://github.com/eslint/eslint/commit/b8ce2dc) Docs: Remove .html extensions from links in developer-guide ([#7805](https://github.com/eslint/eslint/issues/7805)) (Kevin Partington)
* [aafebb2](https://github.com/eslint/eslint/commit/aafebb2) Docs: Wrap placeholder sample in raw ([#7798](https://github.com/eslint/eslint/issues/7798)) (Daniel Lo Nigro)
* [bb648ce](https://github.com/eslint/eslint/commit/bb648ce) Docs: fix unclear example for [no-useless-escape](/docs/rules/no-useless-escape) ([#7781](https://github.com/eslint/eslint/issues/7781)) (Teddy Katz)
* [8b296a2](https://github.com/eslint/eslint/commit/8b296a2) Docs: fix in [semi](/docs/rules/semi).md: correct instead of incorrect ([#7779](https://github.com/eslint/eslint/issues/7779)) (German Prostakov)




## Dependency Upgrades


* [3493241](https://github.com/eslint/eslint/commit/3493241) Upgrade: strip-json-comments ~v2.0.1 (Janus Troelsen)






## Chores


* [4008022](https://github.com/eslint/eslint/commit/4008022) Chore: Refactor to use ES6 Classes (Part 3)(refs [#7849](https://github.com/eslint/eslint/issues/7849)) ([#7865](https://github.com/eslint/eslint/issues/7865)) (Gyandeep Singh)
* [616611a](https://github.com/eslint/eslint/commit/616611a) Chore: Refactor to use ES6 Classes (Part 2)(refs [#7849](https://github.com/eslint/eslint/issues/7849)) ([#7847](https://github.com/eslint/eslint/issues/7847)) (Gyandeep Singh)
* [856084b](https://github.com/eslint/eslint/commit/856084b) Chore: Refactor to use ES6 Classes (Part 1)(refs [#7849](https://github.com/eslint/eslint/issues/7849)) ([#7846](https://github.com/eslint/eslint/issues/7846)) (Gyandeep Singh)
* [18fa521](https://github.com/eslint/eslint/commit/18fa521) Chore: use ast-utils helper functions in [no-multiple-empty-lines](/docs/rules/no-multiple-empty-lines) ([#7842](https://github.com/eslint/eslint/issues/7842)) (Teddy Katz)
* [e21b36b](https://github.com/eslint/eslint/commit/e21b36b) Chore: add integration tests for cache files (refs [#7748](https://github.com/eslint/eslint/issues/7748)) ([#7794](https://github.com/eslint/eslint/issues/7794)) (Teddy Katz)
* [00dd96c](https://github.com/eslint/eslint/commit/00dd96c) Chore: enable [array-bracket-spacing](/docs/rules/array-bracket-spacing) on ESLint codebase ([#7830](https://github.com/eslint/eslint/issues/7830)) (Teddy Katz)
* [bb6b73b](https://github.com/eslint/eslint/commit/bb6b73b) Chore: replace unnecessary function callbacks with arrow functions ([#7795](https://github.com/eslint/eslint/issues/7795)) (Teddy Katz)
* [75b7ba4](https://github.com/eslint/eslint/commit/75b7ba4) Chore: enable [object-curly-spacing](/docs/rules/object-curly-spacing) on ESLint codebase (refs [#7725](https://github.com/eslint/eslint/issues/7725)) ([#7770](https://github.com/eslint/eslint/issues/7770)) (Teddy Katz)
* [f1bf5ec](https://github.com/eslint/eslint/commit/f1bf5ec) Chore: convert remaining old-style context.report() calls to the new API ([#7763](https://github.com/eslint/eslint/issues/7763)) (Teddy Katz)
