---
layout: post
title: ESLint v3.12.0 released
teaser: "We just pushed ESLint v3.12.0, which is a minor release upgrade of ESLint. This release adds a new feature and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - kaicataldo
categories:
  - Release Notes
---

## Highlights

This is a summary of some of the notable changes in this version of ESLint.

### Additional APIs

This version includes the addition of three new API methods:

* `getRules` to `linter`
* `version` to `linter`
* `version` to `CLIEngine`

Apologies for the lack of clear documentation on the above - our API documentation needs an overhaul, and we plan on updating this in the near future.

### New option for `eslint --init`

This version adds the ability to pick the `airbnb-base` config without `eslint-plugin-react`, for those who want to follow the Airbnb styleguide but do not use React.

### New Rules

One new rule was added:

- [no-await-in-loop](/docs/rules/no-await-in-loop)

### Autofixing

Autofix support was added to the following rule:

- [capitalized-comments](/docs/rules/capitalized-comments)



## Features


* [1d0d61d](https://github.com/eslint/eslint/commit/1d0d61d) New: Add [no-await-in-loop](/docs/rules/no-await-in-loop) rule ([#7563](https://github.com/eslint/eslint/issues/7563)) (Nat Mote)
* [2cdfb4e](https://github.com/eslint/eslint/commit/2cdfb4e) New: Additional APIs (fixes [#6256](https://github.com/eslint/eslint/issues/6256)) ([#7669](https://github.com/eslint/eslint/issues/7669)) (Ilya Volodin)




## Enhancements


* [e569225](https://github.com/eslint/eslint/commit/e569225) Update: fix false positive/negative of [yoda](/docs/rules/yoda) rule (fixes [#7676](https://github.com/eslint/eslint/issues/7676)) ([#7695](https://github.com/eslint/eslint/issues/7695)) (Toru Nagashima)
* [4278c42](https://github.com/eslint/eslint/commit/4278c42) Update: make [no-obj-calls](/docs/rules/no-obj-calls) report errors for Reflect (fixes [#7700](https://github.com/eslint/eslint/issues/7700)) ([#7710](https://github.com/eslint/eslint/issues/7710)) (Tomas Echeverri Valencia)
* [b921d1f](https://github.com/eslint/eslint/commit/b921d1f) Update: add [`indent`](/docs/rules/indent) options for array and object literals (fixes [#7473](https://github.com/eslint/eslint/issues/7473)) ([#7681](https://github.com/eslint/eslint/issues/7681)) (Teddy Katz)
* [7079c89](https://github.com/eslint/eslint/commit/7079c89) Update: Add airbnb-base to init styleguides (fixes [#6986](https://github.com/eslint/eslint/issues/6986)) ([#7699](https://github.com/eslint/eslint/issues/7699)) (alberto)
* [f8786fb](https://github.com/eslint/eslint/commit/f8786fb) Update: add fixer for [`capitalized-comments`](/docs/rules/capitalized-comments) ([#7701](https://github.com/eslint/eslint/issues/7701)) (Teddy Katz)




## Bug Fixes


* [e95a230](https://github.com/eslint/eslint/commit/e95a230) Fix: [indent](/docs/rules/indent) "first" option false positive on nested arrays (fixes [#7727](https://github.com/eslint/eslint/issues/7727)) ([#7728](https://github.com/eslint/eslint/issues/7728)) (Teddy Katz)
* [81f9e7d](https://github.com/eslint/eslint/commit/81f9e7d) Fix: Allow duplicated let declarations in [`prefer-const`](/docs/rules/prefer-const) (fixes [#7712](https://github.com/eslint/eslint/issues/7712)) ([#7717](https://github.com/eslint/eslint/issues/7717)) (Teddy Katz)
* [abfd24f](https://github.com/eslint/eslint/commit/abfd24f) Fix: don't validate schemas for disabled rules (fixes [#7690](https://github.com/eslint/eslint/issues/7690)) ([#7692](https://github.com/eslint/eslint/issues/7692)) (Teddy Katz)
* [0a2a7fd](https://github.com/eslint/eslint/commit/0a2a7fd) Fix: Allow \u2028 and \u2029 as string escapes in [no-useless-escape](/docs/rules/no-useless-escape) ([#7672](https://github.com/eslint/eslint/issues/7672)) (Teddy Katz)




## Documentation


* [4742d82](https://github.com/eslint/eslint/commit/4742d82) Docs: clarify the default behavior of [`operator-linebreak`](/docs/rules/operator-linebreak) (fixes [#7459](https://github.com/eslint/eslint/issues/7459)) ([#7726](https://github.com/eslint/eslint/issues/7726)) (Teddy Katz)
* [63bb3f8](https://github.com/eslint/eslint/commit/63bb3f8) Docs: improve the documentation for the autofix API ([#7716](https://github.com/eslint/eslint/issues/7716)) (Teddy Katz)
* [90a5d29](https://github.com/eslint/eslint/commit/90a5d29) Docs: Remove incorrect info about issue requirements from PR guide ([#7691](https://github.com/eslint/eslint/issues/7691)) (Teddy Katz)
* [f80c278](https://github.com/eslint/eslint/commit/f80c278) Docs: Add sails-hook-lint to integrations list ([#7679](https://github.com/eslint/eslint/issues/7679)) (Anthony M)
* [e96da3f](https://github.com/eslint/eslint/commit/e96da3f) Docs: link first instance of `package.json` ([#7684](https://github.com/eslint/eslint/issues/7684)) (Kent C. Dodds)
* [b30116c](https://github.com/eslint/eslint/commit/b30116c) Docs: Fix code-blocks in [spaced-comment](/docs/rules/spaced-comment) docs ([#7524](https://github.com/eslint/eslint/issues/7524)) (Michał Gołębiowski)
* [76c33a9](https://github.com/eslint/eslint/commit/76c33a9) Docs: Change Sails.js integration to active npm package ([#7675](https://github.com/eslint/eslint/issues/7675)) (Anthony M)




## Dependency Upgrades


* [2ac07d8](https://github.com/eslint/eslint/commit/2ac07d8) Upgrade: Update globals dependency to 9.14.0 ([#7683](https://github.com/eslint/eslint/issues/7683)) (Aleksandr Oleynikov)




## Build Related


* [bf20e20](https://github.com/eslint/eslint/commit/bf20e20) Build: include links to rule pages in release blogpost ([#7671](https://github.com/eslint/eslint/issues/7671)) (Teddy Katz)




## Chores


* [a8489e2](https://github.com/eslint/eslint/commit/a8489e2) Chore: Avoid parserOptions boilerplate in tests for ES6 rules ([#7724](https://github.com/eslint/eslint/issues/7724)) (Teddy Katz)
