---
layout: post
title: ESLint v3.11.0 released
teaser: "We just pushed ESLint v3.11.0, which is a minor release upgrade of ESLint. This release adds a new feature and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - btmills
categories:
  - Release Notes
---

## Highlights

This is a summary of some of the notable changes in this version of ESLint.

### New Rules

Two new rules were added:

- [`capitalized-comments`](https://eslint.org/docs/rules/capitalized-comments)
- [`require-await`](https://eslint.org/docs/rules/require-await)

### More Autofixing

Autofix support was added to two rules:

- [`operator-assignment`](https://eslint.org/docs/rules/operator-assignment)
- [`sort-imports`](https://eslint.org/docs/rules/sort-imports)


## Features


* [ad56694](https://github.com/eslint/eslint/commit/ad56694) New: capitalized-comments rule (fixes [#6055](https://github.com/eslint/eslint/issues/6055)) ([#7415](https://github.com/eslint/eslint/issues/7415)) (Kevin Partington)
* [89bd8de](https://github.com/eslint/eslint/commit/89bd8de) New: `require-await` rule (fixes [#6820](https://github.com/eslint/eslint/issues/6820)) ([#7435](https://github.com/eslint/eslint/issues/7435)) (Toru Nagashima)




## Enhancements


* [7185567](https://github.com/eslint/eslint/commit/7185567) Update: add fixer for `operator-assignment` ([#7517](https://github.com/eslint/eslint/issues/7517)) (Teddy Katz)
* [faf5f56](https://github.com/eslint/eslint/commit/faf5f56) Update: fix false negative of `quotes` with \n in template (fixes [#7646](https://github.com/eslint/eslint/issues/7646)) ([#7647](https://github.com/eslint/eslint/issues/7647)) (Teddy Katz)
* [474e444](https://github.com/eslint/eslint/commit/474e444) Update: add fixer for `sort-imports` ([#7535](https://github.com/eslint/eslint/issues/7535)) (Teddy Katz)




## Bug Fixes


* [d50f6c1](https://github.com/eslint/eslint/commit/d50f6c1) Fix: incorrect location for `no-useless-escape` errors (fixes [#7643](https://github.com/eslint/eslint/issues/7643)) ([#7645](https://github.com/eslint/eslint/issues/7645)) (Teddy Katz)
* [5c9a4ad](https://github.com/eslint/eslint/commit/5c9a4ad) Fix: Prevent `quotes` from fixing templates to directives (fixes [#7610](https://github.com/eslint/eslint/issues/7610)) ([#7617](https://github.com/eslint/eslint/issues/7617)) (Teddy Katz)




## Documentation


* [f9b70b3](https://github.com/eslint/eslint/commit/f9b70b3) Docs: Enable example highlighting in rules examples (ref [#6444](https://github.com/eslint/eslint/issues/6444)) ([#7644](https://github.com/eslint/eslint/issues/7644)) (Alex Guerrero)
* [54a993c](https://github.com/eslint/eslint/commit/54a993c) Docs: Fix a typo in the require-yield.md ([#7652](https://github.com/eslint/eslint/issues/7652)) (Vse Mozhet Byt)
* [32a3547](https://github.com/eslint/eslint/commit/32a3547) Docs: Add absent quotes in rules documentation ([#7625](https://github.com/eslint/eslint/issues/7625)) (Denis Sikuler)
* [07124d1](https://github.com/eslint/eslint/commit/07124d1) Docs: add missing quote mark (+=" → "+=") ([#7613](https://github.com/eslint/eslint/issues/7613)) (Sean Juarez)
* [8998043](https://github.com/eslint/eslint/commit/8998043) Docs: fix wording in docs for no-extra-parens config (Michael Ficarra)




## Dependency Upgrades


* [d90ca46](https://github.com/eslint/eslint/commit/d90ca46) Upgrade: Update markdownlint dependency to 0.3.1 (fixes [#7589](https://github.com/eslint/eslint/issues/7589)) ([#7592](https://github.com/eslint/eslint/issues/7592)) (David Anson)






## Chores


* [eadd808](https://github.com/eslint/eslint/commit/eadd808) Chore: Fix prefer-arrow-callback lint errors ([#7651](https://github.com/eslint/eslint/issues/7651)) (Kevin Partington)
* [b7432bd](https://github.com/eslint/eslint/commit/b7432bd) Chore: Ensure JS files are checked out with LF ([#7624](https://github.com/eslint/eslint/issues/7624)) (Kevin Partington)
