---
layout: post
title: ESLint v3.10.0 released
teaser: "We just pushed ESLint v3.10.0, which is a minor release upgrade of ESLint. This release adds a new feature and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - btmills
categories:
  - Release Notes
---

## Highlights

This is a summary of some of the notable changes in this version of ESLint.

- One new rule, [`no-return-await`](https://eslint.org/docs/rules/no-return-await), was added.
- [`no-extra-boolean-cast`](https://eslint.org/docs/rules/no-extra-boolean-cast) gained auto-fix functionality.
- Certain cases caught by [`eqeqeq`](https://eslint.org/docs/rules/eqeqeq) can now be auto-fixed.
- New options were added to [`comma-style`](https://eslint.org/docs/rules/comma-style) to check function parameters, function arguments, imports, and destructuring.
- [`func-names`](https://eslint.org/docs/rules/func-names) gained a new option to recognize ES6 inferred names.



## Features


* [66fe9ff](https://github.com/eslint/eslint/commit/66fe9ff) New: `no-return-await` rule. (fixes [#7537](https://github.com/eslint/eslint/issues/7537)) ([#7547](https://github.com/eslint/eslint/issues/7547)) (Jordan Harband)




## Enhancements


* [7ee039b](https://github.com/eslint/eslint/commit/7ee039b) Update: Add comma-style options for calls, fns, imports (fixes [#7470](https://github.com/eslint/eslint/issues/7470)) (Max Englander)
* [c3f4809](https://github.com/eslint/eslint/commit/c3f4809) Update: Allow `func-names` to recognize inferred ES6 names (fixes [#7235](https://github.com/eslint/eslint/issues/7235)) ([#7244](https://github.com/eslint/eslint/issues/7244)) (Logan Smyth)
* [2bd1dd7](https://github.com/eslint/eslint/commit/2bd1dd7) Update: avoid creating extra whitespace in `arrow-body-style` fixer ([#7504](https://github.com/eslint/eslint/issues/7504)) (Teddy Katz)
* [5003b1c](https://github.com/eslint/eslint/commit/5003b1c) Update: fix in/instanceof handling with `space-infix-ops` (fixes [#7525](https://github.com/eslint/eslint/issues/7525)) ([#7552](https://github.com/eslint/eslint/issues/7552)) (Teddy Katz)
* [1766524](https://github.com/eslint/eslint/commit/1766524) Update: "Error type should be" assertion in rule-tester (fixes 6106) ([#7550](https://github.com/eslint/eslint/issues/7550)) (Frans Jaspers)
* [3c379ff](https://github.com/eslint/eslint/commit/3c379ff) Update: `no-restricted-{imports,modules}`: add “patterns” (fixes [#6963](https://github.com/eslint/eslint/issues/6963)) ([#7433](https://github.com/eslint/eslint/issues/7433)) (Jordan Harband)
* [af1fde1](https://github.com/eslint/eslint/commit/af1fde1) Update: fix `brace-style` false negative on multiline node (fixes [#7493](https://github.com/eslint/eslint/issues/7493)) ([#7496](https://github.com/eslint/eslint/issues/7496)) (Teddy Katz)
* [3798aea](https://github.com/eslint/eslint/commit/3798aea) Update: max-statements to report function name (refs [#7260](https://github.com/eslint/eslint/issues/7260)) ([#7399](https://github.com/eslint/eslint/issues/7399)) (Nicholas C. Zakas)
* [0c215fa](https://github.com/eslint/eslint/commit/0c215fa) Update: Add `ArrowFunctionExpression` support to `require-jsdoc` rule ([#7518](https://github.com/eslint/eslint/issues/7518)) (Gyandeep Singh)
* [8a3e717](https://github.com/eslint/eslint/commit/8a3e717) Update: Fix `lines-around-directive` semicolon handling (fixes [#7450](https://github.com/eslint/eslint/issues/7450)) ([#7483](https://github.com/eslint/eslint/issues/7483)) (Teddy Katz)
* [e58cead](https://github.com/eslint/eslint/commit/e58cead) Update: add a fixer for certain statically-verifiable `eqeqeq` cases ([#7389](https://github.com/eslint/eslint/issues/7389)) (Teddy Katz)
* [36338f0](https://github.com/eslint/eslint/commit/36338f0) Update: add fixer for `no-extra-boolean-cast` ([#7387](https://github.com/eslint/eslint/issues/7387)) (Teddy Katz)




## Bug Fixes


* [b8d6e48](https://github.com/eslint/eslint/commit/b8d6e48) Fix: syntax errors created by `object-shorthand` autofix (fixes [#7574](https://github.com/eslint/eslint/issues/7574)) ([#7575](https://github.com/eslint/eslint/issues/7575)) (Teddy Katz)
* [0d60db7](https://github.com/eslint/eslint/commit/0d60db7) Fix: Curly rule doesn't account for leading comment (fixes [#7538](https://github.com/eslint/eslint/issues/7538)) ([#7539](https://github.com/eslint/eslint/issues/7539)) (Will Chen)
* [c0f4937](https://github.com/eslint/eslint/commit/c0f4937) Fix: `arrow-parens` supports type annotations (fixes [#7406](https://github.com/eslint/eslint/issues/7406)) ([#7436](https://github.com/eslint/eslint/issues/7436)) (Toru Nagashima)
* [4613ba0](https://github.com/eslint/eslint/commit/4613ba0) Fix: Add support for escape char in JSX. ([#7461](https://github.com/eslint/eslint/issues/7461)) (Scott Stern)
* [ea0970d](https://github.com/eslint/eslint/commit/ea0970d) Fix: `curly` false positive with no-semicolon style ([#7509](https://github.com/eslint/eslint/issues/7509)) (Teddy Katz)




## Documentation


* [3e6131e](https://github.com/eslint/eslint/commit/3e6131e) Docs: explain config option merging ([#7499](https://github.com/eslint/eslint/issues/7499)) (Danny Andrews)
* [44eb274](https://github.com/eslint/eslint/commit/44eb274) Docs: Missing semicolon report was missing a comma ([#7553](https://github.com/eslint/eslint/issues/7553)) (James)
* [6dbda15](https://github.com/eslint/eslint/commit/6dbda15) Docs: Document the optional defaults argument for RuleTester ([#7548](https://github.com/eslint/eslint/issues/7548)) (Teddy Katz)
* [e117b80](https://github.com/eslint/eslint/commit/e117b80) Docs: typo fix ([#7546](https://github.com/eslint/eslint/issues/7546)) (oprogramador)
* [a838b8e](https://github.com/eslint/eslint/commit/a838b8e) Docs: `func-name-matching`: update with “always”/“never” option ([#7536](https://github.com/eslint/eslint/issues/7536)) (Jordan Harband)
* [f5764ee](https://github.com/eslint/eslint/commit/f5764ee) Docs: Update example of results returned from `executeOnFiles` ([#7362](https://github.com/eslint/eslint/issues/7362)) (Simen Bekkhus)
* [a7f3976](https://github.com/eslint/eslint/commit/a7f3976) Docs: Specify min ESLint version for new rule format ([#7501](https://github.com/eslint/eslint/issues/7501)) (cowchimp)
* [4f1fa67](https://github.com/eslint/eslint/commit/4f1fa67) Docs: Update copyright ([#7497](https://github.com/eslint/eslint/issues/7497)) (Nicholas C. Zakas)






## Build Related


* [578c373](https://github.com/eslint/eslint/commit/578c373) Build: handle deprecated rules with no 'replacedBy' (refs [#7471](https://github.com/eslint/eslint/issues/7471)) ([#7494](https://github.com/eslint/eslint/issues/7494)) (Vitor Balocco)




## Chores


* [670e060](https://github.com/eslint/eslint/commit/670e060) Chore: make the `object-shorthand` tests more readable ([#7580](https://github.com/eslint/eslint/issues/7580)) (Teddy Katz)
* [1b3b65c](https://github.com/eslint/eslint/commit/1b3b65c) Chore: ensure that files in tests/conf are linted ([#7579](https://github.com/eslint/eslint/issues/7579)) (Teddy Katz)
* [759525e](https://github.com/eslint/eslint/commit/759525e) Chore: Use process.exitCode instead of process.exit() in bin/eslint.js ([#7569](https://github.com/eslint/eslint/issues/7569)) (Teddy Katz)
* [25e5613](https://github.com/eslint/eslint/commit/25e5613) Chore: Remove incorrect test from indent.js. ([#7531](https://github.com/eslint/eslint/issues/7531)) (Scott Stern)
* [0dea0ac](https://github.com/eslint/eslint/commit/0dea0ac) Chore: Add Node 7 to travis ci build ([#7506](https://github.com/eslint/eslint/issues/7506)) (Gyandeep Singh)
* [183def6](https://github.com/eslint/eslint/commit/183def6) Chore: enable `prefer-arrow-callback` on ESLint codebase (fixes [#6407](https://github.com/eslint/eslint/issues/6407)) ([#7503](https://github.com/eslint/eslint/issues/7503)) (Teddy Katz)
