---
layout: post
title: ESLint v3.9.0 released
teaser: "We just pushed ESLint v3.9.0, which is a minor release upgrade of ESLint. This release adds a new feature and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - kaicataldo
categories:
  - Release Notes
---

## Highlights

This release includes some exciting new features, including a new results formatter and the ability for ESLint to support enhanced parsers!


### New formatter
As part of our continuing effort to support our users coming from JSCS, we're excited to release the new [codeframe](https://eslint.org/docs/user-guide/formatters/#codeframe) formatter!

```
error: Missing semicolon (semi) at file.js:1:13:
> 1 | var a = true
    |             ^
  2 |
  3 |


warning: There should be no space after '{' (object-curly-spacing) at file2.js:1:9:
> 1 | var b = { c: true};
    |         ^
  2 |
  3 |


1 error and 1 warning found.
```

### Enhanced parsers
ESLint now supports enhanced parsers, which allows parsers to provide ESLint-specific services and functionality. This allows ESLint to support added functionality such as parsing type checkers.


### New Rules

- [no-useless-return](https://eslint.org/docs/rules/no-useless-return)


### New Rule Options

- [func-name-matching](https://eslint.org/docs/rules/func-name-matching): `nameMatches`
- [indent](https://eslint.org/docs/rules/indent): `CallExpression`
- [max-len](https://eslint.org/docs/rules/max-len): `ignoreRegExpLiterals`


### New autofixing

- [arrow-body-style](https://eslint.org/docs/rules/arrow-body-style)
- [brace-style](https://eslint.org/docs/rules/brace-style)
- [newline-after-var](https://eslint.org/docs/rules/newline-after-var)

### Deprecated rules
With this release we deprecated [prefer-reflect](https://eslint.org/docs/rules/prefer-reflect) rule. The original intent of this rule now seems misguided as we have come to understand that Reflect methods are not actually intended to replace the `Object` counterparts the rule suggests, but rather exist as low-level primitives to be used with proxies in order to replicate the default behavior of various previously existing functionality. This rule will not be replaced.


## Features
* [e46666b](https://github.com/eslint/eslint/commit/e46666b) New: Codeframe formatter (fixes [#5860](https://github.com/eslint/eslint/issues/5860)) ([#7437](https://github.com/eslint/eslint/issues/7437)) (Vitor Balocco)
* [d933516](https://github.com/eslint/eslint/commit/d933516) New: `no-useless-return` rule (fixes [#7309](https://github.com/eslint/eslint/issues/7309)) ([#7441](https://github.com/eslint/eslint/issues/7441)) (Toru Nagashima)
* [cbbe420](https://github.com/eslint/eslint/commit/cbbe420) New: Support enhanced parsers (fixes [#6974](https://github.com/eslint/eslint/issues/6974)) ([#6975](https://github.com/eslint/eslint/issues/6975)) (Nicholas C. Zakas)


## Enhancements
* [644d25b](https://github.com/eslint/eslint/commit/644d25b) Update: Add an ignoreRegExpLiterals option to max-len (fixes [#3229](https://github.com/eslint/eslint/issues/3229)) ([#7346](https://github.com/eslint/eslint/issues/7346)) (Wilfred Hughes)
* [5e7af30](https://github.com/eslint/eslint/commit/5e7af30) Update: Add `CallExpression` option for `indent` (fixes [#5946](https://github.com/eslint/eslint/issues/5946)) ([#7189](https://github.com/eslint/eslint/issues/7189)) (Teddy Katz)
* [e064a25](https://github.com/eslint/eslint/commit/e064a25) Update: add fixer for `arrow-body-style` ([#7240](https://github.com/eslint/eslint/issues/7240)) (Teddy Katz)
* [e0fe727](https://github.com/eslint/eslint/commit/e0fe727) Update: add fixer for `brace-style` (fixes [#7074](https://github.com/eslint/eslint/issues/7074)) ([#7347](https://github.com/eslint/eslint/issues/7347)) (Teddy Katz)
* [ee3bcea](https://github.com/eslint/eslint/commit/ee3bcea) Update: add fixer for `newline-after-var` (fixes [#5959](https://github.com/eslint/eslint/issues/5959)) ([#7375](https://github.com/eslint/eslint/issues/7375)) (Teddy Katz)
* [5ed8b9b](https://github.com/eslint/eslint/commit/5ed8b9b) Update: Deprecate prefer-reflect (fixes [#7226](https://github.com/eslint/eslint/issues/7226)) ([#7464](https://github.com/eslint/eslint/issues/7464)) (Kai Cataldo)
* [3813988](https://github.com/eslint/eslint/commit/3813988) Update: fix false negative of `no-extra-parens` (fixes [#7122](https://github.com/eslint/eslint/issues/7122)) ([#7432](https://github.com/eslint/eslint/issues/7432)) (Toru Nagashima)
* [c675d7d](https://github.com/eslint/eslint/commit/c675d7d) Update: Fix `no-useless-escape` false negative in regexes (fixes [#7424](https://github.com/eslint/eslint/issues/7424)) ([#7425](https://github.com/eslint/eslint/issues/7425)) (Teddy Katz)
* [1d5146f](https://github.com/eslint/eslint/commit/1d5146f) Update: fix wrong indentation about `catch`,`finally` ([#7371](https://github.com/eslint/eslint/issues/7371)) (Toru Nagashima)
* [d257428](https://github.com/eslint/eslint/commit/d257428) Update: `func-name-matching`: add “always”/“never” option (fixes [#7391](https://github.com/eslint/eslint/issues/7391)) ([#7428](https://github.com/eslint/eslint/issues/7428)) (Jordan Harband)


## Bug Fixes
* [8dfd802](https://github.com/eslint/eslint/commit/8dfd802) Fix: avoid `camelcase` false positive with NewExpressions (fixes [#7363](https://github.com/eslint/eslint/issues/7363)) ([#7409](https://github.com/eslint/eslint/issues/7409)) (Teddy Katz)
* [6e9ff08](https://github.com/eslint/eslint/commit/6e9ff08) Fix: indent.js to support multiline array statements. ([#7237](https://github.com/eslint/eslint/issues/7237)) (Scott Stern)
* [16367a8](https://github.com/eslint/eslint/commit/16367a8) Fix: Return statement spacing. Fix for indent rule. (fixes [#7164](https://github.com/eslint/eslint/issues/7164)) ([#7197](https://github.com/eslint/eslint/issues/7197)) (Imad Elyafi)
* [c710584](https://github.com/eslint/eslint/commit/c710584) Fix: support for MemberExpression with function body. ([#7400](https://github.com/eslint/eslint/issues/7400)) (Scott Stern)
* [b200086](https://github.com/eslint/eslint/commit/b200086) Fix: Support type annotations in array-bracket-spacing ([#7445](https://github.com/eslint/eslint/issues/7445)) (Jimmy Jia)


## Documentation
* [85d7e24](https://github.com/eslint/eslint/commit/85d7e24) Docs: add additional examples for MemberExpressions in Indent rule. ([#7408](https://github.com/eslint/eslint/issues/7408)) (Scott Stern)
* [e8159b4](https://github.com/eslint/eslint/commit/e8159b4) Docs: Fix typo and explain static func calls for class-methods-use-this ([#7421](https://github.com/eslint/eslint/issues/7421)) (Scott O'Hara)
* [23062e2](https://github.com/eslint/eslint/commit/23062e2) Docs: Fix typo in no-unexpected-multiline (fixes [#7442](https://github.com/eslint/eslint/issues/7442)) ([#7447](https://github.com/eslint/eslint/issues/7447)) (Denis Sikuler)
* [2aa1107](https://github.com/eslint/eslint/commit/2aa1107) Docs: Include note on fatal: true in the node.js api section ([#7376](https://github.com/eslint/eslint/issues/7376)) (Simen Bekkhus)
* [6875576](https://github.com/eslint/eslint/commit/6875576) Docs: Remove broken links to jslinterrors.com (fixes [#7368](https://github.com/eslint/eslint/issues/7368)) ([#7369](https://github.com/eslint/eslint/issues/7369)) (Dannii Willis)


## Build
* [f8153ad](https://github.com/eslint/eslint/commit/f8153ad) Build: Ensure absolute links in docs retain .md extensions (fixes [#7419](https://github.com/eslint/eslint/issues/7419)) ([#7438](https://github.com/eslint/eslint/issues/7438)) (Teddy Katz)
* [2c8ed2d](https://github.com/eslint/eslint/commit/2c8ed2d) Build: ensure that all files are linted on bash (fixes [#7426](https://github.com/eslint/eslint/issues/7426)) ([#7427](https://github.com/eslint/eslint/issues/7427)) (Teddy Katz)


## Chores
* [18ff70f](https://github.com/eslint/eslint/commit/18ff70f) Chore: Enable `no-useless-escape` ([#7403](https://github.com/eslint/eslint/issues/7403)) (Vitor Balocco)
* [77e3a34](https://github.com/eslint/eslint/commit/77e3a34) Chore: Pin mock-fs dev dependency ([#7466](https://github.com/eslint/eslint/issues/7466)) (Gyandeep Singh)
* [92ad43b](https://github.com/eslint/eslint/commit/92ad43b) Chore: Update deprecated rules in conf/eslint.json ([#7467](https://github.com/eslint/eslint/issues/7467)) (Kai Cataldo)


## Upgrades
* [fe0d903](https://github.com/eslint/eslint/commit/fe0d903) Upgrade: Shelljs to ^0.7.5 (fixes [#7316](https://github.com/eslint/eslint/issues/7316)) ([#7465](https://github.com/eslint/eslint/issues/7465)) (Gyandeep Singh)
