---
layout: post
title: ESLint v3.8.0 released
teaser: "We just pushed ESLint v3.8.0, which is a minor release upgrade of ESLint. This release adds a new feature and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - mysticatea
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Additional Property on Linting Results

If you're using the ESLint [Node.js API](https://eslint.org/docs/developer-guide/nodejs-api) or writing a custom formatter, you'll find that result object for each file now has a `source` property. This property contains the original source code from the file, allowing formatters to output contextual information along with linting error messages. This new `source` property on the file results object is intended to replace the `source` property on the lint message object, which will be removed in a later release. If you have a custom formatter making use of the `source` property on the lint message object, we recommend updating your formatter to check for the existence of the `source` property on the file results object and to use it if found. See the [documentation](https://eslint.org/docs/developer-guide/working-with-custom-formatters#description-of-the-results) for more information.

### New Rules

- [func-name-matching]

### New Options

- [comma-dangle] ... `arrays`, `objects`, `imports`, `exports`, and `functions`.
- [space-before-function-paren] ... `asyncArrow`
- [wrap-iife] ... `functionPrototypeMethods`

### New autofixing

- [curly]
- [no-lonely-if]
- [no-extra-bind]
- [one-var-declaration-per-line]
- [prefer-spread]


[comma-dangle]: https://eslint.org/docs/rules/comma-dangle
[curly]: https://eslint.org/docs/rules/curly
[func-name-matching]: https://eslint.org/docs/rules/func-name-matching
[no-extra-bind]: https://eslint.org/docs/rules/no-extra-bind
[no-lonely-if]: https://eslint.org/docs/rules/no-lonely-if
[one-var-declaration-per-line]: https://eslint.org/docs/rules/one-var-declaration-per-line
[prefer-spread]: https://eslint.org/docs/rules/prefer-spread
[space-before-function-paren]: https://eslint.org/docs/rules/space-before-function-paren
[wrap-iife]: https://eslint.org/docs/rules/wrap-iife



## Features


* [cd72bba](https://github.com/eslint/eslint/commit/cd72bba) New: `func-name-matching` rule (fixes [#6065](https://github.com/eslint/eslint/issues/6065)) ([#7063](https://github.com/eslint/eslint/issues/7063)) (Annie Zhang)




## Enhancements


* [c8796e9](https://github.com/eslint/eslint/commit/c8796e9) Update: `comma-dangle` supports trailing function commas (refs [#7101](https://github.com/eslint/eslint/issues/7101)) ([#7181](https://github.com/eslint/eslint/issues/7181)) (Toru Nagashima)
* [c4abaf0](https://github.com/eslint/eslint/commit/c4abaf0) Update: `space-before-function-paren` supports async/await (refs [#7101](https://github.com/eslint/eslint/issues/7101)) ([#7180](https://github.com/eslint/eslint/issues/7180)) (Toru Nagashima)
* [5266793](https://github.com/eslint/eslint/commit/5266793) Update: no-useless-escape checks template literals (fixes [#7331](https://github.com/eslint/eslint/issues/7331)) ([#7332](https://github.com/eslint/eslint/issues/7332)) (Kai Cataldo)
* [b08fb91](https://github.com/eslint/eslint/commit/b08fb91) Update: add source property to LintResult object (fixes [#7098](https://github.com/eslint/eslint/issues/7098)) ([#7304](https://github.com/eslint/eslint/issues/7304)) (Vitor Balocco)
* [c1470b5](https://github.com/eslint/eslint/commit/c1470b5) Update: Make the `prefer-template` fixer unescape quotes (fixes [#7330](https://github.com/eslint/eslint/issues/7330)) ([#7334](https://github.com/eslint/eslint/issues/7334)) (Teddy Katz)
* [f8387c1](https://github.com/eslint/eslint/commit/f8387c1) Update: add fixer for `prefer-spread` ([#7283](https://github.com/eslint/eslint/issues/7283)) (Teddy Katz)
* [52dfce5](https://github.com/eslint/eslint/commit/52dfce5) Update: add fixer for `one-var-declaration-per-line` ([#7295](https://github.com/eslint/eslint/issues/7295)) (Teddy Katz)
* [0e994ae](https://github.com/eslint/eslint/commit/0e994ae) Update: Improve the error messages for `no-unused-vars` (fixes [#7282](https://github.com/eslint/eslint/issues/7282)) ([#7315](https://github.com/eslint/eslint/issues/7315)) (Teddy Katz)
* [72f394d](https://github.com/eslint/eslint/commit/72f394d) Update: Fix false negative of `no-multiple-empty-lines` (fixes [#7312](https://github.com/eslint/eslint/issues/7312)) ([#7313](https://github.com/eslint/eslint/issues/7313)) (Teddy Katz)
* [756bc5a](https://github.com/eslint/eslint/commit/756bc5a) Update: Use characters instead of code units for `max-len` ([#7299](https://github.com/eslint/eslint/issues/7299)) (Teddy Katz)
* [a12d1a9](https://github.com/eslint/eslint/commit/a12d1a9) Update: add fixer for `no-lonely-if` ([#7202](https://github.com/eslint/eslint/issues/7202)) (Teddy Katz)
* [2ffe516](https://github.com/eslint/eslint/commit/2ffe516) Update: add fixer for `curly` ([#7105](https://github.com/eslint/eslint/issues/7105)) (Teddy Katz)
* [ac3504d](https://github.com/eslint/eslint/commit/ac3504d) Update: add functionPrototypeMethods to wrap-iife (fixes [#7212](https://github.com/eslint/eslint/issues/7212)) ([#7284](https://github.com/eslint/eslint/issues/7284)) (Eli White)
* [5e16fb4](https://github.com/eslint/eslint/commit/5e16fb4) Update: add fixer for `no-extra-bind` ([#7236](https://github.com/eslint/eslint/issues/7236)) (Teddy Katz)




## Bug Fixes


* [d0d3b28](https://github.com/eslint/eslint/commit/d0d3b28) Fix: id-length rule incorrectly firing on member access (fixes [#6475](https://github.com/eslint/eslint/issues/6475)) ([#7365](https://github.com/eslint/eslint/issues/7365)) (Burak Yiğit Kaya)
* [2729d94](https://github.com/eslint/eslint/commit/2729d94) Fix: Don't report setter params in class bodies as unused (fixes [#7351](https://github.com/eslint/eslint/issues/7351)) ([#7352](https://github.com/eslint/eslint/issues/7352)) (Teddy Katz)
* [5d08c33](https://github.com/eslint/eslint/commit/5d08c33) Fix: Handle parentheses correctly in `yoda` fixer (fixes [#7326](https://github.com/eslint/eslint/issues/7326)) ([#7327](https://github.com/eslint/eslint/issues/7327)) (Teddy Katz)
* [55b5146](https://github.com/eslint/eslint/commit/55b5146) Fix: `RuleTester` didn't support `mocha --watch` ([#7287](https://github.com/eslint/eslint/issues/7287)) (Toru Nagashima)
* [52da71e](https://github.com/eslint/eslint/commit/52da71e) Fix: Don't require commas after rest properties (fixes [#7297](https://github.com/eslint/eslint/issues/7297)) ([#7298](https://github.com/eslint/eslint/issues/7298)) (Teddy Katz)
* [c9a7ec5](https://github.com/eslint/eslint/commit/c9a7ec5) Fix: Improving optionator configuration for --print-config ([#7206](https://github.com/eslint/eslint/issues/7206)) (Kevin Partington)
* [51bfade](https://github.com/eslint/eslint/commit/51bfade) Fix: avoid `object-shorthand` crash with spread properties (fixes [#7305](https://github.com/eslint/eslint/issues/7305)) ([#7306](https://github.com/eslint/eslint/issues/7306)) (Teddy Katz)
* [1418384](https://github.com/eslint/eslint/commit/1418384) Fix: Don't require semicolons before `++`/`--` ([#7252](https://github.com/eslint/eslint/issues/7252)) (Adrian Heine né Lang)




## Documentation


* [d840afe](https://github.com/eslint/eslint/commit/d840afe) Docs: remove broken link from no-loop-func doc ([#7342](https://github.com/eslint/eslint/issues/7342)) (Michael McDermott)
* [16d495d](https://github.com/eslint/eslint/commit/16d495d) Docs: Updating CLI overview with latest changes ([#7335](https://github.com/eslint/eslint/issues/7335)) (Kevin Partington)








## Chores


* [ee60acf](https://github.com/eslint/eslint/commit/ee60acf) Chore: add integration tests for autofixing (fixes [#5909](https://github.com/eslint/eslint/issues/5909)) ([#7349](https://github.com/eslint/eslint/issues/7349)) (Teddy Katz)
* [0b85004](https://github.com/eslint/eslint/commit/0b85004) Chore: Enable prefer-template (fixes [#6407](https://github.com/eslint/eslint/issues/6407)) ([#7357](https://github.com/eslint/eslint/issues/7357)) (Kai Cataldo)
* [ca1947b](https://github.com/eslint/eslint/commit/ca1947b) Chore: Update pull request template (refs eslint/tsc-meetings[#20](https://github.com/eslint/eslint/issues/20)) ([#7359](https://github.com/eslint/eslint/issues/7359)) (Brandon Mills)
* [0db4164](https://github.com/eslint/eslint/commit/0db4164) Chore: run prefer-template autofixer on test files (refs [#6407](https://github.com/eslint/eslint/issues/6407)) ([#7354](https://github.com/eslint/eslint/issues/7354)) (Kai Cataldo)
* [3b11d3f](https://github.com/eslint/eslint/commit/3b11d3f) Chore: refactor `no-multiple-empty-lines` ([#7314](https://github.com/eslint/eslint/issues/7314)) (Teddy Katz)
* [93214aa](https://github.com/eslint/eslint/commit/93214aa) Chore: Convert non-lib/test files to template literals (refs [#6407](https://github.com/eslint/eslint/issues/6407)) ([#7329](https://github.com/eslint/eslint/issues/7329)) (Kai Cataldo)
