---
layout: post
title: ESLint v3.7.0 released
teaser: "We just pushed ESLint v3.7.0, which is a minor release upgrade of ESLint. This release adds a new feature and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - kaicataldo
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint. Though it's a smaller release, it does include the ability to autofix a number of rules!

### Autofixing

In addition to linting code, many of the rules can automatically fix errors using the `--fix` flag. This can be a huge time saver for developers using ESLint on a pre-existing codebase! The following rules can now be autofixed:

* [prefer-numeric-literals](https://eslint.org/docs/rules/prefer-numeric-literals)
* [no-undef-init](https://eslint.org/docs/rules/no-undef-init)
* [no-useless-computed-key](https://eslint.org/docs/rules/no-useless-computed-key)
* [lines-around-directive](https://eslint.org/docs/rules/lines-around-directive)
* [wrap-iife](https://eslint.org/docs/rules/wrap-iife)
* [dot-location](https://eslint.org/docs/rules/dot-location)
* [yoda](https://eslint.org/docs/rules/yoda)
* [no-extra-parens](https://eslint.org/docs/rules/no-extra-parens)



## Enhancements


* [c05a19c](https://github.com/eslint/eslint/commit/c05a19c) Update: add fixer for `prefer-numeric-literals` ([#7205](https://github.com/eslint/eslint/issues/7205)) (Teddy Katz)
* [2f171f3](https://github.com/eslint/eslint/commit/2f171f3) Update: add fixer for `no-undef-init` ([#7210](https://github.com/eslint/eslint/issues/7210)) (Teddy Katz)
* [332d213](https://github.com/eslint/eslint/commit/332d213) Update: Ensure `indent` handles nested functions correctly (fixes [#7249](https://github.com/eslint/eslint/issues/7249)) ([#7265](https://github.com/eslint/eslint/issues/7265)) (Teddy Katz)
* [c36d842](https://github.com/eslint/eslint/commit/c36d842) Update: add fixer for `no-useless-computed-key` ([#7207](https://github.com/eslint/eslint/issues/7207)) (Teddy Katz)
* [18376cf](https://github.com/eslint/eslint/commit/18376cf) Update: add fixer for `lines-around-directive` ([#7217](https://github.com/eslint/eslint/issues/7217)) (Teddy Katz)
* [f8e8fab](https://github.com/eslint/eslint/commit/f8e8fab) Update: add fixer for `wrap-iife` ([#7196](https://github.com/eslint/eslint/issues/7196)) (Teddy Katz)
* [cd1dc57](https://github.com/eslint/eslint/commit/cd1dc57) Update: Add a fixer for `dot-location` ([#7186](https://github.com/eslint/eslint/issues/7186)) (Teddy Katz)
* [89787b2](https://github.com/eslint/eslint/commit/89787b2) Update: for `yoda`, add a fixer ([#7199](https://github.com/eslint/eslint/issues/7199)) (Teddy Katz)
* [e3f95de](https://github.com/eslint/eslint/commit/e3f95de) Update: Fix `no-extra-parens` false negative (fixes [#7229](https://github.com/eslint/eslint/issues/7229)) ([#7231](https://github.com/eslint/eslint/issues/7231)) (Teddy Katz)




## Bug Fixes


* [2fee8ad](https://github.com/eslint/eslint/commit/2fee8ad) Fix: object-shorthand's consistent-as-needed option (issue [#7214](https://github.com/eslint/eslint/issues/7214)) ([#7215](https://github.com/eslint/eslint/issues/7215)) (Naomi Jacobs)
* [dffb4fa](https://github.com/eslint/eslint/commit/dffb4fa) Fix: `no-unused-vars` false positive (fixes [#7250](https://github.com/eslint/eslint/issues/7250)) ([#7258](https://github.com/eslint/eslint/issues/7258)) (Toru Nagashima)
* [742ae67](https://github.com/eslint/eslint/commit/742ae67) Fix: avoid indent and no-mixed-spaces-and-tabs conflicts (fixes [#7248](https://github.com/eslint/eslint/issues/7248)) ([#7266](https://github.com/eslint/eslint/issues/7266)) (Teddy Katz)
* [85b8714](https://github.com/eslint/eslint/commit/85b8714) Fix: Use error templates even when reading from stdin (fixes [#7213](https://github.com/eslint/eslint/issues/7213)) ([#7223](https://github.com/eslint/eslint/issues/7223)) (Teddy Katz)




## Documentation


* [876d747](https://github.com/eslint/eslint/commit/876d747) Docs: Steps for adding new committers/TSCers ([#7221](https://github.com/eslint/eslint/issues/7221)) (Nicholas C. Zakas)
* [4448cec](https://github.com/eslint/eslint/commit/4448cec) Docs: Adding missing ES8 reference to configuring ([#7271](https://github.com/eslint/eslint/issues/7271)) (Kevin Partington)
* [558b444](https://github.com/eslint/eslint/commit/558b444) Docs: Add @not-an-aardvark to development team ([#7279](https://github.com/eslint/eslint/issues/7279)) (Ilya Volodin)
* [66adac1](https://github.com/eslint/eslint/commit/66adac1) Docs: correction in prefer-reflect docs (fixes [#7069](https://github.com/eslint/eslint/issues/7069)) ([#7150](https://github.com/eslint/eslint/issues/7150)) (Scott Stern)
* [2909c19](https://github.com/eslint/eslint/commit/2909c19) Docs: Fix typo in object-shorthand docs ([#7267](https://github.com/eslint/eslint/issues/7267)) (Brian Donovan)
* [722c68c](https://github.com/eslint/eslint/commit/722c68c) Docs: add code fences to the issue template ([#7254](https://github.com/eslint/eslint/issues/7254)) (Teddy Katz)








## Chores


* [7bb800d](https://github.com/eslint/eslint/commit/7bb800d) Chore: add internal rule to enforce meta.docs conventions (fixes [#6954](https://github.com/eslint/eslint/issues/6954)) ([#7155](https://github.com/eslint/eslint/issues/7155)) (Vitor Balocco)
