---
layout: post
title: ESLint v3.6.0 released
teaser: "We just pushed ESLint v3.6.0, which is a minor release upgrade of ESLint. This release adds a new feature and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - gyandeeps
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Support for ES2017

With this release, we support ES2017 syntax natively. To activate ES2017 parser option, you need to update parser option (in your `.eslintrc.*` file).

```js
{
    "parserOptions": {
        "ecmaVersion": 2017,
        "sourceType": "module"
    }
}
```

#### Rules enhanced to support ES2017

* [`space-unary-ops`](https://eslint.org/docs/rules/space-unary-ops)
* [`no-extra-parens`](https://eslint.org/docs/rules/no-extra-parens)
* [`keyword-spacing`](https://eslint.org/docs/rules/keyword-spacing)
* [`arrow-parens`](https://eslint.org/docs/rules/arrow-parens)
* [`prefer-arrow-callback`](https://eslint.org/docs/rules/prefer-arrow-callback)
* [`no-unused-expressions`](https://eslint.org/docs/rules/no-unused-expressions)

### Auto-Fix

Four rules gained support for the `--fix` command line option:

* [`strict`](https://eslint.org/docs/rules/strict)
* [`prefer-template`](https://eslint.org/docs/rules/prefer-template)
* [`quote-props`](https://eslint.org/docs/rules/quote-props)
* [`no-regex-spaces`](https://eslint.org/docs/rules/no-regex-spaces)







## Enhancements


* [1b05d9c](https://github.com/eslint/eslint/commit/1b05d9c) Update: add fixer for `strict` (fixes [#6668](https://github.com/eslint/eslint/issues/6668)) ([#7198](https://github.com/eslint/eslint/issues/7198)) (Teddy Katz)
* [aaa3779](https://github.com/eslint/eslint/commit/aaa3779) Update: Allow `space-unary-ops` to handle await expressions ([#7174](https://github.com/eslint/eslint/issues/7174)) (Teddy Katz)
* [91bf477](https://github.com/eslint/eslint/commit/91bf477) Update: add fixer for `prefer-template` (fixes [#6978](https://github.com/eslint/eslint/issues/6978)) ([#7165](https://github.com/eslint/eslint/issues/7165)) (Teddy Katz)
* [745343f](https://github.com/eslint/eslint/commit/745343f) Update: `no-extra-parens` supports async/await (refs [#7101](https://github.com/eslint/eslint/issues/7101)) ([#7178](https://github.com/eslint/eslint/issues/7178)) (Toru Nagashima)
* [462a3f7](https://github.com/eslint/eslint/commit/462a3f7) Update: `keyword-spacing` supports async/await (refs [#7101](https://github.com/eslint/eslint/issues/7101)) ([#7179](https://github.com/eslint/eslint/issues/7179)) (Toru Nagashima)
* [709a734](https://github.com/eslint/eslint/commit/709a734) Update: Allow template string in `valid-typeof` comparison (fixes [#7166](https://github.com/eslint/eslint/issues/7166)) ([#7168](https://github.com/eslint/eslint/issues/7168)) (Teddy Katz)
* [16bb802](https://github.com/eslint/eslint/commit/16bb802) Update: Ensure `arrow-parens` handles async arrow functions correctly ([#7176](https://github.com/eslint/eslint/issues/7176)) (Teddy Katz)
* [c118d21](https://github.com/eslint/eslint/commit/c118d21) Update: Let `no-restricted-properties` check destructuring (fixes [#7147](https://github.com/eslint/eslint/issues/7147)) ([#7151](https://github.com/eslint/eslint/issues/7151)) (Teddy Katz)
* [95c777a](https://github.com/eslint/eslint/commit/95c777a) Update: Make `no-restricted-properties` more flexible (fixes [#7137](https://github.com/eslint/eslint/issues/7137)) ([#7139](https://github.com/eslint/eslint/issues/7139)) (Teddy Katz)
* [0fdf23c](https://github.com/eslint/eslint/commit/0fdf23c) Update: fix `quotes` rule's false negative (fixes [#7084](https://github.com/eslint/eslint/issues/7084)) ([#7141](https://github.com/eslint/eslint/issues/7141)) (Toru Nagashima)
* [f2a789d](https://github.com/eslint/eslint/commit/f2a789d) Update: fix `no-unused-vars` false negative (fixes [#7124](https://github.com/eslint/eslint/issues/7124)) ([#7143](https://github.com/eslint/eslint/issues/7143)) (Toru Nagashima)
* [e016384](https://github.com/eslint/eslint/commit/e016384) Update: add fixer for quote-props (fixes [#6996](https://github.com/eslint/eslint/issues/6996)) ([#7095](https://github.com/eslint/eslint/issues/7095)) (Teddy Katz)
* [8b3fc32](https://github.com/eslint/eslint/commit/8b3fc32) Update: Make `indent` report lines with mixed spaces/tabs (fixes [#4274](https://github.com/eslint/eslint/issues/4274)) ([#7076](https://github.com/eslint/eslint/issues/7076)) (Teddy Katz)
* [b39ac2c](https://github.com/eslint/eslint/commit/b39ac2c) Update: add fixer for `no-regex-spaces` ([#7113](https://github.com/eslint/eslint/issues/7113)) (Teddy Katz)
* [a876673](https://github.com/eslint/eslint/commit/a876673) Update: no-implicit-coercion checks TemplateLiterals (fixes [#7062](https://github.com/eslint/eslint/issues/7062)) ([#7121](https://github.com/eslint/eslint/issues/7121)) (Kai Cataldo)
* [22edd8a](https://github.com/eslint/eslint/commit/22edd8a) Update: `class-methods-use-this`: `exceptions` option (fixes [#7085](https://github.com/eslint/eslint/issues/7085)) ([#7120](https://github.com/eslint/eslint/issues/7120)) (Jordan Harband)
* [bcfa3e5](https://github.com/eslint/eslint/commit/bcfa3e5) Update: Add `always`/`never` option to `eol-last` (fixes [#6938](https://github.com/eslint/eslint/issues/6938)) ([#6952](https://github.com/eslint/eslint/issues/6952)) (kdex)




## Bug Fixes


* [8e1fee1](https://github.com/eslint/eslint/commit/8e1fee1) Fix: Handle number literals correctly in `no-whitespace-before-property` ([#7185](https://github.com/eslint/eslint/issues/7185)) (Teddy Katz)
* [f71937a](https://github.com/eslint/eslint/commit/f71937a) Fix: Don't report async/generator callbacks in `array-callback-return` ([#7172](https://github.com/eslint/eslint/issues/7172)) (Teddy Katz)
* [461b015](https://github.com/eslint/eslint/commit/461b015) Fix: Handle async functions correctly in `prefer-arrow-callback` fixer ([#7173](https://github.com/eslint/eslint/issues/7173)) (Teddy Katz)
* [7ea3e4b](https://github.com/eslint/eslint/commit/7ea3e4b) Fix: Handle await expressions correctly in `no-unused-expressions` ([#7175](https://github.com/eslint/eslint/issues/7175)) (Teddy Katz)
* [9e0b068](https://github.com/eslint/eslint/commit/9e0b068) Fix: valid-jsdoc does not throw on FieldType without value (fixes [#7184](https://github.com/eslint/eslint/issues/7184)) ([#7187](https://github.com/eslint/eslint/issues/7187)) (Kai Cataldo)
* [6148d85](https://github.com/eslint/eslint/commit/6148d85) Fix: Report columns for `eol-last` correctly (fixes [#7136](https://github.com/eslint/eslint/issues/7136)) ([#7149](https://github.com/eslint/eslint/issues/7149)) (kdex)
* [28ddcf8](https://github.com/eslint/eslint/commit/28ddcf8) Fix: `max-len`: `ignoreTemplateLiterals`: handle 3+ lines (fixes [#7125](https://github.com/eslint/eslint/issues/7125)) ([#7138](https://github.com/eslint/eslint/issues/7138)) (Jordan Harband)
* [76acbb5](https://github.com/eslint/eslint/commit/76acbb5) Fix: include LogicalExpression in indent length calc  (fixes [#6731](https://github.com/eslint/eslint/issues/6731)) ([#7087](https://github.com/eslint/eslint/issues/7087)) (Alec)
* [afd132a](https://github.com/eslint/eslint/commit/afd132a) Fix: line-comment-position "above" string option now works (fixes [#7100](https://github.com/eslint/eslint/issues/7100)) ([#7102](https://github.com/eslint/eslint/issues/7102)) (Kevin Partington)
* [c85fd84](https://github.com/eslint/eslint/commit/c85fd84) Fix: max-statements-per-line rule to force minimum to be 1 (fixes [#7051](https://github.com/eslint/eslint/issues/7051)) ([#7092](https://github.com/eslint/eslint/issues/7092)) (Scott Stern)
* [6ae660b](https://github.com/eslint/eslint/commit/6ae660b) Fix: Don't report comparisons of two typeof expressions (fixes [#7078](https://github.com/eslint/eslint/issues/7078)) ([#7082](https://github.com/eslint/eslint/issues/7082)) (Teddy Katz)




## Documentation


* [0a36138](https://github.com/eslint/eslint/commit/0a36138) Docs: Update ecmaVersion instructions ([#7195](https://github.com/eslint/eslint/issues/7195)) (Nicholas C. Zakas)
* [4b5d9b7](https://github.com/eslint/eslint/commit/4b5d9b7) Docs: Update process for evaluating proposals (fixes [#7156](https://github.com/eslint/eslint/issues/7156)) ([#7183](https://github.com/eslint/eslint/issues/7183)) (Kai Cataldo)
* [660e091](https://github.com/eslint/eslint/commit/660e091) Docs: Update rule descriptions (fixes [#5912](https://github.com/eslint/eslint/issues/5912)) ([#7152](https://github.com/eslint/eslint/issues/7152)) (Kenneth Williams)
* [cc80467](https://github.com/eslint/eslint/commit/cc80467) Docs: Update PR templates for formatting ([#7128](https://github.com/eslint/eslint/issues/7128)) (Nicholas C. Zakas)
* [7e8316f](https://github.com/eslint/eslint/commit/7e8316f) Docs: Update release process ([#7127](https://github.com/eslint/eslint/issues/7127)) (Nicholas C. Zakas)
* [ac0bb62](https://github.com/eslint/eslint/commit/ac0bb62) Docs: Fixes examples for allowTemplateLiterals (fixes [#7115](https://github.com/eslint/eslint/issues/7115)) ([#7135](https://github.com/eslint/eslint/issues/7135)) (Zoe Ingram)
* [0ca26d9](https://github.com/eslint/eslint/commit/0ca26d9) Docs: Distinguish examples for space-before-blocks ([#7132](https://github.com/eslint/eslint/issues/7132)) (Timo Tijhof)
* [e462e47](https://github.com/eslint/eslint/commit/e462e47) Docs: updates category of no-restricted-properties (fixes [#7112](https://github.com/eslint/eslint/issues/7112)) ([#7118](https://github.com/eslint/eslint/issues/7118)) (Alec)
* [710f205](https://github.com/eslint/eslint/commit/710f205) Docs: Fix typos in Issues section of Maintainer's Guide ([#7114](https://github.com/eslint/eslint/issues/7114)) (Kai Cataldo)
* [546a3ca](https://github.com/eslint/eslint/commit/546a3ca) Docs: Clarify that linter does not process configuration (fixes [#7108](https://github.com/eslint/eslint/issues/7108)) ([#7110](https://github.com/eslint/eslint/issues/7110)) (Kevin Partington)
* [0d50943](https://github.com/eslint/eslint/commit/0d50943) Docs: Elaborate on `guard-for-in` best practice (fixes [#7071](https://github.com/eslint/eslint/issues/7071)) ([#7094](https://github.com/eslint/eslint/issues/7094)) (Dallon Feldner)
* [58e6d76](https://github.com/eslint/eslint/commit/58e6d76) Docs: Fix examples for no-restricted-properties ([#7099](https://github.com/eslint/eslint/issues/7099)) (not-an-aardvark)
* [6cfe519](https://github.com/eslint/eslint/commit/6cfe519) Docs: Corrected typo in line-comment-position rule doc ([#7097](https://github.com/eslint/eslint/issues/7097)) (Alex Mercier)
* [f02e52a](https://github.com/eslint/eslint/commit/f02e52a) Docs: Add fixable note to no-implicit-coercion docs ([#7096](https://github.com/eslint/eslint/issues/7096)) (Brandon Mills)




## Dependency Upgrades


* [35f7be9](https://github.com/eslint/eslint/commit/35f7be9) Upgrade: espree to 3.2.0, remove tests with SyntaxErrors (fixes [#7169](https://github.com/eslint/eslint/issues/7169)) ([#7170](https://github.com/eslint/eslint/issues/7170)) (Teddy Katz)






## Chores


* [2d10657](https://github.com/eslint/eslint/commit/2d10657) Chore: add tests for `generator-star-spacing` and async (refs [#7101](https://github.com/eslint/eslint/issues/7101)) ([#7182](https://github.com/eslint/eslint/issues/7182)) (Toru Nagashima)
* [8db4f0c](https://github.com/eslint/eslint/commit/8db4f0c) Chore: Enable `typeof` check for `no-undef` rule in eslint-config-eslint ([#7103](https://github.com/eslint/eslint/issues/7103)) (Teddy Katz)
* [1738b2e](https://github.com/eslint/eslint/commit/1738b2e) Chore: fix name of internal-no-invalid-meta test file ([#7142](https://github.com/eslint/eslint/issues/7142)) (Vitor Balocco)
* [9a2aefb](https://github.com/eslint/eslint/commit/9a2aefb) Chore: Don't require an issue reference in check-commit npm script ([#7104](https://github.com/eslint/eslint/issues/7104)) (Teddy Katz)
