---
layout: post
title: ESLint v3.5.0 released
teaser: "We just pushed ESLint v3.5.0, which is a minor release upgrade of ESLint. This release adds a new feature and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - btmills
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### New Rules

The following new rules were added in this release:

* [`prefer-numeric-literals`](https://eslint.org/docs/rules/prefer-numeric-literals)
* [`no-restricted-properties`](https://eslint.org/docs/rules/no-restricted-properties)
* [`line-comment-position`](https://eslint.org/docs/rules/line-comment-position)
* [`lines-around-directive`](https://eslint.org/docs/rules/lines-around-directive)

### Auto-Fix

Eight rules gained support for the `--fix` command line option:

* [`no-floating-decimal`](https://eslint.org/docs/rules/no-floating-decimal)
* [`no-implicit-coercion`](https://eslint.org/docs/rules/no-implicit-coercion)
* [`prefer-arrow-callback`](https://eslint.org/docs/rules/prefer-arrow-callback)
* [`comma-style`](https://eslint.org/docs/rules/comma-style)
* [`dot-notation`](https://eslint.org/docs/rules/dot-notation)
* [`newline-before-return`](https://eslint.org/docs/rules/newline-before-return)
* [`wrap-regex`](https://eslint.org/docs/rules/wrap-regex)
* [`new-parens`](https://eslint.org/docs/rules/new-parens)


## Features


* [6d97c18](https://github.com/eslint/eslint/commit/6d97c18) New: `max-len`: `ignoreStrings`+`ignoreTemplateLiterals` (fixes [#5805](https://github.com/eslint/eslint/issues/5805)) ([#7049](https://github.com/eslint/eslint/issues/7049)) (Jordan Harband)
* [3960617](https://github.com/eslint/eslint/commit/3960617) New: `prefer-numeric-literals` rule (fixes [#6068](https://github.com/eslint/eslint/issues/6068)) ([#7029](https://github.com/eslint/eslint/issues/7029)) (Annie Zhang)
* [46cb690](https://github.com/eslint/eslint/commit/46cb690) New: `no-restricted-properties` rule (fixes [#3218](https://github.com/eslint/eslint/issues/3218)) ([#7017](https://github.com/eslint/eslint/issues/7017)) (Eli White)
* [8277357](https://github.com/eslint/eslint/commit/8277357) New: `line-comment-position` rule (fixes [#6077](https://github.com/eslint/eslint/issues/6077)) ([#6953](https://github.com/eslint/eslint/issues/6953)) (alberto)
* [c1f0d76](https://github.com/eslint/eslint/commit/c1f0d76) New: `lines-around-directive` rule (fixes [#6069](https://github.com/eslint/eslint/issues/6069)) ([#6998](https://github.com/eslint/eslint/issues/6998)) (Kai Cataldo)




## Enhancements


* [08fa538](https://github.com/eslint/eslint/commit/08fa538) Update: fix false negative of `arrow-spacing` (fixes [#7079](https://github.com/eslint/eslint/issues/7079)) ([#7080](https://github.com/eslint/eslint/issues/7080)) (Toru Nagashima)
* [cec65e3](https://github.com/eslint/eslint/commit/cec65e3) Update: add fixer for no-floating-decimal (fixes [#7070](https://github.com/eslint/eslint/issues/7070)) ([#7081](https://github.com/eslint/eslint/issues/7081)) (not-an-aardvark)
* [538d258](https://github.com/eslint/eslint/commit/538d258) Update: make no-implicit-coercion support autofixing. (fixes [#7056](https://github.com/eslint/eslint/issues/7056)) ([#7061](https://github.com/eslint/eslint/issues/7061)) (Eli White)
* [883316d](https://github.com/eslint/eslint/commit/883316d) Update: add fixer for prefer-arrow-callback (fixes [#7002](https://github.com/eslint/eslint/issues/7002)) ([#7004](https://github.com/eslint/eslint/issues/7004)) (not-an-aardvark)
* [7502eed](https://github.com/eslint/eslint/commit/7502eed) Update: auto-fix for `comma-style` (fixes [#6941](https://github.com/eslint/eslint/issues/6941)) ([#6957](https://github.com/eslint/eslint/issues/6957)) (Gyandeep Singh)
* [645dda5](https://github.com/eslint/eslint/commit/645dda5) Update: add fixer for dot-notation (fixes [#7014](https://github.com/eslint/eslint/issues/7014)) ([#7054](https://github.com/eslint/eslint/issues/7054)) (not-an-aardvark)
* [656bb6e](https://github.com/eslint/eslint/commit/656bb6e) Update: add fixer for newline-before-return (fixes [#5958](https://github.com/eslint/eslint/issues/5958)) ([#7050](https://github.com/eslint/eslint/issues/7050)) (Vitor Balocco)
* [e118728](https://github.com/eslint/eslint/commit/e118728) Update: add fixer for wrap-regex (fixes [#7013](https://github.com/eslint/eslint/issues/7013)) ([#7048](https://github.com/eslint/eslint/issues/7048)) (not-an-aardvark)
* [f4fcd1e](https://github.com/eslint/eslint/commit/f4fcd1e) Update: add more `indent` options for functions (fixes [#6052](https://github.com/eslint/eslint/issues/6052)) ([#7043](https://github.com/eslint/eslint/issues/7043)) (not-an-aardvark)
* [657eee5](https://github.com/eslint/eslint/commit/657eee5) Update: add fixer for new-parens (fixes [#6994](https://github.com/eslint/eslint/issues/6994)) ([#7047](https://github.com/eslint/eslint/issues/7047)) (not-an-aardvark)
* [ff19aa9](https://github.com/eslint/eslint/commit/ff19aa9) Update: improve `max-statements-per-line` message (fixes [#6287](https://github.com/eslint/eslint/issues/6287)) ([#7044](https://github.com/eslint/eslint/issues/7044)) (Jordan Harband)
* [22c7e09](https://github.com/eslint/eslint/commit/22c7e09) Update: no-magic-numbers false negative on reassigned vars (fixes [#4616](https://github.com/eslint/eslint/issues/4616)) ([#7028](https://github.com/eslint/eslint/issues/7028)) (not-an-aardvark)
* [be29599](https://github.com/eslint/eslint/commit/be29599) Update: Throw error if whitespace found in plugin name (fixes [#6854](https://github.com/eslint/eslint/issues/6854)) ([#6960](https://github.com/eslint/eslint/issues/6960)) (Jesse Ostrander)
* [00b3042](https://github.com/eslint/eslint/commit/00b3042) Update: Pass file path to parse function (fixes [#5344](https://github.com/eslint/eslint/issues/5344)) ([#7024](https://github.com/eslint/eslint/issues/7024)) (Annie Zhang)
* [8e77f16](https://github.com/eslint/eslint/commit/8e77f16) Update: `new-parens` false negative (fixes [#6997](https://github.com/eslint/eslint/issues/6997)) ([#6999](https://github.com/eslint/eslint/issues/6999)) (Toru Nagashima)




## Bug Fixes


* [2a3f699](https://github.com/eslint/eslint/commit/2a3f699) Fix: Column number for no-multiple-empty-lines (fixes [#7086](https://github.com/eslint/eslint/issues/7086)) ([#7088](https://github.com/eslint/eslint/issues/7088)) (Ian VanSchooten)
* [d9513b7](https://github.com/eslint/eslint/commit/d9513b7) Fix: Allow linting of .hidden files/folders (fixes [#4828](https://github.com/eslint/eslint/issues/4828)) ([#6844](https://github.com/eslint/eslint/issues/6844)) (Ian VanSchooten)
* [2657846](https://github.com/eslint/eslint/commit/2657846) Fix: `no-console` ignores user-defined console (fixes [#7010](https://github.com/eslint/eslint/issues/7010)) ([#7058](https://github.com/eslint/eslint/issues/7058)) (Toru Nagashima)
* [1f995c3](https://github.com/eslint/eslint/commit/1f995c3) Fix: no-implicit-coercion string concat false positive (fixes [#7057](https://github.com/eslint/eslint/issues/7057)) ([#7060](https://github.com/eslint/eslint/issues/7060)) (Kai Cataldo)
* [4063a79](https://github.com/eslint/eslint/commit/4063a79) Fix: Rule message placeholders can be inside braces (fixes [#6988](https://github.com/eslint/eslint/issues/6988)) ([#7041](https://github.com/eslint/eslint/issues/7041)) (Kevin Partington)
* [256c4a2](https://github.com/eslint/eslint/commit/256c4a2) Fix: Allow separate mode option for multiline and align (fixes [#6691](https://github.com/eslint/eslint/issues/6691)) ([#6991](https://github.com/eslint/eslint/issues/6991)) (Annie Zhang)




## Documentation


* [6947299](https://github.com/eslint/eslint/commit/6947299) Docs: Add info about closing accepted issues to docs (fixes [#6979](https://github.com/eslint/eslint/issues/6979)) ([#7089](https://github.com/eslint/eslint/issues/7089)) (Kai Cataldo)
* [d30157a](https://github.com/eslint/eslint/commit/d30157a) Docs: Add link to awesome-eslint in integrations page ([#7090](https://github.com/eslint/eslint/issues/7090)) (Vitor Balocco)
* [457be1b](https://github.com/eslint/eslint/commit/457be1b) Docs: Update so issues are not required (fixes [#7015](https://github.com/eslint/eslint/issues/7015)) ([#7072](https://github.com/eslint/eslint/issues/7072)) (Nicholas C. Zakas)
* [6718749](https://github.com/eslint/eslint/commit/6718749) Docs: Clarify that `es6` env also sets `ecmaVersion` to 6 ([#7067](https://github.com/eslint/eslint/issues/7067)) (Jérémie Astori)
* [52e8d9c](https://github.com/eslint/eslint/commit/52e8d9c) Docs: Clean up sort-vars ([#7045](https://github.com/eslint/eslint/issues/7045)) (Matthew Dunsdon)
* [3f13325](https://github.com/eslint/eslint/commit/3f13325) Docs: Add kaicataldo and JamesHenry to our teams ([#7039](https://github.com/eslint/eslint/issues/7039)) (alberto)
* [326f457](https://github.com/eslint/eslint/commit/326f457) Docs: Add missing 'to' in no-restricted-modules ([#7022](https://github.com/eslint/eslint/issues/7022)) (Oskar Risberg)
* [61f1de0](https://github.com/eslint/eslint/commit/61f1de0) Docs: Fix typo in no-debugger ([#7019](https://github.com/eslint/eslint/issues/7019)) (Denis Ciccale)
* [a989a7c](https://github.com/eslint/eslint/commit/a989a7c) Docs: Declaring dependency on eslint in shared config (fixes [#6617](https://github.com/eslint/eslint/issues/6617)) ([#6985](https://github.com/eslint/eslint/issues/6985)) (alberto)
* [6869c60](https://github.com/eslint/eslint/commit/6869c60) Docs: Fix minor typo in no-extra-parens doc ([#6992](https://github.com/eslint/eslint/issues/6992)) (Jérémie Astori)
* [28f1619](https://github.com/eslint/eslint/commit/28f1619) Docs: Update the example of SwitchCase ([#6981](https://github.com/eslint/eslint/issues/6981)) (fish)








## Chores


* [fa760f9](https://github.com/eslint/eslint/commit/fa760f9) Chore: no-regex-spaces uses internal rule message format (fixes [#7052](https://github.com/eslint/eslint/issues/7052)) ([#7053](https://github.com/eslint/eslint/issues/7053)) (Kevin Partington)
* [4126f12](https://github.com/eslint/eslint/commit/4126f12) Chore: Rule messages use internal rule message format (fixes [#6977](https://github.com/eslint/eslint/issues/6977)) ([#6989](https://github.com/eslint/eslint/issues/6989)) (Kevin Partington)
