---
layout: post
title: ESLint v3.4.0 released
teaser: "We just pushed ESLint v3.4.0, which is a minor release upgrade of ESLint. This release adds a new feature and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Fix For Configuring Scoped Plugin Rules

We discovered a significant bug ([#6362](https://github.com/eslint/eslint/issues/6362)) when using scoped plugins. Scoped plugins use npm scopes such as `@foo/eslint-plugin-bar`. Due to a bug in ESLint, if you had a rule `baz` in the plugin `@foo/eslint-plugin-bar`, you would have to configure it without the scope, such as:

```yaml
rules:
  bar/baz: error
```

This is problematic because it's possible that an unscoped plugin `eslint-plugin-bar` might exist and need to be configured in the same way.

**Important:** Starting in this release, you should now configure scoped plugin rules using the scope as a prefix. The previous example should now be written as:

```yaml
rules:
  @foo/bar/baz: error
```

The other format will continue work until we release ESLint v4.0.0, at which point only the format using the package scope will work. We encourage you to update your configuration files as quickly as possible so as not to be caught up in the change for version 4.0.0.

### Performance Improvements

We've been steadily improving the performance of traversing directories in ESLint. Previously, we made a change that dramatically improved the speed of directory traversal for those who weren't using `.eslintignore` ([#5679](https://github.com/eslint/eslint/issues/5679)). In this release, we've continued on to improve the speed for those using `.eslintignore` as well ([#6710](https://github.com/eslint/eslint/issues/6710)).


### New Ways to Configure ECMAScript Version

ESLint has supported the `ecmaVersion` property for specifying which versions of ECMAScript syntax to enable. Prior to this release, you could use `3`, `5`, `6`, and `7`. However, the official ECMAScript standard is now being defined by year, so some new users found this confusing. As such, we've added the ability to use `2015` and `2016` in the `ecmaVersion` field (these correspond to `6` and `7`, respectively), so that going forward we can use the more appropriate year-based values.

### New Rules

The following new rules were added in this release:

* [`symbol-description`](https://eslint.org/docs/rules/symbol-description)
* [`class-methods-use-this`](https://eslint.org/docs/rules/class-methods-use-this)




## Features


* [21ab784](https://github.com/eslint/eslint/commit/21ab784) New: do not remove non visited files from cache. (fixes [#6780](https://github.com/eslint/eslint/issues/6780)) ([#6921](https://github.com/eslint/eslint/issues/6921)) (Roy Riojas)
* [0d268f1](https://github.com/eslint/eslint/commit/0d268f1) New: `symbol-description` rule (fixes [#6778](https://github.com/eslint/eslint/issues/6778)) ([#6825](https://github.com/eslint/eslint/issues/6825)) (Jarek Rencz)
* [a5189a6](https://github.com/eslint/eslint/commit/a5189a6) New: `class-methods-use-this` rule (fixes [#5139](https://github.com/eslint/eslint/issues/5139)) ([#6881](https://github.com/eslint/eslint/issues/6881)) (Gyandeep Singh)




## Enhancements


* [c210510](https://github.com/eslint/eslint/commit/c210510) Update: add fixer for no-extra-parens (fixes [#6944](https://github.com/eslint/eslint/issues/6944)) ([#6950](https://github.com/eslint/eslint/issues/6950)) (not-an-aardvark)
* [d6fd064](https://github.com/eslint/eslint/commit/d6fd064) Update: Add never option to multiline-ternary (fixes [#6751](https://github.com/eslint/eslint/issues/6751)) ([#6905](https://github.com/eslint/eslint/issues/6905)) (Kai Cataldo)
* [cf2242c](https://github.com/eslint/eslint/commit/cf2242c) Update: `requireStringLiterals` option for `valid-typeof` (fixes [#6698](https://github.com/eslint/eslint/issues/6698)) ([#6923](https://github.com/eslint/eslint/issues/6923)) (not-an-aardvark)
* [1563808](https://github.com/eslint/eslint/commit/1563808) Update: add support for ecmaVersion 20xx (fixes [#6750](https://github.com/eslint/eslint/issues/6750)) ([#6907](https://github.com/eslint/eslint/issues/6907)) (Kai Cataldo)




## Bug Fixes


* [ca3d448](https://github.com/eslint/eslint/commit/ca3d448) Fix: `prefer-const` false negative about `eslintUsed` (fixes [#5837](https://github.com/eslint/eslint/issues/5837)) ([#6971](https://github.com/eslint/eslint/issues/6971)) (Toru Nagashima)
* [3e522be](https://github.com/eslint/eslint/commit/3e522be) Fix: false negative of `indent` with `else if` statements (fixes [#6956](https://github.com/eslint/eslint/issues/6956)) ([#6965](https://github.com/eslint/eslint/issues/6965)) (not-an-aardvark)
* [3c710c9](https://github.com/eslint/eslint/commit/3c710c9) Fix: rename "AirBnB" => "Airbnb" init choice (fixes [#6969](https://github.com/eslint/eslint/issues/6969)) (Harrison Shoff)
* [7660b39](https://github.com/eslint/eslint/commit/7660b39) Fix: `object-curly-spacing` for type annotations (fixes [#6940](https://github.com/eslint/eslint/issues/6940)) ([#6945](https://github.com/eslint/eslint/issues/6945)) (Toru Nagashima)
* [3a1763c](https://github.com/eslint/eslint/commit/3a1763c) Fix: enable `@scope/plugin/ruleId`-style specifier (refs [#6362](https://github.com/eslint/eslint/issues/6362)) ([#6939](https://github.com/eslint/eslint/issues/6939)) (Toru Nagashima)
* [a063d4e](https://github.com/eslint/eslint/commit/a063d4e) Fix: no-cond-assign within a function expression (fixes [#6908](https://github.com/eslint/eslint/issues/6908)) ([#6909](https://github.com/eslint/eslint/issues/6909)) (Patrick McElhaney)
* [8851ddd](https://github.com/eslint/eslint/commit/8851ddd) Fix: Improve pref of globbing by inheriting glob.GlobSync (fixes [#6710](https://github.com/eslint/eslint/issues/6710)) ([#6783](https://github.com/eslint/eslint/issues/6783)) (Kael Zhang)
* [8561389](https://github.com/eslint/eslint/commit/8561389) Fix: `no-trailing-spaces` wrong fixing (fixes [#6933](https://github.com/eslint/eslint/issues/6933)) ([#6937](https://github.com/eslint/eslint/issues/6937)) (Toru Nagashima)




## Documentation


* [1153955](https://github.com/eslint/eslint/commit/1153955) Docs: Draft of JSCS migration guide (refs [#5859](https://github.com/eslint/eslint/issues/5859)) ([#6942](https://github.com/eslint/eslint/issues/6942)) (Nicholas C. Zakas)
* [2dfb290](https://github.com/eslint/eslint/commit/2dfb290) Docs: Distinguish examples in rules under Stylistic Issues part 7 ([#6760](https://github.com/eslint/eslint/issues/6760)) (Kenneth Williams)
* [6a92be5](https://github.com/eslint/eslint/commit/6a92be5) Docs: Update semantic versioning policy ([#6935](https://github.com/eslint/eslint/issues/6935)) (alberto)
* [d8b770c](https://github.com/eslint/eslint/commit/d8b770c) Docs: Change rule descriptions for consistent casing ([#6915](https://github.com/eslint/eslint/issues/6915)) (Brandon Mills)






## Build Related


* [16db93a](https://github.com/eslint/eslint/commit/16db93a) Build: Tag docs, publish release notes (fixes [#6892](https://github.com/eslint/eslint/issues/6892)) ([#6934](https://github.com/eslint/eslint/issues/6934)) (Nicholas C. Zakas)




## Chores


* [0cf1d55](https://github.com/eslint/eslint/commit/0cf1d55) Chore: Fix object-shorthand errors (fixes [#6958](https://github.com/eslint/eslint/issues/6958)) ([#6959](https://github.com/eslint/eslint/issues/6959)) (Kai Cataldo)
* [c676322](https://github.com/eslint/eslint/commit/c676322) Chore: Use object-shorthand batch 3 (refs [#6407](https://github.com/eslint/eslint/issues/6407)) ([#6914](https://github.com/eslint/eslint/issues/6914)) (Kai Cataldo)
