---
layout: post
title: ESLint v3.3.0 released
teaser: "We just pushed ESLint v3.3.0, which is a minor release upgrade of ESLint. This release adds a new feature and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights


This is a summary of the major changes you need to know about for this version of ESLint.

## Deprecated Rules

In continuing our work towards JSCS compatibility and reviewing the current rules list, we decided to deprecate several rules and replace them with new rules. In some cases there was just confusion about the existing rule and in others there were changes necessary for JSCS compatibility. Per our [rule deprecation policy](https://eslint.org/docs/user-guide/rule-deprecation), the deprecated rules will remain as part of ESLint until at least May 2017, at which point we will evaluate removing those rules.

We recommend you upgrade your configurations to use the new rules.

| **Deprecated Rule** | **Replaced By** |
|---------------------|-----------------|
| [`no-native-reassign`](https://eslint.org/docs/rules/no-native-reassign) | [`no-global-assign'](https://eslint.org/docs/rules/no-global-assign) |
| [`no-negated-in-lhs`](https://eslint.org/docs/rules/no-negated-in-lhs) | [`no-unsafe-negation'](https://eslint.org/docs/rules/no-unsafe-negation) |
| [`no-spaced-func`](https://eslint.org/docs/rules/no-spaced-func) | [`func-call-spacing'](https://eslint.org/docs/rules/func-call-spacing) |


## New Rules

* [`sort-keys`](https://eslint.org/docs/rules/sort-keys)
* [`no-template-curly-in-string`](https://eslint.org/docs/rules/no-template-curly-in-string)




## Features


* [e456fd3](https://github.com/eslint/eslint/commit/e456fd3) New: `sort-keys` rule (fixes [#6076](https://github.com/eslint/eslint/issues/6076)) ([#6800](https://github.com/eslint/eslint/issues/6800)) (Toru Nagashima)
* [f8ab8f1](https://github.com/eslint/eslint/commit/f8ab8f1) New: func-call-spacing rule (fixes [#6080](https://github.com/eslint/eslint/issues/6080)) ([#6749](https://github.com/eslint/eslint/issues/6749)) (Brandon Mills)
* [be68f0b](https://github.com/eslint/eslint/commit/be68f0b) New: no-template-curly-in-string rule (fixes [#6186](https://github.com/eslint/eslint/issues/6186)) ([#6767](https://github.com/eslint/eslint/issues/6767)) (Jeroen Engels)
* [5ef839e](https://github.com/eslint/eslint/commit/5ef839e) New: Add consistent and ..-as-needed to object-shorthand (fixes [#5438](https://github.com/eslint/eslint/issues/5438)) ([#5439](https://github.com/eslint/eslint/issues/5439)) (Martijn de Haan)
* [aef18b4](https://github.com/eslint/eslint/commit/aef18b4) New: `no-unsafe-negation` rule (fixes [#2716](https://github.com/eslint/eslint/issues/2716)) ([#6789](https://github.com/eslint/eslint/issues/6789)) (Toru Nagashima)
* [2b17459](https://github.com/eslint/eslint/commit/2b17459) New: `no-global-assign` rule (fixes [#6586](https://github.com/eslint/eslint/issues/6586)) ([#6746](https://github.com/eslint/eslint/issues/6746)) (alberto)




## Enhancements


* [ebf8441](https://github.com/eslint/eslint/commit/ebf8441) Update: `prefer-rest-params` relax for member accesses (fixes [#5990](https://github.com/eslint/eslint/issues/5990)) ([#6871](https://github.com/eslint/eslint/issues/6871)) (Toru Nagashima)
* [df01c4f](https://github.com/eslint/eslint/commit/df01c4f) Update: Add regex support for exceptions (fixes [#5187](https://github.com/eslint/eslint/issues/5187)) ([#6883](https://github.com/eslint/eslint/issues/6883)) (Annie Zhang)
* [3e879fc](https://github.com/eslint/eslint/commit/3e879fc) Update: Rule "eqeqeq" to have more specific null handling (fixes [#6543](https://github.com/eslint/eslint/issues/6543)) ([#6849](https://github.com/eslint/eslint/issues/6849)) (Simon Sturmer)
* [1ecd2a3](https://github.com/eslint/eslint/commit/1ecd2a3) Update: improve error message in `no-control-regex` ([#6839](https://github.com/eslint/eslint/issues/6839)) (Jordan Harband)
* [d610d6c](https://github.com/eslint/eslint/commit/d610d6c) Update: make `max-lines` report the actual number of lines (fixes [#6766](https://github.com/eslint/eslint/issues/6766)) ([#6764](https://github.com/eslint/eslint/issues/6764)) (Jarek Rencz)
* [bf0afcb](https://github.com/eslint/eslint/commit/bf0afcb) Update: validate void operator in no-constant-condition (fixes [#5726](https://github.com/eslint/eslint/issues/5726)) ([#6837](https://github.com/eslint/eslint/issues/6837)) (Vitor Balocco)
* [90f78f4](https://github.com/eslint/eslint/commit/90f78f4) Update: add `props` option to `no-self-assign` rule (fixes [#6718](https://github.com/eslint/eslint/issues/6718)) ([#6721](https://github.com/eslint/eslint/issues/6721)) (Toru Nagashima)
* [30d71d6](https://github.com/eslint/eslint/commit/30d71d6) Update: 'requireForBlockBody' modifier for 'arrow-parens' (fixes [#6557](https://github.com/eslint/eslint/issues/6557)) ([#6558](https://github.com/eslint/eslint/issues/6558)) (Nicolas Froidure)
* [e524d16](https://github.com/eslint/eslint/commit/e524d16) Update: camelcase rule fix for import declarations (fixes [#6755](https://github.com/eslint/eslint/issues/6755)) ([#6784](https://github.com/eslint/eslint/issues/6784)) (Lorenzo Zottar)
* [8f3509d](https://github.com/eslint/eslint/commit/8f3509d) Update: make `eslint:all` excluding deprecated rules (fixes [#6734](https://github.com/eslint/eslint/issues/6734)) ([#6756](https://github.com/eslint/eslint/issues/6756)) (Toru Nagashima)




## Bug Fixes


* [055742c](https://github.com/eslint/eslint/commit/055742c) Fix: `no-dupe-keys` type errors (fixes [#6886](https://github.com/eslint/eslint/issues/6886)) ([#6889](https://github.com/eslint/eslint/issues/6889)) (Toru Nagashima)
* [11395ca](https://github.com/eslint/eslint/commit/11395ca) Fix: `no-dupe-keys` false negative (fixes [#6801](https://github.com/eslint/eslint/issues/6801)) ([#6863](https://github.com/eslint/eslint/issues/6863)) (Toru Nagashima)
* [d47c505](https://github.com/eslint/eslint/commit/d47c505) Fix: `newline-after-var` false positive (fixes [#6834](https://github.com/eslint/eslint/issues/6834)) ([#6847](https://github.com/eslint/eslint/issues/6847)) (Toru Nagashima)
* [7e1bf01](https://github.com/eslint/eslint/commit/7e1bf01) Fix: update peerDependencies of airbnb option for `--init` (fixes [#6843](https://github.com/eslint/eslint/issues/6843)) ([#6846](https://github.com/eslint/eslint/issues/6846)) (Vitor Balocco)
* [8581f4f](https://github.com/eslint/eslint/commit/8581f4f) Fix: `no-invalid-this` false positive (fixes [#6824](https://github.com/eslint/eslint/issues/6824)) ([#6827](https://github.com/eslint/eslint/issues/6827)) (Toru Nagashima)




## Documentation


* [e37bbd8](https://github.com/eslint/eslint/commit/e37bbd8) Docs: Remove duplicate statement ([#6878](https://github.com/eslint/eslint/issues/6878)) (Richard Käll)
* [117e7aa](https://github.com/eslint/eslint/commit/117e7aa) Docs: Remove incorrect "constructor" statement from `no-new-symbol` docs ([#6830](https://github.com/eslint/eslint/issues/6830)) (Jarek Rencz)
* [d94e945](https://github.com/eslint/eslint/commit/d94e945) Docs: Update Getting Started w/ Readme installation instructions ([#6823](https://github.com/eslint/eslint/issues/6823)) (Kai Cataldo)




## Dependency Upgrades


* [dfbc112](https://github.com/eslint/eslint/commit/dfbc112) Upgrade: proxyquire to 1.7.10 (fixes [#6821](https://github.com/eslint/eslint/issues/6821)) ([#6822](https://github.com/eslint/eslint/issues/6822)) (alberto)




## Build Related


* [683ac56](https://github.com/eslint/eslint/commit/683ac56) Build: Add CI release scripts (fixes [#6884](https://github.com/eslint/eslint/issues/6884)) ([#6885](https://github.com/eslint/eslint/issues/6885)) (Nicholas C. Zakas)




## Chores


* [e8cb7f9](https://github.com/eslint/eslint/commit/e8cb7f9) Chore: use eslint-plugin-node (refs [#6407](https://github.com/eslint/eslint/issues/6407)) ([#6862](https://github.com/eslint/eslint/issues/6862)) (Toru Nagashima)
* [b256c50](https://github.com/eslint/eslint/commit/b256c50) Chore: Fix glob for core js files for lint (fixes [#6870](https://github.com/eslint/eslint/issues/6870)) ([#6872](https://github.com/eslint/eslint/issues/6872)) (Gyandeep Singh)
* [80789ab](https://github.com/eslint/eslint/commit/80789ab) Chore: don't throw if rule is in old format (fixes [#6848](https://github.com/eslint/eslint/issues/6848)) ([#6850](https://github.com/eslint/eslint/issues/6850)) (Vitor Balocco)
* [cdded07](https://github.com/eslint/eslint/commit/cdded07) Chore: use native `Object.assign` (refs [#6407](https://github.com/eslint/eslint/issues/6407)) ([#6832](https://github.com/eslint/eslint/issues/6832)) (Gyandeep Singh)
* [579ec49](https://github.com/eslint/eslint/commit/579ec49) Chore: Add link to rule change guidelines in "needs info" template (fixes [#6829](https://github.com/eslint/eslint/issues/6829)) ([#6831](https://github.com/eslint/eslint/issues/6831)) (Kevin Partington)
* [4c5e911](https://github.com/eslint/eslint/commit/4c5e911) Chore: enable `prefer-const` and apply it to our codebase (refs [#6407](https://github.com/eslint/eslint/issues/6407)) ([#6805](https://github.com/eslint/eslint/issues/6805)) (Toru Nagashima)
