---
layout: post
title: ESLint v3.2.0 released
teaser: "We just pushed ESLint v3.2.0, which is a minor release upgrade of ESLint. This release adds a new feature and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - nzakas
categories:
  - Release Notes
---

## Features


* [b22eb5c](https://github.com/eslint/eslint/commit/b22eb5c) New: `no-tabs` rule (fixes [#6079](https://github.com/eslint/eslint/issues/6079)) ([#6772](https://github.com/eslint/eslint/issues/6772)) (Gyandeep Singh)




## Enhancements


* [26c85dd](https://github.com/eslint/eslint/commit/26c85dd) Update: merge warnings of consecutive unreachable nodes (fixes [#6583](https://github.com/eslint/eslint/issues/6583)) ([#6729](https://github.com/eslint/eslint/issues/6729)) (Toru Nagashima)
* [5320a6c](https://github.com/eslint/eslint/commit/5320a6c) Update: `no-use-before-define` false negative on for-in/of (fixes [#6699](https://github.com/eslint/eslint/issues/6699)) ([#6719](https://github.com/eslint/eslint/issues/6719)) (Toru Nagashima)
* [95ea25a](https://github.com/eslint/eslint/commit/95ea25a) Update: Check indentation of multi-line chained properties (refs [#1801](https://github.com/eslint/eslint/issues/1801)) ([#5940](https://github.com/eslint/eslint/issues/5940)) (Rich Trott)
* [053aa0c](https://github.com/eslint/eslint/commit/053aa0c) Update: Added 'allowSuper' option to `no-underscore-dangle` (fixes [#6355](https://github.com/eslint/eslint/issues/6355)) ([#6662](https://github.com/eslint/eslint/issues/6662)) (peteward44)




## Bug Fixes


* [e825458](https://github.com/eslint/eslint/commit/e825458) Fix: Rule no-unused-vars had missing period (fixes [#6738](https://github.com/eslint/eslint/issues/6738)) ([#6739](https://github.com/eslint/eslint/issues/6739)) (Brian Mock)
* [106e40b](https://github.com/eslint/eslint/commit/106e40b) Fix: Correct grammar in object-curly-newline reports (fixes [#6725](https://github.com/eslint/eslint/issues/6725)) ([#6728](https://github.com/eslint/eslint/issues/6728)) (Vitor Balocco)
* [a2090cb](https://github.com/eslint/eslint/commit/a2090cb) Fix: space-infix-ops doesn't fail for  type annotations(fixes [#5211](https://github.com/eslint/eslint/issues/5211)) ([#6723](https://github.com/eslint/eslint/issues/6723)) (Nicholas C. Zakas)




## Documentation


* [1025772](https://github.com/eslint/eslint/commit/1025772) Docs: Add plugin example to disabling with comments guide (fixes [#6742](https://github.com/eslint/eslint/issues/6742)) ([#6747](https://github.com/eslint/eslint/issues/6747)) (Brandon Mills)
* [628aae4](https://github.com/eslint/eslint/commit/628aae4) Docs: fix inconsistent spacing inside block comment ([#6768](https://github.com/eslint/eslint/issues/6768)) (Brian Jacobel)
* [2983c32](https://github.com/eslint/eslint/commit/2983c32) Docs: Add options to func-names config comments ([#6748](https://github.com/eslint/eslint/issues/6748)) (Brandon Mills)
* [2f94443](https://github.com/eslint/eslint/commit/2f94443) Docs: fix wrong path ([#6763](https://github.com/eslint/eslint/issues/6763)) (molee1905)
* [99dfd1c](https://github.com/eslint/eslint/commit/99dfd1c) Docs: fix grammar issue in rule-changes page ([#6761](https://github.com/eslint/eslint/issues/6761)) (Vitor Balocco)
* [71ae64c](https://github.com/eslint/eslint/commit/71ae64c) Docs: Clarify cache file deletion (fixes [#4943](https://github.com/eslint/eslint/issues/4943)) ([#6712](https://github.com/eslint/eslint/issues/6712)) (Nicholas C. Zakas)
* [9c36ecf](https://github.com/eslint/eslint/commit/9c36ecf) Docs: Add @vitorbal and @platinumazure to development team (Ilya Volodin)
* [e09d1b8](https://github.com/eslint/eslint/commit/e09d1b8) Docs: describe all RuleTester options (fixes [#4810](https://github.com/eslint/eslint/issues/4810), fixes [#6709](https://github.com/eslint/eslint/issues/6709)) ([#6711](https://github.com/eslint/eslint/issues/6711)) (Nicholas C. Zakas)
* [75d2d43](https://github.com/eslint/eslint/commit/75d2d43) Docs: Clarify Closure type hint expectation (fixes [#5231](https://github.com/eslint/eslint/issues/5231)) ([#6714](https://github.com/eslint/eslint/issues/6714)) (Nicholas C. Zakas)
* [e7b1e1c](https://github.com/eslint/eslint/commit/e7b1e1c) Docs: Edit issue/PR waiting period docs (fixes [#6009](https://github.com/eslint/eslint/issues/6009)) ([#6715](https://github.com/eslint/eslint/issues/6715)) (Nicholas C. Zakas)
* [f916ae5](https://github.com/eslint/eslint/commit/f916ae5) Docs: Fix multiline-ternary typos ([#6704](https://github.com/eslint/eslint/issues/6704)) (Cédric Malard)




## Dependency Upgrades


* [2438ee2](https://github.com/eslint/eslint/commit/2438ee2) Upgrade: Update markdownlint dependency to 0.2.0 (fixes [#6781](https://github.com/eslint/eslint/issues/6781)) ([#6782](https://github.com/eslint/eslint/issues/6782)) (David Anson)




## Build Related


* [181b26a](https://github.com/eslint/eslint/commit/181b26a) Build: Remove support for Node v5 (fixes [#6743](https://github.com/eslint/eslint/issues/6743)) ([#6744](https://github.com/eslint/eslint/issues/6744)) (alberto)
* [8929045](https://github.com/eslint/eslint/commit/8929045) Build: Automatically generate rule index (refs [#2860](https://github.com/eslint/eslint/issues/2860)) ([#6658](https://github.com/eslint/eslint/issues/6658)) (Ilya Volodin)




## Chores


* [4fc0018](https://github.com/eslint/eslint/commit/4fc0018) Chore: dogfooding `no-var` rule and remove `var`s (refs [#6407](https://github.com/eslint/eslint/issues/6407)) ([#6757](https://github.com/eslint/eslint/issues/6757)) (Toru Nagashima)
* [ddea63a](https://github.com/eslint/eslint/commit/ddea63a) Chore: Updated no-control-regex tests to cover all cases (fixes [#6438](https://github.com/eslint/eslint/issues/6438)) ([#6752](https://github.com/eslint/eslint/issues/6752)) (Efe Gürkan YALAMAN)
* [e00754c](https://github.com/eslint/eslint/commit/e00754c) Chore: Dogfooding ES6 rules (refs [#6407](https://github.com/eslint/eslint/issues/6407)) ([#6735](https://github.com/eslint/eslint/issues/6735)) (alberto)
* [a157f47](https://github.com/eslint/eslint/commit/a157f47) Chore: Update CLIEngine option desc (fixes [#5179](https://github.com/eslint/eslint/issues/5179)) ([#6713](https://github.com/eslint/eslint/issues/6713)) (Nicholas C. Zakas)
* [a0727f9](https://github.com/eslint/eslint/commit/a0727f9) Chore: fix `.gitignore` for vscode (refs [#6383](https://github.com/eslint/eslint/issues/6383)) ([#6720](https://github.com/eslint/eslint/issues/6720)) (Toru Nagashima)
* [c64b0c2](https://github.com/eslint/eslint/commit/c64b0c2) Chore: First ES6 refactoring (refs [#6407](https://github.com/eslint/eslint/issues/6407)) ([#6570](https://github.com/eslint/eslint/issues/6570)) (Nicholas C. Zakas)
