---
layout: post
title: ESLint v3.0.0 released
teaser: "We just pushed ESLint v3.0.0, which is a major release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release. This release also has some breaking changes, so please read the following closely."
image: release-notes-major.png
tags:
  - release
  - major
authors:
  - nzakas
categories:
  - Release Notes
---

As breaking changes can cause problems for some users, we've created a [migration guide](/docs/user-guide/migrating-to-3.0.0) describing the changes in great detail along with the steps you should take to address them. Not all ESLint users will be affected by the changes, however, we recommend everyone read the migration thoroughly.


## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Requires Node.js 4 or higher

ESLint v3.0.0 now requires Node.js 4 or higher. Going forward, our plan is always to support the LTS version of Node.js and periodically end-of-life support for older Node.js versions. As both Node.js v0.10 and v0.12 will be out of maintenance mode at the end of 2016, we hope that this change won't affect too many users.

If you still need ESLint to run on Node.js < 4, then we recommend staying with ESLint v2.13.1 until you are ready to upgrade your Node.js version.

### `eslint:recommended` Update

We've added some new rules to `eslint:recommended` that we believe are important for all users. You can read more about these changes in the [migration guide](/docs/user-guide/migrating-to-3.0.0).

### Configuration is Now Required

One of the most confusing aspects of ESLint for new users has been that ESLint doesn't do anything unless you provide a configuration. While this is good from a configurability perspective (we don't force any configuration on you), we still get a lot of reports from new users who don't understand what's happening. As such, we decided to make configuration a requirement for ESLint and will not longer run if no configuration is present. Instead, ESLint will output an error when it can't find a configuration file and no configuration information is provided on the command line. More information is available in the [migration guide](/docs/user-guide/migrating-to-3.0.0).



## Breaking Changes


* [dc5b78b](https://github.com/eslint/eslint/commit/dc5b78b) Breaking: Add `require-yield` rule to `eslint:recommended` (fixes [#6550](https://github.com/eslint/eslint/issues/6550)) ([#6554](https://github.com/eslint/eslint/issues/6554)) (Gyandeep Singh)
* [e0d4b19](https://github.com/eslint/eslint/commit/e0d4b19) Breaking: Error thrown/printed if no config found (fixes [#5987](https://github.com/eslint/eslint/issues/5987)) ([#6538](https://github.com/eslint/eslint/issues/6538)) (Kevin Partington)
* [fa05119](https://github.com/eslint/eslint/commit/fa05119) Breaking: Update eslint:recommended (fixes [#6403](https://github.com/eslint/eslint/issues/6403)) ([#6509](https://github.com/eslint/eslint/issues/6509)) (Nicholas C. Zakas)
* [58542e4](https://github.com/eslint/eslint/commit/58542e4) Breaking: Drop support for node < 4 (fixes [#4483](https://github.com/eslint/eslint/issues/4483)) ([#6401](https://github.com/eslint/eslint/issues/6401)) (alberto)
* [f50657e](https://github.com/eslint/eslint/commit/f50657e) Breaking: use default for complexity in eslint:recommended (fixes [#6021](https://github.com/eslint/eslint/issues/6021)) ([#6410](https://github.com/eslint/eslint/issues/6410)) (alberto)






## Enhancements


* [e2b2030](https://github.com/eslint/eslint/commit/e2b2030) Update: Check RegExp strings for `no-regex-spaces` (fixes [#3586](https://github.com/eslint/eslint/issues/3586)) ([#6379](https://github.com/eslint/eslint/issues/6379)) (Jackson Ray Hamilton)
* [397e51b](https://github.com/eslint/eslint/commit/397e51b) Update: Implement outerIIFEBody for indent rule (fixes [#6259](https://github.com/eslint/eslint/issues/6259)) ([#6382](https://github.com/eslint/eslint/issues/6382)) (David Shepherd)
* [1290657](https://github.com/eslint/eslint/commit/1290657) Update: `no-unused-vars` ignores read it modifies itself (fixes [#6348](https://github.com/eslint/eslint/issues/6348)) ([#6535](https://github.com/eslint/eslint/issues/6535)) (Toru Nagashima)
* [0a7936d](https://github.com/eslint/eslint/commit/0a7936d) Update: Add fixer for prefer-const (fixes [#6448](https://github.com/eslint/eslint/issues/6448)) ([#6486](https://github.com/eslint/eslint/issues/6486)) (Nick Heiner)
* [e06a5b5](https://github.com/eslint/eslint/commit/e06a5b5) Update: Add fixer for arrow-parens (fixes [#4766](https://github.com/eslint/eslint/issues/4766)) ([#6501](https://github.com/eslint/eslint/issues/6501)) (madmed88)




## Bug Fixes


* [7988427](https://github.com/eslint/eslint/commit/7988427) Fix: lib/config.js tests pass if personal config exists (fixes [#6559](https://github.com/eslint/eslint/issues/6559)) ([#6566](https://github.com/eslint/eslint/issues/6566)) (Kevin Partington)
* [d601f6b](https://github.com/eslint/eslint/commit/d601f6b) Fix: Delete cache only when executing on files (fixes [#6459](https://github.com/eslint/eslint/issues/6459)) ([#6540](https://github.com/eslint/eslint/issues/6540)) (Kai Cataldo)
* [18663d4](https://github.com/eslint/eslint/commit/18663d4) Fix: false negative of `no-useless-rename` (fixes [#6502](https://github.com/eslint/eslint/issues/6502)) ([#6506](https://github.com/eslint/eslint/issues/6506)) (Toru Nagashima)
* [4343ae8](https://github.com/eslint/eslint/commit/4343ae8) Fix: false negative of `object-shorthand` (fixes [#6429](https://github.com/eslint/eslint/issues/6429)) ([#6434](https://github.com/eslint/eslint/issues/6434)) (Toru Nagashima)
* [3b0ab0d](https://github.com/eslint/eslint/commit/3b0ab0d) Fix: add warnIgnored flag to CLIEngine.executeOnText (fixes [#6302](https://github.com/eslint/eslint/issues/6302)) ([#6305](https://github.com/eslint/eslint/issues/6305)) (Robert Levy)
* [5668236](https://github.com/eslint/eslint/commit/5668236) Fix: Allow objectsInObjects exception when destructuring (fixes [#6469](https://github.com/eslint/eslint/issues/6469)) ([#6470](https://github.com/eslint/eslint/issues/6470)) (Adam Renklint)
* [17ac0ae](https://github.com/eslint/eslint/commit/17ac0ae) Fix: `strict` rule reports a syntax error for ES2016 (fixes [#6405](https://github.com/eslint/eslint/issues/6405)) ([#6464](https://github.com/eslint/eslint/issues/6464)) (Toru Nagashima)
* [3e690fb](https://github.com/eslint/eslint/commit/3e690fb) Fix: Exit init early if guide is chosen w/ no package.json (fixes [#6476](https://github.com/eslint/eslint/issues/6476)) ([#6478](https://github.com/eslint/eslint/issues/6478)) (Kai Cataldo)




## Documentation


* [66de9d8](https://github.com/eslint/eslint/commit/66de9d8) Docs: Update installation instructions on README ([#6569](https://github.com/eslint/eslint/issues/6569)) (Nicholas C. Zakas)
* [4c05967](https://github.com/eslint/eslint/commit/4c05967) Docs: Update rule docs for new format (fixes [#5417](https://github.com/eslint/eslint/issues/5417)) ([#6551](https://github.com/eslint/eslint/issues/6551)) (Nicholas C. Zakas)
* [70da5a8](https://github.com/eslint/eslint/commit/70da5a8) Docs: Correct link to rules page (#fixes 6553) ([#6561](https://github.com/eslint/eslint/issues/6561)) (alberto)
* [666da7c](https://github.com/eslint/eslint/commit/666da7c) Docs: 3.0.0 migration guide ([#6521](https://github.com/eslint/eslint/issues/6521)) (Nicholas C. Zakas)
* [b9bf8fb](https://github.com/eslint/eslint/commit/b9bf8fb) Docs: Update Governance Policy (fixes [#6452](https://github.com/eslint/eslint/issues/6452)) ([#6522](https://github.com/eslint/eslint/issues/6522)) (Nicholas C. Zakas)
* [5f8f3e8](https://github.com/eslint/eslint/commit/5f8f3e8) Docs: Remove Box as a sponsor ([#6529](https://github.com/eslint/eslint/issues/6529)) (Nicholas C. Zakas)
* [7dfe0ad](https://github.com/eslint/eslint/commit/7dfe0ad) Docs: fix max-lines samples (fixes [#6516](https://github.com/eslint/eslint/issues/6516)) ([#6515](https://github.com/eslint/eslint/issues/6515)) (Dmitriy Shekhovtsov)
* [e96177b](https://github.com/eslint/eslint/commit/e96177b) Docs: Add "Proposing a Rule Change" link to CONTRIBUTING.md ([#6511](https://github.com/eslint/eslint/issues/6511)) (Kevin Partington)
* [bea9096](https://github.com/eslint/eslint/commit/bea9096) Docs: Update pull request steps (fixes [#6474](https://github.com/eslint/eslint/issues/6474)) ([#6510](https://github.com/eslint/eslint/issues/6510)) (Nicholas C. Zakas)
* [7bcf6e0](https://github.com/eslint/eslint/commit/7bcf6e0) Docs: Consistent example headings & text pt3 (refs [#5446](https://github.com/eslint/eslint/issues/5446)) ([#6492](https://github.com/eslint/eslint/issues/6492)) (Guy Fraser)
* [1a328d9](https://github.com/eslint/eslint/commit/1a328d9) Docs: Consistent example headings & text pt4 (refs [#5446](https://github.com/eslint/eslint/issues/5446)) ([#6493](https://github.com/eslint/eslint/issues/6493)) (Guy Fraser)
* [ff5765e](https://github.com/eslint/eslint/commit/ff5765e) Docs: Consistent example headings & text pt2 (refs [#5446](https://github.com/eslint/eslint/issues/5446))([#6491](https://github.com/eslint/eslint/issues/6491)) (Guy Fraser)
* [01384fa](https://github.com/eslint/eslint/commit/01384fa) Docs: Fixing typos (refs [#5446](https://github.com/eslint/eslint/issues/5446))([#6494](https://github.com/eslint/eslint/issues/6494)) (Guy Fraser)
* [b7d8c7d](https://github.com/eslint/eslint/commit/b7d8c7d) Docs: more accurate yoda-speak ([#6497](https://github.com/eslint/eslint/issues/6497)) (Tony Lukasavage)
* [c2c6cec](https://github.com/eslint/eslint/commit/c2c6cec) Docs: Mark object-shorthand as fixable. ([#6485](https://github.com/eslint/eslint/issues/6485)) (Nick Heiner)
* [4545123](https://github.com/eslint/eslint/commit/4545123) Docs: Rephrase documentation for `no-duplicate-imports` ([#6463](https://github.com/eslint/eslint/issues/6463)) (Simen Bekkhus)
* [1b133e3](https://github.com/eslint/eslint/commit/1b133e3) Docs: improve `no-native-reassign` and specifying globals (fixes [#5358](https://github.com/eslint/eslint/issues/5358)) ([#6462](https://github.com/eslint/eslint/issues/6462)) (Toru Nagashima)








## Chores


* [c60341f](https://github.com/eslint/eslint/commit/c60341f) Chore: Update index and `meta` for `"eslint:recommended"` (refs [#6403](https://github.com/eslint/eslint/issues/6403)) ([#6539](https://github.com/eslint/eslint/issues/6539)) (Mark Pedrotti)
* [b179373](https://github.com/eslint/eslint/commit/b179373) Chore: Remove dead code in excuteOnFiles (fixes [#6467](https://github.com/eslint/eslint/issues/6467)) ([#6466](https://github.com/eslint/eslint/issues/6466)) (Andrew Hutchings)
* [18fbc4b](https://github.com/eslint/eslint/commit/18fbc4b) Chore: Simplify eslint process exit code (fixes [#6368](https://github.com/eslint/eslint/issues/6368)) ([#6371](https://github.com/eslint/eslint/issues/6371)) (alberto)
