---
layout: post
title: ESLint v2.13.0 released
teaser: "We just pushed ESLint v2.13.0, which is a minor release upgrade of ESLint. This release adds some new features and fixes several bugs found in the previous release."
image: release-notes.png
tags:
  - release
  - minor
authors:
  - nzakas
categories:
  - Release Notes
---

## Highlights

This is a summary of the major changes you need to know about for this version of ESLint.

### Last 2.x Release

This is the last planned 2.x release. The next scheduled release is 3.0.0, which contains several small breaking changes. While there are breaking changes, we expect the impact to users to be very minimal. You can [review the 3.0.0 plan](https://github.com/eslint/eslint/issues/6356) for more information.

### More Autofixing

We are continuing to add autofixing to more rules, and this release we added autofixing to `object-shorthand`, `padded-blocks`, and `no-multiple-empty-lines`.

## Enhancements


* [da30cf9](https://github.com/eslint/eslint/commit/da30cf9) Update: Add fixer for object-shorthand (fixes [#6412](https://github.com/eslint/eslint/issues/6412)) ([#6418](https://github.com/eslint/eslint/issues/6418)) (Nick Heiner)
* [1316db0](https://github.com/eslint/eslint/commit/1316db0) Update: Add `never` option for `func-names` (fixes [#6059](https://github.com/eslint/eslint/issues/6059)) ([#6392](https://github.com/eslint/eslint/issues/6392)) (alberto)
* [1c123e2](https://github.com/eslint/eslint/commit/1c123e2) Update: Add autofix for `padded-blocks` (fixes [#6320](https://github.com/eslint/eslint/issues/6320)) ([#6393](https://github.com/eslint/eslint/issues/6393)) (alberto)
* [5122f73](https://github.com/eslint/eslint/commit/5122f73) Update: no-multiple-empty-lines fixer (fixes [#6225](https://github.com/eslint/eslint/issues/6225)) ([#6226](https://github.com/eslint/eslint/issues/6226)) (Ruurd Moelker)




## Bug Fixes


* [cf223dd](https://github.com/eslint/eslint/commit/cf223dd) Fix: add test for a syntax error (fixes [#6013](https://github.com/eslint/eslint/issues/6013)) ([#6378](https://github.com/eslint/eslint/issues/6378)) (Toru Nagashima)
* [8ec89c8](https://github.com/eslint/eslint/commit/8ec89c8) Fix: `--print-config` return config inside subdir (fixes [#6329](https://github.com/eslint/eslint/issues/6329)) ([#6385](https://github.com/eslint/eslint/issues/6385)) (alberto)
* [4f73240](https://github.com/eslint/eslint/commit/4f73240) Fix: `object-curly-newline` multiline with comments (fixes [#6381](https://github.com/eslint/eslint/issues/6381)) ([#6396](https://github.com/eslint/eslint/issues/6396)) (Toru Nagashima)
* [ed84c4c](https://github.com/eslint/eslint/commit/ed84c4c) Fix: improve `newline-per-chained-call` message (fixes [#6340](https://github.com/eslint/eslint/issues/6340)) ([#6360](https://github.com/eslint/eslint/issues/6360)) (Toru Nagashima)
* [fb49c7f](https://github.com/eslint/eslint/commit/fb49c7f) Fix: nested `extends` with relative path (fixes [#6358](https://github.com/eslint/eslint/issues/6358)) ([#6359](https://github.com/eslint/eslint/issues/6359)) (Toru Nagashima)
* [cfdd524](https://github.com/eslint/eslint/commit/cfdd524) Fix: allow semi as braceless body of statements (fixes [#6386](https://github.com/eslint/eslint/issues/6386)) ([#6391](https://github.com/eslint/eslint/issues/6391)) (alberto)




## Documentation


* [852b6df](https://github.com/eslint/eslint/commit/852b6df) Docs: Delete empty table of links from Code Path Analysis ([#6423](https://github.com/eslint/eslint/issues/6423)) (Mark Pedrotti)
* [c2b5277](https://github.com/eslint/eslint/commit/c2b5277) Docs: Add gitter chat link to Reporting Bugs ([#6430](https://github.com/eslint/eslint/issues/6430)) (Mark Pedrotti)
* [73a9a6d](https://github.com/eslint/eslint/commit/73a9a6d) Docs: Fix links in Configuring ESLint ([#6421](https://github.com/eslint/eslint/issues/6421)) (Mark Pedrotti)
* [9ea4e44](https://github.com/eslint/eslint/commit/9ea4e44) Docs: Update parser reference to `espree` instead of `esprima` ([#6404](https://github.com/eslint/eslint/issues/6404)) (alberto)
* [7f57467](https://github.com/eslint/eslint/commit/7f57467) Docs: Make `fix` param clearer (fixes [#6366](https://github.com/eslint/eslint/issues/6366)) ([#6367](https://github.com/eslint/eslint/issues/6367)) (Nick Heiner)
* [0e7ce72](https://github.com/eslint/eslint/commit/0e7ce72) Docs: Fix rest-spread-spacing's name ([#6365](https://github.com/eslint/eslint/issues/6365)) (cody)
* [6b08cfc](https://github.com/eslint/eslint/commit/6b08cfc) Docs: key-spacing fixable documenation notes (fixes [#6375](https://github.com/eslint/eslint/issues/6375)) ([#6376](https://github.com/eslint/eslint/issues/6376)) (Ruurd Moelker)
* [4b4be3b](https://github.com/eslint/eslint/commit/4b4be3b) Docs: `max-lines` option: fix `skipComments` typo ([#6374](https://github.com/eslint/eslint/issues/6374)) (Jordan Harband)
* [20ab4f6](https://github.com/eslint/eslint/commit/20ab4f6) Docs: Fix wrong link in object-curly-newline ([#6373](https://github.com/eslint/eslint/issues/6373)) (Grant Snodgrass)
* [412ce8d](https://github.com/eslint/eslint/commit/412ce8d) Docs: Fix broken links in no-mixed-operators ([#6372](https://github.com/eslint/eslint/issues/6372)) (Grant Snodgrass)








## Chores


* [2cd90eb](https://github.com/eslint/eslint/commit/2cd90eb) Chore: Fix rule meta description inconsistencies (refs [#5417](https://github.com/eslint/eslint/issues/5417)) ([#6422](https://github.com/eslint/eslint/issues/6422)) (Mark Pedrotti)
* [5e9117e](https://github.com/eslint/eslint/commit/5e9117e) Chore: sort rules in eslint.json (fixes [#6425](https://github.com/eslint/eslint/issues/6425)) ([#6426](https://github.com/eslint/eslint/issues/6426)) (alberto)
* [77697a7](https://github.com/eslint/eslint/commit/77697a7) Chore: Fake config hierarchy fixtures (fixes [#6206](https://github.com/eslint/eslint/issues/6206)) ([#6402](https://github.com/eslint/eslint/issues/6402)) (Gyandeep Singh)
